/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.extensions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionPoint;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionPointAndAreaListener;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionsArea;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginDescriptor;
import org.jetbrains.kotlin.com.intellij.util.NullableFunction;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public abstract class SmartExtensionPoint<Extension, V>
implements ExtensionPointAndAreaListener<Extension> {
    private final Collection<V> myExplicitExtensions;
    private ExtensionPoint<Extension> myExtensionPoint;
    private List<V> myCache;

    protected SmartExtensionPoint(@NotNull Collection<V> explicitExtensions) {
        if (explicitExtensions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "explicitExtensions", "org/jetbrains/kotlin/com/intellij/openapi/extensions/SmartExtensionPoint", "<init>"));
        }
        this.myExplicitExtensions = explicitExtensions;
    }

    @NotNull
    protected abstract ExtensionPoint<Extension> getExtensionPoint();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addExplicitExtension(@NotNull V extension) {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/kotlin/com/intellij/openapi/extensions/SmartExtensionPoint", "addExplicitExtension"));
        }
        Collection<V> collection = this.myExplicitExtensions;
        synchronized (collection) {
            this.myExplicitExtensions.add(extension);
            this.myCache = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeExplicitExtension(@NotNull V extension) {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/kotlin/com/intellij/openapi/extensions/SmartExtensionPoint", "removeExplicitExtension"));
        }
        Collection<V> collection = this.myExplicitExtensions;
        synchronized (collection) {
            this.myExplicitExtensions.remove(extension);
            this.myCache = null;
        }
    }

    @Nullable
    protected abstract V getExtension(@NotNull Extension var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public final List<V> getExtensions() {
        Collection<V> collection = this.myExplicitExtensions;
        // MONITORENTER : collection
        if (this.myCache == null) {
            this.myExtensionPoint = this.getExtensionPoint();
            this.myExtensionPoint.addExtensionPointListener(this);
            this.myCache = new ArrayList<V>(this.myExplicitExtensions);
            this.myCache.addAll(ContainerUtil.mapNotNull(this.myExtensionPoint.getExtensions(), new NullableFunction<Extension, V>(){

                @Override
                @Nullable
                public V fun(Extension extension) {
                    return SmartExtensionPoint.this.getExtension(extension);
                }
            }));
        }
        List<V> list2 = this.myCache;
        // MONITOREXIT : collection
        if (list2 != null) return list2;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/extensions/SmartExtensionPoint", "getExtensions"));
    }

    @Override
    public final void extensionAdded(@NotNull Extension extension, @Nullable PluginDescriptor pluginDescriptor) {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/kotlin/com/intellij/openapi/extensions/SmartExtensionPoint", "extensionAdded"));
        }
        this.dropCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dropCache() {
        Collection<V> collection = this.myExplicitExtensions;
        synchronized (collection) {
            if (this.myCache != null) {
                this.myCache = null;
                this.myExtensionPoint.removeExtensionPointListener(this);
                this.myExtensionPoint = null;
            }
        }
    }

    @Override
    public final void extensionRemoved(@NotNull Extension extension, @Nullable PluginDescriptor pluginDescriptor) {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/kotlin/com/intellij/openapi/extensions/SmartExtensionPoint", "extensionRemoved"));
        }
        this.dropCache();
    }

    @Override
    public void areaReplaced(ExtensionsArea area) {
        this.dropCache();
    }
}

