/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.PrintingMessageCollector;
import org.jetbrains.kotlin.cli.common.repl.GenericReplCompiledEvaluator;
import org.jetbrains.kotlin.cli.common.repl.ReplCheckResult;
import org.jetbrains.kotlin.cli.common.repl.ReplCodeLine;
import org.jetbrains.kotlin.cli.common.repl.ReplCompileResult;
import org.jetbrains.kotlin.cli.common.repl.ReplCompiler;
import org.jetbrains.kotlin.cli.common.repl.ReplEvalResult;
import org.jetbrains.kotlin.cli.common.repl.ReplEvaluator;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.cli.jvm.repl.GenericReplChecker;
import org.jetbrains.kotlin.cli.jvm.repl.GenericReplCompiler;
import org.jetbrains.kotlin.cli.jvm.repl.GenericReplKt;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.daemon.CompileServiceImplKt;
import org.jetbrains.kotlin.daemon.KotlinJvmReplService;
import org.jetbrains.kotlin.daemon.RemoteInputStreamClient;
import org.jetbrains.kotlin.daemon.RemoteOutputStreamClient;
import org.jetbrains.kotlin.daemon.common.DummyProfiler;
import org.jetbrains.kotlin.daemon.common.RemoteInputStream;
import org.jetbrains.kotlin.daemon.common.RemoteOperationsTracer;
import org.jetbrains.kotlin.daemon.common.RemoteOutputStream;
import org.jetbrains.kotlin.script.KotlinScriptDefinition;
import org.jetbrains.kotlin.script.KotlinScriptDefinitionFromAnnotatedTemplate;
import org.jetbrains.kotlin.utils.KotlinPaths;
import org.jetbrains.kotlin.utils.PathUtil;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002:\u0001>By\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0010\u0010\n\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\f\u0018\u00010\u000b\u0012\u0012\u0010\r\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0018\u00010\u000b\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0010\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u0012\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\u0002\u0010\u0017J\u001e\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\f\u00107\u001a\b\u0012\u0004\u0012\u00020608H\u0016J\u001e\u00109\u001a\u00020:2\u0006\u00105\u001a\u0002062\f\u00107\u001a\b\u0012\u0004\u0012\u00020608H\u0016J\u001e\u0010;\u001a\u00020<2\u0006\u00105\u001a\u0002062\f\u00107\u001a\b\u0012\u0004\u0012\u00020608H\u0016J \u0010=\u001a\u0004\u0018\u0001022\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0004R\u001a\u0010\u0018\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001e\u001a\u00020\u001fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020#X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020'X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u001c\u0010,\u001a\u0004\u0018\u00010-8BX\u0082\u0004\u00a2\u0006\f\n\u0004\b0\u0010\u001d\u001a\u0004\b.\u0010/R\u0010\u00101\u001a\u0004\u0018\u000102X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lorg/jetbrains/kotlin/daemon/KotlinJvmReplService;", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCompiler;", "Lorg/jetbrains/kotlin/cli/common/repl/ReplEvaluator;", "disposable", "Lorg/jetbrains/kotlin/com/intellij/openapi/Disposable;", "templateClasspath", "", "Ljava/io/File;", "templateClassName", "", "scriptArgs", "", "", "scriptArgsTypes", "Ljava/lang/Class;", "compilerOutputStreamProxy", "Lorg/jetbrains/kotlin/daemon/common/RemoteOutputStream;", "evalOutputStream", "evalErrorStream", "evalInputStream", "Lorg/jetbrains/kotlin/daemon/common/RemoteInputStream;", "operationsTracer", "Lorg/jetbrains/kotlin/daemon/common/RemoteOperationsTracer;", "(Lcom/intellij/openapi/Disposable;Ljava/util/List;Ljava/lang/String;[Ljava/lang/Object;[Ljava/lang/Class;Lorg/jetbrains/kotlin/daemon/common/RemoteOutputStream;Lorg/jetbrains/kotlin/daemon/common/RemoteOutputStream;Lorg/jetbrains/kotlin/daemon/common/RemoteOutputStream;Lorg/jetbrains/kotlin/daemon/common/RemoteInputStream;Lorg/jetbrains/kotlin/daemon/common/RemoteOperationsTracer;)V", "compiledEvaluator", "Lorg/jetbrains/kotlin/cli/common/repl/GenericReplCompiledEvaluator;", "getCompiledEvaluator", "()Lorg/jetbrains/kotlin/cli/common/repl/GenericReplCompiledEvaluator;", "compiledEvaluator$delegate", "Lkotlin/Lazy;", "compilerMessagesStream", "Ljava/io/PrintStream;", "getCompilerMessagesStream", "()Ljava/io/PrintStream;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "getConfiguration", "()Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "messageCollector", "Lorg/jetbrains/kotlin/daemon/KotlinJvmReplService$KeepFirstErrorMessageCollector;", "getMessageCollector", "()Lorg/jetbrains/kotlin/daemon/KotlinJvmReplService$KeepFirstErrorMessageCollector;", "getOperationsTracer", "()Lorg/jetbrains/kotlin/daemon/common/RemoteOperationsTracer;", "replCompiler", "Lorg/jetbrains/kotlin/cli/jvm/repl/GenericReplCompiler;", "getReplCompiler", "()Lorg/jetbrains/kotlin/cli/jvm/repl/GenericReplCompiler;", "replCompiler$delegate", "scriptDef", "Lorg/jetbrains/kotlin/script/KotlinScriptDefinition;", "check", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCheckResult;", "codeLine", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCodeLine;", "history", "", "compile", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCompileResult;", "eval", "Lorg/jetbrains/kotlin/cli/common/repl/ReplEvalResult;", "makeScriptDefinition", "KeepFirstErrorMessageCollector", "kotlin-compiler"})
public class KotlinJvmReplService
implements ReplCompiler,
ReplEvaluator {
    @NotNull
    private final PrintStream compilerMessagesStream;
    @NotNull
    private final KeepFirstErrorMessageCollector messageCollector;
    @NotNull
    private final CompilerConfiguration configuration;
    private final KotlinScriptDefinition scriptDef;
    private final Lazy replCompiler$delegate;
    private final Lazy compiledEvaluator$delegate;
    @Nullable
    private final RemoteOperationsTracer operationsTracer;
    private static final /* synthetic */ KProperty[] $$delegatedProperties;

    @NotNull
    protected final PrintStream getCompilerMessagesStream() {
        return this.compilerMessagesStream;
    }

    @NotNull
    protected final KeepFirstErrorMessageCollector getMessageCollector() {
        return this.messageCollector;
    }

    @NotNull
    protected final CompilerConfiguration getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected final KotlinScriptDefinition makeScriptDefinition(@NotNull List<? extends File> templateClasspath, @NotNull String templateClassName) {
        Object[] objectArray;
        void destination$iv$iv;
        void $receiver$iv$iv;
        Collection $receiver$iv;
        URLClassLoader uRLClassLoader;
        Intrinsics.checkParameterIsNotNull(templateClasspath, "templateClasspath");
        Intrinsics.checkParameterIsNotNull(templateClassName, "templateClassName");
        Iterable iterable = templateClasspath;
        URLClassLoader uRLClassLoader2 = uRLClassLoader;
        URLClassLoader uRLClassLoader3 = uRLClassLoader;
        void var6_8 = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            File file2 = (File)item$iv$iv;
            objectArray = destination$iv$iv;
            URL uRL = it.toURI().toURL();
            objectArray.add(uRL);
        }
        objectArray = (Object[])destination$iv$iv;
        $receiver$iv = (Collection)objectArray;
        Collection thisCollection$iv = $receiver$iv;
        URL[] uRLArray = thisCollection$iv.toArray(new URL[thisCollection$iv.size()]);
        if (uRLArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        objectArray = uRLArray;
        uRLClassLoader2((URL[])objectArray, this.getClass().getClassLoader());
        URLClassLoader classloader = uRLClassLoader3;
        try {
            Object object;
            Class<?> cls = classloader.loadClass(templateClassName);
            KotlinScriptDefinitionFromAnnotatedTemplate def = new KotlinScriptDefinitionFromAnnotatedTemplate(JvmClassMappingKt.getKotlinClass(cls), null, null, MapsKt.emptyMap());
            this.messageCollector.report(CompilerMessageSeverity.INFO, "New script definition " + templateClassName + ": files pattern = " + "\"" + def.getScriptFilePattern() + "\"" + ", resolver = " + ((object = def.getResolver()) != null && (object = object.getClass()) != null ? ((Class)object).getName() : null), CompilerMessageLocation.NO_LOCATION);
            return def;
        }
        catch (ClassNotFoundException ex) {
            this.messageCollector.report(CompilerMessageSeverity.ERROR, "Cannot find script definition template class " + templateClassName, CompilerMessageLocation.NO_LOCATION);
        }
        catch (Exception ex) {
            this.messageCollector.report(CompilerMessageSeverity.ERROR, "Error processing script definition template " + templateClassName + ": " + ex.getMessage(), CompilerMessageLocation.NO_LOCATION);
        }
        return null;
    }

    private final GenericReplCompiler getReplCompiler() {
        Lazy lazy = this.replCompiler$delegate;
        KotlinJvmReplService kotlinJvmReplService = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (GenericReplCompiler)lazy.getValue();
    }

    private final GenericReplCompiledEvaluator getCompiledEvaluator() {
        Lazy lazy = this.compiledEvaluator$delegate;
        KotlinJvmReplService kotlinJvmReplService = this;
        KProperty kProperty = $$delegatedProperties[1];
        return (GenericReplCompiledEvaluator)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ReplCheckResult check(@NotNull ReplCodeLine codeLine, @NotNull Iterable<ReplCodeLine> history) {
        Intrinsics.checkParameterIsNotNull(codeLine, "codeLine");
        Intrinsics.checkParameterIsNotNull(history, "history");
        RemoteOperationsTracer remoteOperationsTracer = this.operationsTracer;
        if (remoteOperationsTracer != null) {
            remoteOperationsTracer.before("check");
        }
        try {
            Object object = this.getReplCompiler();
            if (object == null || (object = ((GenericReplChecker)object).check(codeLine, history)) == null) {
                CompilerMessageLocation compilerMessageLocation;
                String string = this.messageCollector.getFirstErrorMessage$kotlin_compiler();
                if (string == null) {
                    string = "Unknown error";
                }
                if ((compilerMessageLocation = this.messageCollector.getFirstErrorLocation$kotlin_compiler()) == null) {
                    compilerMessageLocation = CompilerMessageLocation.NO_LOCATION;
                }
                object = new ReplCheckResult.Error(string, compilerMessageLocation);
            }
            Object object2 = object;
            return object2;
        }
        finally {
            block7: {
                RemoteOperationsTracer remoteOperationsTracer2 = this.operationsTracer;
                if (remoteOperationsTracer2 == null) break block7;
                remoteOperationsTracer2.after("check");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ReplCompileResult compile(@NotNull ReplCodeLine codeLine, @NotNull Iterable<ReplCodeLine> history) {
        Intrinsics.checkParameterIsNotNull(codeLine, "codeLine");
        Intrinsics.checkParameterIsNotNull(history, "history");
        RemoteOperationsTracer remoteOperationsTracer = this.operationsTracer;
        if (remoteOperationsTracer != null) {
            remoteOperationsTracer.before("compile");
        }
        try {
            Object object = this.getReplCompiler();
            if (object == null || (object = ((GenericReplCompiler)object).compile(codeLine, history)) == null) {
                CompilerMessageLocation compilerMessageLocation;
                String string = this.messageCollector.getFirstErrorMessage$kotlin_compiler();
                if (string == null) {
                    string = "Unknown error";
                }
                if ((compilerMessageLocation = this.messageCollector.getFirstErrorLocation$kotlin_compiler()) == null) {
                    compilerMessageLocation = CompilerMessageLocation.NO_LOCATION;
                }
                object = new ReplCompileResult.Error(string, compilerMessageLocation);
            }
            Object object2 = object;
            return object2;
        }
        finally {
            block7: {
                RemoteOperationsTracer remoteOperationsTracer2 = this.operationsTracer;
                if (remoteOperationsTracer2 == null) break block7;
                remoteOperationsTracer2.after("compile");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ReplEvalResult eval(@NotNull ReplCodeLine codeLine, @NotNull Iterable<ReplCodeLine> history) {
        Intrinsics.checkParameterIsNotNull(codeLine, "codeLine");
        Intrinsics.checkParameterIsNotNull(history, "history");
        KotlinJvmReplService kotlinJvmReplService = this;
        synchronized (kotlinJvmReplService) {
            RemoteOperationsTracer remoteOperationsTracer;
            Object object;
            RemoteOperationsTracer remoteOperationsTracer2 = this.operationsTracer;
            if (remoteOperationsTracer2 != null) {
                remoteOperationsTracer2.before("eval");
            }
            try {
                Object object2;
                block16: {
                    CompilerMessageLocation compilerMessageLocation;
                    String string;
                    block15: {
                        object2 = this.getReplCompiler();
                        if (object2 == null) break block15;
                        object = object2;
                        Object it = object;
                        object2 = GenericReplKt.compileAndEval((ReplCompiler)it, this.getCompiledEvaluator(), codeLine, history);
                        if (object2 != null) break block16;
                    }
                    if ((string = this.messageCollector.getFirstErrorMessage$kotlin_compiler()) == null) {
                        string = "Unknown error";
                    }
                    if ((compilerMessageLocation = this.messageCollector.getFirstErrorLocation$kotlin_compiler()) == null) {
                        compilerMessageLocation = CompilerMessageLocation.NO_LOCATION;
                    }
                    object2 = new ReplEvalResult.Error.CompileTime(string, compilerMessageLocation);
                }
                object = object2;
                remoteOperationsTracer = this.operationsTracer;
            }
            catch (Throwable throwable) {
                RemoteOperationsTracer remoteOperationsTracer3 = this.operationsTracer;
                if (remoteOperationsTracer3 != null) {
                    remoteOperationsTracer3.after("eval");
                }
                throw throwable;
            }
            if (remoteOperationsTracer != null) {
                remoteOperationsTracer.after("eval");
            }
            Object object3 = object;
            return object3;
        }
    }

    @Nullable
    public final RemoteOperationsTracer getOperationsTracer() {
        return this.operationsTracer;
    }

    /*
     * WARNING - void declaration
     */
    public KotlinJvmReplService(@NotNull Disposable disposable, @NotNull List<? extends File> templateClasspath, @NotNull String templateClassName, @Nullable Object[] scriptArgs, @Nullable Class<?>[] scriptArgsTypes, @NotNull RemoteOutputStream compilerOutputStreamProxy, @Nullable RemoteOutputStream evalOutputStream, @Nullable RemoteOutputStream evalErrorStream, @Nullable RemoteInputStream evalInputStream, @Nullable RemoteOperationsTracer operationsTracer) {
        CompilerConfiguration compilerConfiguration;
        void $receiver;
        Intrinsics.checkParameterIsNotNull(disposable, "disposable");
        Intrinsics.checkParameterIsNotNull(templateClasspath, "templateClasspath");
        Intrinsics.checkParameterIsNotNull(templateClassName, "templateClassName");
        Intrinsics.checkParameterIsNotNull(compilerOutputStreamProxy, "compilerOutputStreamProxy");
        this.operationsTracer = operationsTracer;
        this.compilerMessagesStream = new PrintStream(new BufferedOutputStream(new RemoteOutputStreamClient(compilerOutputStreamProxy, new DummyProfiler()), CompileServiceImplKt.REMOTE_STREAM_BUFFER_SIZE));
        this.messageCollector = new KeepFirstErrorMessageCollector(this.compilerMessagesStream);
        CompilerConfiguration compilerConfiguration2 = new CompilerConfiguration();
        KotlinJvmReplService kotlinJvmReplService = this;
        CompilerConfiguration compilerConfiguration3 = compilerConfiguration2;
        List<File> list2 = PathUtil.getJdkClassesRoots();
        Intrinsics.checkExpressionValueIsNotNull(list2, "PathUtil.getJdkClassesRoots()");
        JvmContentRootsKt.addJvmClasspathRoots((CompilerConfiguration)$receiver, list2);
        KotlinPaths kotlinPaths = PathUtil.getKotlinPathsForCompiler();
        void var15_15 = $receiver;
        KotlinPaths it = kotlinPaths;
        List<File[]> list3 = CollectionsKt.listOf(new File[]{it.getRuntimePath(), it.getReflectPath(), it.getScriptRuntimePath()});
        JvmContentRootsKt.addJvmClasspathRoots((CompilerConfiguration)var15_15, list3);
        JvmContentRootsKt.addJvmClasspathRoots((CompilerConfiguration)$receiver, templateClasspath);
        $receiver.put(CommonConfigurationKeys.MODULE_NAME, "kotlin-script");
        kotlinJvmReplService.configuration = compilerConfiguration = compilerConfiguration2;
        this.scriptDef = this.makeScriptDefinition(templateClasspath, templateClassName);
        this.replCompiler$delegate = LazyKt.lazy((Function0)new Function0<GenericReplCompiler>(this, disposable){
            final /* synthetic */ KotlinJvmReplService this$0;
            final /* synthetic */ Disposable $disposable;

            @Nullable
            public final GenericReplCompiler invoke() {
                return KotlinJvmReplService.access$getScriptDef$p(this.this$0) == null ? (GenericReplCompiler)null : new GenericReplCompiler(this.$disposable, KotlinJvmReplService.access$getScriptDef$p(this.this$0), this.this$0.getConfiguration(), this.this$0.getMessageCollector());
            }
            {
                this.this$0 = kotlinJvmReplService;
                this.$disposable = disposable;
                super(0);
            }
        });
        this.compiledEvaluator$delegate = LazyKt.lazy((Function0)new Function0<GenericReplCompiledEvaluator>(this, evalOutputStream, evalErrorStream, evalInputStream, scriptArgs, (Class[])scriptArgsTypes){
            final /* synthetic */ KotlinJvmReplService this$0;
            final /* synthetic */ RemoteOutputStream $evalOutputStream;
            final /* synthetic */ RemoteOutputStream $evalErrorStream;
            final /* synthetic */ RemoteInputStream $evalInputStream;
            final /* synthetic */ Object[] $scriptArgs;
            final /* synthetic */ Class[] $scriptArgsTypes;

            @NotNull
            public final GenericReplCompiledEvaluator invoke() {
                return this.$evalOutputStream == null && this.$evalErrorStream == null && this.$evalInputStream == null ? new GenericReplCompiledEvaluator((Iterable<? extends File>)JvmContentRootsKt.getJvmClasspathRoots(this.this$0.getConfiguration()), null, this.$scriptArgs, this.$scriptArgsTypes) : (GenericReplCompiledEvaluator)new GenericReplCompiledEvaluator(this, JvmContentRootsKt.getJvmClasspathRoots(this.this$0.getConfiguration()), null, this.$scriptArgs, this.$scriptArgsTypes){
                    @NotNull
                    private final PrintStream out;
                    @NotNull
                    private final PrintStream err;
                    @NotNull
                    private final BufferedInputStream in;
                    final /* synthetic */ compiledEvaluator.2 this$0;

                    @NotNull
                    public final PrintStream getOut() {
                        return this.out;
                    }

                    @NotNull
                    public final PrintStream getErr() {
                        return this.err;
                    }

                    @NotNull
                    public final BufferedInputStream getIn() {
                        return this.in;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public <T> T evalWithIO(@NotNull Function0<? extends T> body) {
                        Intrinsics.checkParameterIsNotNull(body, "body");
                        PrintStream prevOut = System.out;
                        System.setOut(this.out);
                        PrintStream prevErr = System.err;
                        System.setErr(this.err);
                        InputStream prevIn = System.in;
                        System.setIn(this.in);
                        try {
                            T t = body.invoke();
                            return t;
                        }
                        finally {
                            System.setIn(prevIn);
                            System.setErr(prevErr);
                            System.setOut(prevOut);
                        }
                    }
                    {
                        this.this$0 = $outer;
                        super($super_call_param$1, $super_call_param$2, $super_call_param$3, $super_call_param$4);
                        RemoteOutputStream remoteOutputStream = this.this$0.$evalOutputStream;
                        if (remoteOutputStream == null) {
                            Intrinsics.throwNpe();
                        }
                        this.out = new PrintStream(new BufferedOutputStream(new RemoteOutputStreamClient(remoteOutputStream, new DummyProfiler()), CompileServiceImplKt.REMOTE_STREAM_BUFFER_SIZE));
                        RemoteOutputStream remoteOutputStream2 = this.this$0.$evalErrorStream;
                        if (remoteOutputStream2 == null) {
                            Intrinsics.throwNpe();
                        }
                        this.err = new PrintStream(new BufferedOutputStream(new RemoteOutputStreamClient(remoteOutputStream2, new DummyProfiler()), CompileServiceImplKt.REMOTE_STREAM_BUFFER_SIZE));
                        RemoteInputStream remoteInputStream = this.this$0.$evalInputStream;
                        if (remoteInputStream == null) {
                            Intrinsics.throwNpe();
                        }
                        this.in = new BufferedInputStream(new RemoteInputStreamClient(remoteInputStream, new DummyProfiler()), CompileServiceImplKt.REMOTE_STREAM_BUFFER_SIZE);
                    }
                };
            }
            {
                this.this$0 = kotlinJvmReplService;
                this.$evalOutputStream = remoteOutputStream;
                this.$evalErrorStream = remoteOutputStream2;
                this.$evalInputStream = remoteInputStream;
                this.$scriptArgs = objectArray;
                this.$scriptArgsTypes = classArray;
                super(0);
            }
        });
    }

    static {
        $$delegatedProperties = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Reflection.getOrCreateKotlinClass(KotlinJvmReplService.class), "replCompiler", "getReplCompiler()Lorg/jetbrains/kotlin/cli/jvm/repl/GenericReplCompiler;")), Reflection.property1(new PropertyReference1Impl(Reflection.getOrCreateKotlinClass(KotlinJvmReplService.class), "compiledEvaluator", "getCompiledEvaluator()Lorg/jetbrains/kotlin/cli/common/repl/GenericReplCompiledEvaluator;"))};
    }

    @Override
    public <T> T evalWithIO(@NotNull Function0<? extends T> body) {
        Intrinsics.checkParameterIsNotNull(body, "body");
        return ReplEvaluator.DefaultImpls.evalWithIO(this, body);
    }

    @Nullable
    public static final /* synthetic */ KotlinScriptDefinition access$getScriptDef$p(KotlinJvmReplService $this) {
        return $this.scriptDef;
    }

    @Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J \u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u0006H\u0016R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/daemon/KotlinJvmReplService$KeepFirstErrorMessageCollector;", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "compilerMessagesStream", "Ljava/io/PrintStream;", "(Ljava/io/PrintStream;)V", "firstErrorLocation", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageLocation;", "getFirstErrorLocation$kotlin_compiler", "()Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageLocation;", "setFirstErrorLocation$kotlin_compiler", "(Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageLocation;)V", "firstErrorMessage", "", "getFirstErrorMessage$kotlin_compiler", "()Ljava/lang/String;", "setFirstErrorMessage$kotlin_compiler", "(Ljava/lang/String;)V", "innerCollector", "Lorg/jetbrains/kotlin/cli/common/messages/PrintingMessageCollector;", "clear", "", "hasErrors", "", "report", "severity", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "message", "location", "kotlin-compiler"})
    protected static final class KeepFirstErrorMessageCollector
    implements MessageCollector {
        private final PrintingMessageCollector innerCollector;
        @Nullable
        private String firstErrorMessage;
        @Nullable
        private CompilerMessageLocation firstErrorLocation;

        @Nullable
        public final String getFirstErrorMessage$kotlin_compiler() {
            return this.firstErrorMessage;
        }

        public final void setFirstErrorMessage$kotlin_compiler(@Nullable String string) {
            this.firstErrorMessage = string;
        }

        @Nullable
        public final CompilerMessageLocation getFirstErrorLocation$kotlin_compiler() {
            return this.firstErrorLocation;
        }

        public final void setFirstErrorLocation$kotlin_compiler(@Nullable CompilerMessageLocation compilerMessageLocation) {
            this.firstErrorLocation = compilerMessageLocation;
        }

        @Override
        public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message, @NotNull CompilerMessageLocation location2) {
            Intrinsics.checkParameterIsNotNull((Object)severity, "severity");
            Intrinsics.checkParameterIsNotNull(message, "message");
            Intrinsics.checkParameterIsNotNull(location2, "location");
            if (this.firstErrorMessage == null && severity.isError()) {
                this.firstErrorMessage = message;
                this.firstErrorLocation = location2;
            }
            this.innerCollector.report(severity, message, location2);
        }

        @Override
        public boolean hasErrors() {
            return this.innerCollector.hasErrors();
        }

        @Override
        public void clear() {
            this.innerCollector.clear();
        }

        public KeepFirstErrorMessageCollector(@NotNull PrintStream compilerMessagesStream) {
            Intrinsics.checkParameterIsNotNull(compilerMessagesStream, "compilerMessagesStream");
            this.innerCollector = new PrintingMessageCollector(compilerMessagesStream, MessageRenderer.WITHOUT_PATHS, false);
        }
    }
}

