/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.operation;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableCollection;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.operation.IntrinsicAssignmentTranslator;
import org.jetbrains.kotlin.js.translate.operation.OverloadedAssignmentTranslator;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslationUtils;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslator;
import org.jetbrains.kotlin.js.translate.reference.BackingFieldAccessTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

public abstract class AssignmentTranslator
extends AbstractTranslator {
    @NotNull
    protected final KtBinaryExpression expression;
    protected final boolean isVariableReassignment;

    public static boolean isAssignmentOperator(KtToken operationToken) {
        return ((ImmutableCollection)((Object)OperatorConventions.ASSIGNMENT_OPERATIONS.keySet())).contains(operationToken) || PsiUtils.isAssignment(operationToken);
    }

    @NotNull
    public static JsExpression translate(@NotNull KtBinaryExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/operation/AssignmentTranslator", "translate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/operation/AssignmentTranslator", "translate"));
        }
        if (TranslationUtils.hasCorrespondingFunctionIntrinsic(context, expression)) {
            JsExpression jsExpression = IntrinsicAssignmentTranslator.doTranslate(expression, context);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/AssignmentTranslator", "translate"));
            }
            return jsExpression;
        }
        JsExpression jsExpression = OverloadedAssignmentTranslator.doTranslate(expression, context);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/AssignmentTranslator", "translate"));
        }
        return jsExpression;
    }

    protected AssignmentTranslator(@NotNull KtBinaryExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/operation/AssignmentTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/operation/AssignmentTranslator", "<init>"));
        }
        super(context);
        this.expression = expression;
        this.isVariableReassignment = BindingUtils.isVariableReassignment(context.bindingContext(), expression);
        KtExpression left = expression.getLeft();
        assert (left != null) : "No left-hand side: " + expression.getText();
    }

    protected final AccessTranslator createAccessTranslator(KtExpression left, boolean forceOrderOfEvaluation) {
        if (AssignmentTranslator.isReferenceToBackingFieldFromConstructor(left, this.context())) {
            KtSimpleNameExpression simpleName2 = PsiUtils.getSimpleName(left);
            assert (simpleName2 != null);
            return BackingFieldAccessTranslator.newInstance(simpleName2, this.context());
        }
        return AccessTranslationUtils.getAccessTranslator(left, this.context(), forceOrderOfEvaluation);
    }

    private static boolean isReferenceToBackingFieldFromConstructor(@NotNull KtExpression expression, @NotNull TranslationContext context) {
        KtDotQualifiedExpression qualifiedExpression;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/operation/AssignmentTranslator", "isReferenceToBackingFieldFromConstructor"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/operation/AssignmentTranslator", "isReferenceToBackingFieldFromConstructor"));
        }
        if (expression instanceof KtSimpleNameExpression) {
            KtSimpleNameExpression nameExpression = (KtSimpleNameExpression)expression;
            DeclarationDescriptor descriptor2 = BindingUtils.getDescriptorForReferenceExpression(context.bindingContext(), nameExpression);
            return AssignmentTranslator.isReferenceToBackingFieldFromConstructor(descriptor2, context);
        }
        if (expression instanceof KtDotQualifiedExpression && (qualifiedExpression = (KtDotQualifiedExpression)expression).getReceiverExpression() instanceof KtThisExpression && qualifiedExpression.getSelectorExpression() instanceof KtSimpleNameExpression) {
            KtSimpleNameExpression nameExpression = (KtSimpleNameExpression)qualifiedExpression.getSelectorExpression();
            DeclarationDescriptor descriptor3 = BindingUtils.getDescriptorForReferenceExpression(context.bindingContext(), nameExpression);
            return AssignmentTranslator.isReferenceToBackingFieldFromConstructor(descriptor3, context);
        }
        return false;
    }

    private static boolean isReferenceToBackingFieldFromConstructor(@Nullable DeclarationDescriptor descriptor2, @NotNull TranslationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/operation/AssignmentTranslator", "isReferenceToBackingFieldFromConstructor"));
        }
        if (!(descriptor2 instanceof PropertyDescriptor)) {
            return false;
        }
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor2;
        if (!(context.getDeclarationDescriptor() instanceof ClassDescriptor)) {
            return false;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)context.getDeclarationDescriptor();
        if (classDescriptor != propertyDescriptor.getContainingDeclaration()) {
            return false;
        }
        return !propertyDescriptor.isVar();
    }
}

