/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import org.gradle.api.Incubating;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ConfigurationVariant;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.language.jvm.tasks.ProcessResources;

@Incubating
public class JavaLibraryPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPluginManager().apply(JavaPlugin.class);
        JavaPluginConvention convention = (JavaPluginConvention)project.getConvention().getPlugins().get("java");
        ConfigurationContainer configurations = project.getConfigurations();
        this.addApiToMainSourceSet(project, convention, configurations);
    }

    private void addApiToMainSourceSet(Project project, JavaPluginConvention convention, ConfigurationContainer configurations) {
        SourceSet sourceSet = (SourceSet)convention.getSourceSets().getByName("main");
        this.defineApiConfigurationsForSourceSet(sourceSet, configurations);
        String apiElementsConfigurationName = sourceSet.getApiElementsConfigurationName();
        NamedDomainObjectContainer variants = ((Configuration)configurations.findByName(apiElementsConfigurationName)).getOutgoing().getVariants();
        JavaCompile javaCompile = (JavaCompile)project.getTasks().findByName(sourceSet.getCompileJavaTaskName());
        ProcessResources processResources = (ProcessResources)project.getTasks().findByName(sourceSet.getProcessResourcesTaskName());
        this.addVariant("classes", "org.gradle.java.classes.directory", (NamedDomainObjectContainer<ConfigurationVariant>)variants, (Task)javaCompile, javaCompile.getDestinationDir());
        this.addVariant("resources", "org.gradle.java.resources.directory", (NamedDomainObjectContainer<ConfigurationVariant>)variants, (Task)processResources, processResources.getDestinationDir());
    }

    private void addVariant(String variant, String type, NamedDomainObjectContainer<ConfigurationVariant> variants, Task builtBy, File file) {
        ConfigurationVariant configurationVariant = (ConfigurationVariant)variants.create(variant);
        configurationVariant.artifact((Object)ImmutableMap.of((Object)"file", (Object)file, (Object)"type", (Object)type, (Object)"builtBy", (Object)builtBy));
    }

    private void defineApiConfigurationsForSourceSet(SourceSet sourceSet, ConfigurationContainer configurations) {
        Configuration apiConfiguration = (Configuration)configurations.maybeCreate(sourceSet.getApiConfigurationName());
        apiConfiguration.setVisible(false);
        apiConfiguration.setDescription("API dependencies for " + sourceSet + ".");
        apiConfiguration.setCanBeResolved(false);
        apiConfiguration.setCanBeConsumed(false);
        Configuration apiElementsConfiguration = configurations.getByName(sourceSet.getApiElementsConfigurationName());
        apiElementsConfiguration.extendsFrom(new Configuration[]{apiConfiguration});
        Configuration implementationConfiguration = (Configuration)configurations.maybeCreate(sourceSet.getImplementationConfigurationName());
        implementationConfiguration.extendsFrom(new Configuration[]{apiConfiguration});
        Configuration compileConfiguration = (Configuration)configurations.findByName(sourceSet.getCompileConfigurationName());
        apiConfiguration.extendsFrom(new Configuration[]{compileConfiguration});
    }
}

