/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.execution.internal.TaskOperationDescriptor;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.initialization.BuildEventConsumer;
import org.gradle.internal.progress.BuildOperationInternal;
import org.gradle.internal.progress.InternalBuildListener;
import org.gradle.internal.progress.OperationResult;
import org.gradle.internal.progress.OperationStartEvent;
import org.gradle.tooling.internal.provider.BuildClientSubscriptions;
import org.gradle.tooling.internal.provider.events.AbstractTaskResult;
import org.gradle.tooling.internal.provider.events.DefaultFailure;
import org.gradle.tooling.internal.provider.events.DefaultTaskDescriptor;
import org.gradle.tooling.internal.provider.events.DefaultTaskFailureResult;
import org.gradle.tooling.internal.provider.events.DefaultTaskFinishedProgressEvent;
import org.gradle.tooling.internal.provider.events.DefaultTaskSkippedResult;
import org.gradle.tooling.internal.provider.events.DefaultTaskStartedProgressEvent;
import org.gradle.tooling.internal.provider.events.DefaultTaskSuccessResult;

class ClientForwardingTaskListener
implements InternalBuildListener {
    private final BuildEventConsumer eventConsumer;
    private final BuildClientSubscriptions clientSubscriptions;
    private final InternalBuildListener delegate;
    private final Set<Object> skipEvents = new HashSet<Object>();

    ClientForwardingTaskListener(BuildEventConsumer eventConsumer, BuildClientSubscriptions clientSubscriptions, InternalBuildListener delegate) {
        this.eventConsumer = eventConsumer;
        this.clientSubscriptions = clientSubscriptions;
        this.delegate = delegate;
    }

    public void started(BuildOperationInternal buildOperation, OperationStartEvent startEvent) {
        if (this.skipEvents.contains(buildOperation.getParentId())) {
            this.skipEvents.add(buildOperation.getId());
            return;
        }
        if (buildOperation.getOperationDescriptor() instanceof TaskOperationDescriptor) {
            if (this.clientSubscriptions.isSendTaskProgressEvents()) {
                TaskInternal task = ((TaskOperationDescriptor)buildOperation.getOperationDescriptor()).getTask();
                this.eventConsumer.dispatch((Object)new DefaultTaskStartedProgressEvent(startEvent.getStartTime(), this.toTaskDescriptor(buildOperation, task)));
            } else {
                this.skipEvents.add(buildOperation.getId());
            }
        } else {
            this.delegate.started(buildOperation, startEvent);
        }
    }

    public void finished(BuildOperationInternal buildOperation, OperationResult finishEvent) {
        if (this.skipEvents.remove(buildOperation.getId())) {
            return;
        }
        if (buildOperation.getOperationDescriptor() instanceof TaskOperationDescriptor) {
            TaskInternal task = ((TaskOperationDescriptor)buildOperation.getOperationDescriptor()).getTask();
            this.eventConsumer.dispatch((Object)new DefaultTaskFinishedProgressEvent(finishEvent.getEndTime(), this.toTaskDescriptor(buildOperation, task), ClientForwardingTaskListener.toTaskResult(task, finishEvent)));
        } else {
            this.delegate.finished(buildOperation, finishEvent);
        }
    }

    private DefaultTaskDescriptor toTaskDescriptor(BuildOperationInternal buildOperation, TaskInternal task) {
        Object id = buildOperation.getId();
        String taskIdentityPath = buildOperation.getName();
        String displayName = buildOperation.getDisplayName();
        String taskPath = task.getIdentityPath().toString();
        Object parentId = this.getParentId(buildOperation);
        return new DefaultTaskDescriptor(id, taskIdentityPath, taskPath, displayName, parentId);
    }

    private Object getParentId(BuildOperationInternal buildOperation) {
        return this.clientSubscriptions.isSendBuildProgressEvents() ? buildOperation.getParentId() : null;
    }

    private static AbstractTaskResult toTaskResult(TaskInternal task, OperationResult result) {
        TaskStateInternal state = task.getState();
        long startTime = result.getStartTime();
        long endTime = result.getEndTime();
        if (state.getUpToDate()) {
            return new DefaultTaskSuccessResult(startTime, endTime, true, state.isFromCache(), state.getSkipMessage());
        }
        if (state.getSkipped()) {
            return new DefaultTaskSkippedResult(startTime, endTime, state.getSkipMessage());
        }
        Throwable failure = result.getFailure();
        if (failure == null) {
            return new DefaultTaskSuccessResult(startTime, endTime, false, state.isFromCache(), "SUCCESS");
        }
        return new DefaultTaskFailureResult(startTime, endTime, Collections.singletonList(DefaultFailure.fromThrowable((Throwable)failure)));
    }
}

