/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultImmutableAttributesFactory
implements ImmutableAttributesFactory {
    private final ImmutableAttributes root = new ImmutableAttributes(this);
    private final Map<ImmutableAttributes, List<ImmutableAttributes>> children = Maps.newHashMap();

    public DefaultImmutableAttributesFactory() {
        this.children.put(this.root, new ArrayList());
    }

    public int size() {
        return this.children.size();
    }

    @Override
    public Builder builder() {
        return this.root.builder;
    }

    @Override
    public Builder builder(ImmutableAttributes from) {
        return from.builder != null ? from.builder : new Builder(from);
    }

    @Override
    public ImmutableAttributes of(Attribute<?> key, Object value) {
        return this.concat(this.root, key, value);
    }

    @Override
    public synchronized ImmutableAttributes concat(ImmutableAttributes node, Attribute<?> key, Object value) {
        ArrayList nodeChildren = this.children.get(node);
        if (nodeChildren == null) {
            nodeChildren = Lists.newArrayList();
            this.children.put(node, nodeChildren);
        }
        for (ImmutableAttributes child : nodeChildren) {
            if (!child.attribute.equals(key) || !child.value.equals(value)) continue;
            return child;
        }
        ImmutableAttributes child = new ImmutableAttributes(node, key, value, this);
        nodeChildren.add(child);
        return child;
    }

    public ImmutableAttributes getRoot() {
        return this.root;
    }

    @Override
    public ImmutableAttributes concat(ImmutableAttributes attributes, ImmutableAttributes state) {
        Builder builder = new Builder(attributes);
        for (Attribute<?> attribute : state.keySet()) {
            builder = builder.addAttribute(attribute, state.getAttribute(attribute));
        }
        return builder.get();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Builder {
        private final ImmutableAttributes node;

        public Builder(ImmutableAttributes from) {
            this.node = from;
        }

        public Builder addAttribute(Attribute<?> attribute, Object value) {
            ImmutableAttributes cur = this.node;
            if (!cur.contains(attribute)) {
                cur = DefaultImmutableAttributesFactory.this.concat(cur, attribute, value);
            }
            return cur.builder;
        }

        public Builder addAny(Object key, Object value) {
            return this.addAttribute(this.asAttribute(key), value);
        }

        public ImmutableAttributes get() {
            return this.node;
        }

        private Attribute<?> asAttribute(Object rawKey) {
            if (rawKey instanceof Attribute) {
                return (Attribute)rawKey;
            }
            return Attribute.of(rawKey.toString(), String.class);
        }
    }
}

