/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import com.google.common.base.Objects;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.jcip.annotations.ThreadSafe;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.cache.PersistentIndexedCacheParameters;
import org.gradle.cache.internal.AbstractCrossProcessCacheAccess;
import org.gradle.cache.internal.AbstractFileAccess;
import org.gradle.cache.internal.AsyncCacheAccess;
import org.gradle.cache.internal.CacheAccessWorker;
import org.gradle.cache.internal.CacheCoordinator;
import org.gradle.cache.internal.CacheDecorator;
import org.gradle.cache.internal.CacheInitializationAction;
import org.gradle.cache.internal.DefaultMultiProcessSafePersistentIndexedCache;
import org.gradle.cache.internal.FileAccess;
import org.gradle.cache.internal.FileLock;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.cache.internal.FixedExclusiveModeCrossProcessCacheAccess;
import org.gradle.cache.internal.FixedSharedModeCrossProcessCacheAccess;
import org.gradle.cache.internal.LockOnDemandCrossProcessCacheAccess;
import org.gradle.cache.internal.LockTimeoutException;
import org.gradle.cache.internal.MultiProcessSafePersistentIndexedCache;
import org.gradle.cache.internal.btree.BTreePersistentIndexedCache;
import org.gradle.cache.internal.cacheops.CacheAccessOperationsStack;
import org.gradle.cache.internal.filelock.LockOptions;
import org.gradle.internal.Factories;
import org.gradle.internal.Factory;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.StoppableExecutor;
import org.gradle.internal.serialize.Serializer;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class DefaultCacheAccess
implements CacheCoordinator {
    private static final Logger LOG = Logging.getLogger(DefaultCacheAccess.class);
    private final String cacheDisplayName;
    private final File baseDir;
    private final FileLockManager lockManager;
    private final ExecutorFactory executorFactory;
    private final FileAccess fileAccess = new UnitOfWorkFileAccess();
    private final Map<String, IndexedCacheEntry> caches = new HashMap<String, IndexedCacheEntry>();
    private final AbstractCrossProcessCacheAccess crossProcessCacheAccess;
    private final LockOptions lockOptions;
    private StoppableExecutor cacheUpdateExecutor;
    private CacheAccessWorker cacheAccessWorker;
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private boolean open;
    private Thread owner;
    private FileLock fileLock;
    private FileLock.State stateAtOpen;
    private Runnable fileLockHeldByOwner;
    private boolean contended;
    private final CacheAccessOperationsStack operations;
    private int cacheClosedCount;

    public DefaultCacheAccess(String cacheDisplayName, File lockTarget, LockOptions lockOptions, File baseDir, FileLockManager lockManager, CacheInitializationAction initializationAction, ExecutorFactory executorFactory) {
        this.cacheDisplayName = cacheDisplayName;
        this.lockOptions = lockOptions;
        this.baseDir = baseDir;
        this.lockManager = lockManager;
        this.executorFactory = executorFactory;
        this.operations = new CacheAccessOperationsStack();
        Action<FileLock> onFileLockAcquireAction = new Action<FileLock>(){

            public void execute(FileLock fileLock) {
                DefaultCacheAccess.this.afterLockAcquire(fileLock);
            }
        };
        Action<FileLock> onFileLockReleaseAction = new Action<FileLock>(){

            public void execute(FileLock fileLock) {
                DefaultCacheAccess.this.beforeLockRelease(fileLock);
            }
        };
        switch (lockOptions.getMode()) {
            case Shared: {
                this.crossProcessCacheAccess = new FixedSharedModeCrossProcessCacheAccess(cacheDisplayName, lockTarget, lockOptions, lockManager, initializationAction, onFileLockAcquireAction, onFileLockReleaseAction);
                break;
            }
            case Exclusive: {
                this.crossProcessCacheAccess = new FixedExclusiveModeCrossProcessCacheAccess(cacheDisplayName, lockTarget, lockOptions, lockManager, initializationAction, onFileLockAcquireAction, onFileLockReleaseAction);
                break;
            }
            case None: {
                this.crossProcessCacheAccess = new LockOnDemandCrossProcessCacheAccess(cacheDisplayName, lockTarget, lockOptions.withMode(FileLockManager.LockMode.Exclusive), lockManager, this.lock, initializationAction, onFileLockAcquireAction, onFileLockReleaseAction);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private synchronized AsyncCacheAccess getCacheAccessWorker() {
        if (this.cacheAccessWorker == null) {
            this.cacheAccessWorker = new CacheAccessWorker(this.cacheDisplayName, this);
            this.cacheUpdateExecutor = this.executorFactory.create("Cache worker for " + this.cacheDisplayName);
            this.cacheUpdateExecutor.execute((Runnable)this.cacheAccessWorker);
        }
        return this.cacheAccessWorker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        this.lock.lock();
        try {
            if (this.open) {
                throw new IllegalStateException("Cache is already open.");
            }
            this.takeOwnershipNow();
            try {
                this.crossProcessCacheAccess.open();
                this.open = true;
            }
            finally {
                this.releaseOwnership();
            }
        }
        catch (Throwable throwable) {
            this.crossProcessCacheAccess.close();
            throw UncheckedException.throwAsUncheckedException((Throwable)throwable);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        if (this.cacheAccessWorker != null) {
            this.cacheAccessWorker.stop();
            this.cacheAccessWorker = null;
        }
        if (this.cacheUpdateExecutor != null) {
            this.cacheUpdateExecutor.stop();
            this.cacheUpdateExecutor = null;
        }
        this.lock.lock();
        try {
            this.takeOwnershipNow();
            if (this.fileLockHeldByOwner != null) {
                this.fileLockHeldByOwner.run();
            }
            this.crossProcessCacheAccess.close();
            if (this.cacheClosedCount != 1) {
                LOG.debug("Cache {} was closed {} times.", (Object)this.cacheDisplayName, (Object)this.cacheClosedCount);
            }
        }
        finally {
            this.owner = null;
            this.lock.unlock();
        }
    }

    @Override
    public void useCache(Runnable action) {
        this.useCache(Factories.toFactory((Runnable)action));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T useCache(Factory<? extends T> factory) {
        boolean wasStarted;
        if (this.lockOptions != null && this.lockOptions.getMode() == FileLockManager.LockMode.Shared) {
            throw new UnsupportedOperationException("Not implemented yet.");
        }
        this.lock.lock();
        try {
            this.takeOwnership();
            wasStarted = this.onStartWork();
        }
        finally {
            this.lock.unlock();
        }
        try {
            Object object = factory.create();
            return (T)object;
        }
        finally {
            this.lock.lock();
            try {
                try {
                    if (wasStarted) {
                        this.onEndWork();
                    }
                }
                finally {
                    this.releaseOwnership();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private void takeOwnership() {
        while (this.owner != null && this.owner != Thread.currentThread()) {
            try {
                this.condition.await();
            }
            catch (InterruptedException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }
        this.owner = Thread.currentThread();
        this.operations.pushCacheAction();
    }

    private void takeOwnershipNow() {
        if (this.owner != null && this.owner != Thread.currentThread()) {
            throw new IllegalStateException(String.format("Cannot take ownership of %s as it is currently being used by another thread.", this.cacheDisplayName));
        }
        this.owner = Thread.currentThread();
        this.operations.pushCacheAction();
    }

    private void releaseOwnership() {
        this.operations.popCacheAction();
        if (!this.operations.isInCacheAction()) {
            this.owner = null;
            this.condition.signalAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T longRunningOperation(Factory<? extends T> action) {
        boolean wasEnded = this.startLongRunningOperation();
        try {
            Object object = action.create();
            return (T)object;
        }
        finally {
            this.finishLongRunningOperation(wasEnded);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startLongRunningOperation() {
        boolean wasEnded;
        this.lock.lock();
        try {
            if (this.lockOptions.getMode() != FileLockManager.LockMode.None) {
                throw new UnsupportedOperationException("Long running operation not supported for this lock mode.");
            }
            if (this.operations.isInCacheAction()) {
                this.checkThreadIsOwner();
                wasEnded = this.onEndWork();
                this.owner = null;
                this.condition.signalAll();
            } else {
                wasEnded = false;
            }
            this.operations.pushLongRunningOperation();
        }
        finally {
            this.lock.unlock();
        }
        return wasEnded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishLongRunningOperation(boolean wasEnded) {
        this.lock.lock();
        try {
            this.operations.popLongRunningOperation();
            if (this.operations.isInCacheAction()) {
                this.restoreOwner();
                if (wasEnded) {
                    this.onStartWork();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkThreadIsOwner() {
        this.lock.lock();
        try {
            if (this.owner != Thread.currentThread()) {
                throw new IllegalStateException(String.format("Cannot start long running operation, as the %s has not been locked.", this.cacheDisplayName));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreOwner() {
        this.lock.lock();
        try {
            while (this.owner != null) {
                try {
                    this.condition.await();
                }
                catch (InterruptedException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
            this.owner = Thread.currentThread();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void longRunningOperation(Runnable action) {
        this.longRunningOperation(Factories.toFactory((Runnable)action));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> MultiProcessSafePersistentIndexedCache<K, V> newCache(final PersistentIndexedCacheParameters<K, V> parameters) {
        this.lock.lock();
        IndexedCacheEntry entry = this.caches.get(parameters.getCacheName());
        try {
            if (entry == null) {
                final File cacheFile = new File(this.baseDir, parameters.getCacheName() + ".bin");
                LOG.info("Creating new cache for {}, path {}, access {}", new Object[]{parameters.getCacheName(), cacheFile, this});
                Factory indexedCacheFactory = new Factory<BTreePersistentIndexedCache<K, V>>(){

                    public BTreePersistentIndexedCache<K, V> create() {
                        return DefaultCacheAccess.this.doCreateCache(cacheFile, parameters.getKeySerializer(), parameters.getValueSerializer());
                    }
                };
                MultiProcessSafePersistentIndexedCache indexedCache = new DefaultMultiProcessSafePersistentIndexedCache(indexedCacheFactory, this.fileAccess);
                CacheDecorator decorator = parameters.getCacheDecorator();
                if (decorator != null) {
                    indexedCache = decorator.decorate(cacheFile.getAbsolutePath(), parameters.getCacheName(), indexedCache, this.crossProcessCacheAccess, this.getCacheAccessWorker());
                    if (this.fileLock == null) {
                        this.useCache(new Runnable(){

                            public void run() {
                            }
                        });
                    }
                }
                entry = new IndexedCacheEntry(parameters, indexedCache);
                this.caches.put(parameters.getCacheName(), entry);
                if (this.fileLock != null) {
                    indexedCache.afterLockAcquire(this.stateAtOpen);
                }
            } else {
                entry.assertCompatibleCacheParameters(parameters);
            }
        }
        finally {
            this.lock.unlock();
        }
        return entry.getCache();
    }

    @Override
    public synchronized void flush() {
        if (this.cacheAccessWorker != null) {
            this.cacheAccessWorker.flush();
        }
    }

    <K, V> BTreePersistentIndexedCache<K, V> doCreateCache(File cacheFile, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        return new BTreePersistentIndexedCache<K, V>(cacheFile, keySerializer, valueSerializer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void afterLockAcquire(FileLock fileLock) {
        assert (this.fileLock == null);
        this.fileLock = fileLock;
        this.stateAtOpen = fileLock.getState();
        this.takeOwnershipNow();
        try {
            for (IndexedCacheEntry entry : this.caches.values()) {
                entry.getCache().afterLockAcquire(this.stateAtOpen);
            }
        }
        finally {
            this.releaseOwnership();
        }
        if (this.lockOptions.getMode() == FileLockManager.LockMode.None) {
            this.lockManager.allowContention(fileLock, this.whenContended());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beforeLockRelease(FileLock fileLock) {
        assert (this.fileLock == fileLock);
        try {
            ++this.cacheClosedCount;
            this.takeOwnershipNow();
            try {
                for (IndexedCacheEntry entry : this.caches.values()) {
                    entry.getCache().finishWork();
                }
                FileLock.State state = fileLock.getState();
                for (IndexedCacheEntry entry : this.caches.values()) {
                    entry.getCache().beforeLockRelease(state);
                }
            }
            finally {
                this.releaseOwnership();
            }
        }
        finally {
            this.fileLock = null;
            this.stateAtOpen = null;
            this.contended = false;
        }
    }

    private boolean onStartWork() {
        if (this.fileLockHeldByOwner != null) {
            return false;
        }
        this.fileLockHeldByOwner = this.crossProcessCacheAccess.acquireFileLock();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean onEndWork() {
        if (this.fileLockHeldByOwner == null) {
            return false;
        }
        if (this.contended) {
            try {
                this.fileLockHeldByOwner.run();
            }
            finally {
                this.fileLockHeldByOwner = null;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileLock getLock() {
        this.lock.lock();
        try {
            if (Thread.currentThread() != this.owner) {
                throw new IllegalStateException(String.format("The %s has not been locked for this thread. File lock: %s, owner: %s", this.cacheDisplayName, this.fileLock != null, this.owner));
            }
        }
        finally {
            this.lock.unlock();
        }
        return this.fileLock;
    }

    Runnable whenContended() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block13: {
                    DefaultCacheAccess.this.lock.lock();
                    try {
                        LOG.debug("Detected file lock contention of {} (fileLock={}, contended={}, owner={})", new Object[]{DefaultCacheAccess.this.cacheDisplayName, DefaultCacheAccess.this.fileLock != null, DefaultCacheAccess.this.contended, DefaultCacheAccess.this.owner});
                        if (DefaultCacheAccess.this.fileLock == null) {
                            return;
                        }
                        if (DefaultCacheAccess.this.owner != null) {
                            DefaultCacheAccess.this.contended = true;
                            return;
                        }
                        DefaultCacheAccess.this.takeOwnership();
                        try {
                            if (DefaultCacheAccess.this.fileLockHeldByOwner == null) break block13;
                            try {
                                DefaultCacheAccess.this.fileLockHeldByOwner.run();
                            }
                            finally {
                                DefaultCacheAccess.this.fileLockHeldByOwner = null;
                            }
                        }
                        finally {
                            DefaultCacheAccess.this.releaseOwnership();
                        }
                    }
                    finally {
                        DefaultCacheAccess.this.lock.unlock();
                    }
                }
            }
        };
    }

    Thread getOwner() {
        return this.owner;
    }

    FileAccess getFileAccess() {
        return this.fileAccess;
    }

    private static class InvalidCacheReuseException
    extends GradleException {
        InvalidCacheReuseException(String message) {
            super(message);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IndexedCacheEntry {
        private final MultiProcessSafePersistentIndexedCache cache;
        private final PersistentIndexedCacheParameters parameters;

        IndexedCacheEntry(PersistentIndexedCacheParameters parameters, MultiProcessSafePersistentIndexedCache cache) {
            this.parameters = parameters;
            this.cache = cache;
        }

        public MultiProcessSafePersistentIndexedCache getCache() {
            return this.cache;
        }

        public PersistentIndexedCacheParameters getParameters() {
            return this.parameters;
        }

        void assertCompatibleCacheParameters(PersistentIndexedCacheParameters parameters) {
            ArrayList<String> faultMessages = new ArrayList<String>();
            this.checkCacheNameMatch(faultMessages, parameters.getCacheName());
            this.checkCompatibleKeySerializer(faultMessages, parameters.getKeySerializer());
            this.checkCompatibleValueSerializer(faultMessages, parameters.getValueSerializer());
            this.checkCompatibleCacheDecorator(faultMessages, parameters.getCacheDecorator());
            if (!faultMessages.isEmpty()) {
                String lineSeparator = SystemProperties.getInstance().getLineSeparator();
                String faultMessage = CollectionUtils.join((String)lineSeparator, faultMessages);
                throw new InvalidCacheReuseException("The cache couldn't be reused because of the following mismatch:" + lineSeparator + faultMessage);
            }
        }

        private void checkCacheNameMatch(Collection<String> faultMessages, String cacheName) {
            if (!Objects.equal((Object)cacheName, (Object)this.parameters.getCacheName())) {
                faultMessages.add(String.format(" * Requested cache name (%s) doesn't match current cache name (%s)", cacheName, this.parameters.getCacheName()));
            }
        }

        private void checkCompatibleKeySerializer(Collection<String> faultMessages, Serializer keySerializer) {
            if (!Objects.equal((Object)keySerializer, this.parameters.getKeySerializer())) {
                faultMessages.add(String.format(" * Requested key serializer type (%s) doesn't match current cache type (%s)", keySerializer.getClass().getCanonicalName(), this.parameters.getKeySerializer().getClass().getCanonicalName()));
            }
        }

        private void checkCompatibleValueSerializer(Collection<String> faultMessages, Serializer valueSerializer) {
            if (!Objects.equal((Object)valueSerializer, this.parameters.getValueSerializer())) {
                faultMessages.add(String.format(" * Requested value serializer type (%s) doesn't match current cache type (%s)", valueSerializer.getClass().getCanonicalName(), this.parameters.getValueSerializer().getClass().getCanonicalName()));
            }
        }

        private void checkCompatibleCacheDecorator(Collection<String> faultMessages, CacheDecorator cacheDecorator) {
            if (!Objects.equal((Object)cacheDecorator, (Object)this.parameters.getCacheDecorator())) {
                faultMessages.add(String.format(" * Requested cache decorator type (%s) doesn't match current cache type (%s)", cacheDecorator, this.parameters.getCacheDecorator()));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UnitOfWorkFileAccess
    extends AbstractFileAccess {
        private UnitOfWorkFileAccess() {
        }

        public String toString() {
            return DefaultCacheAccess.this.cacheDisplayName;
        }

        @Override
        public <T> T readFile(Factory<? extends T> action) throws LockTimeoutException {
            return DefaultCacheAccess.this.getLock().readFile(action);
        }

        @Override
        public void updateFile(Runnable action) throws LockTimeoutException {
            DefaultCacheAccess.this.getLock().updateFile(action);
        }

        @Override
        public void writeFile(Runnable action) throws LockTimeoutException {
            DefaultCacheAccess.this.getLock().writeFile(action);
        }
    }
}

