/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.initialization.BuildLoader;
import org.gradle.initialization.SettingsLoader;

public class NotifyingSettingsLoader
implements SettingsLoader {
    private final SettingsLoader settingsLoader;
    private final BuildLoader buildLoader;

    public NotifyingSettingsLoader(SettingsLoader settingsLoader, BuildLoader buildLoader) {
        this.settingsLoader = settingsLoader;
        this.buildLoader = buildLoader;
    }

    public SettingsInternal findAndLoadSettings(GradleInternal gradle) {
        SettingsInternal settings = this.settingsLoader.findAndLoadSettings(gradle);
        gradle.getBuildListenerBroadcaster().settingsEvaluated(settings);
        this.buildLoader.load(settings.getRootProject(), settings.getDefaultProject(), gradle, settings.getRootClassLoaderScope());
        gradle.getBuildListenerBroadcaster().projectsLoaded(gradle);
        return settings;
    }
}

