/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.attributes;

import com.google.common.io.Files;
import java.io.File;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ArtifactAttributes;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.internal.component.model.IvyArtifactName;

public class DefaultArtifactAttributes {
    public static AttributeContainer forIvyArtifactName(IvyArtifactName ivyArtifactName, AttributeContainerInternal parentAttributes, ImmutableAttributesFactory attributesFactory) {
        return DefaultArtifactAttributes.createAttributes(ivyArtifactName.getType(), ivyArtifactName.getExtension(), ivyArtifactName.getClassifier(), parentAttributes, attributesFactory);
    }

    public static AttributeContainer forFile(File file, ImmutableAttributesFactory attributesFactory) {
        String extension = Files.getFileExtension((String)file.getName());
        return DefaultArtifactAttributes.createAttributes(extension, extension, "", (AttributeContainerInternal)ImmutableAttributes.EMPTY, attributesFactory);
    }

    private static AttributeContainer createAttributes(String type, String extension, String classifier, AttributeContainerInternal parentAttributes, ImmutableAttributesFactory attributesFactory) {
        return attributesFactory.builder(parentAttributes.asImmutable()).addAttribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)(type == null ? "" : type)).addAttribute(ArtifactAttributes.ARTIFACT_EXTENSION, (Object)(extension == null ? "" : extension)).addAttribute(ArtifactAttributes.ARTIFACT_CLASSIFIER, (Object)(classifier == null ? "" : classifier)).get();
    }
}

