/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.configurations.ResolutionStrategyInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.DefaultResolvedArtifactResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.DependencyArtifactsVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VisitedArtifactsResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphEdge;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;
import org.gradle.internal.component.local.model.LocalConfigurationMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;

public class DefaultResolvedArtifactsBuilder
implements DependencyArtifactsVisitor {
    private final Map<Long, Set<ArtifactSet>> sortedNodeIds = Maps.newLinkedHashMap();
    private final boolean buildProjectDependencies;
    private final Map<Long, ArtifactSet> artifactSets = Maps.newLinkedHashMap();
    private final Set<Long> buildableArtifactSets = new HashSet<Long>();
    private final ResolutionStrategyInternal.SortOrder sortOrder;

    public DefaultResolvedArtifactsBuilder(boolean buildProjectDependencies, ResolutionStrategyInternal.SortOrder sortOrder) {
        this.buildProjectDependencies = buildProjectDependencies;
        this.sortOrder = sortOrder;
    }

    public DefaultResolvedArtifactsBuilder(boolean buildProjectDependencies) {
        this.buildProjectDependencies = buildProjectDependencies;
        this.sortOrder = ResolutionStrategyInternal.SortOrder.DEFAULT;
    }

    @Override
    public void startArtifacts(DependencyGraphNode root) {
        if (this.sortOrder == ResolutionStrategyInternal.SortOrder.DEFAULT) {
            return;
        }
        List<DependencyGraphNode> sortedNodeList = this.getSortedNodeList(root);
        for (DependencyGraphNode node : sortedNodeList) {
            this.sortedNodeIds.put(node.getNodeId(), Sets.newHashSet());
        }
    }

    private List<DependencyGraphNode> getSortedNodeList(DependencyGraphNode root) {
        HashSet tempMarked = Sets.newHashSet();
        ArrayList marked = Lists.newArrayList();
        this.topologicalSort(root, tempMarked, marked);
        return this.sortOrder == ResolutionStrategyInternal.SortOrder.CONSUMER_FIRST ? Lists.reverse((List)marked) : marked;
    }

    private void topologicalSort(DependencyGraphNode node, Set<DependencyGraphNode> tempMarked, List<DependencyGraphNode> marked) {
        if (tempMarked.contains(node)) {
            return;
        }
        if (!marked.contains(node)) {
            tempMarked.add(node);
            ArrayList edges = Lists.newArrayList(node.getOutgoingEdges());
            for (DependencyGraphEdge dependencyEdge : Lists.reverse((List)edges)) {
                for (DependencyGraphNode dependencyGraphNode : dependencyEdge.getTargets()) {
                    this.topologicalSort(dependencyGraphNode, tempMarked, marked);
                }
            }
            marked.add(node);
            tempMarked.remove(node);
        }
    }

    @Override
    public void visitArtifacts(DependencyGraphNode from, DependencyGraphNode to, ArtifactSet artifacts) {
        ProjectComponentIdentifier incomingId;
        if (this.sortOrder != ResolutionStrategyInternal.SortOrder.DEFAULT) {
            this.sortedNodeIds.get(to.getNodeId()).add(artifacts);
        } else {
            this.artifactSets.put(artifacts.getId(), artifacts);
        }
        if (!this.buildProjectDependencies) {
            return;
        }
        if (this.buildableArtifactSets.contains(artifacts.getId())) {
            return;
        }
        ConfigurationMetadata configurationMetadata = to.getMetadata();
        if (!(configurationMetadata instanceof LocalConfigurationMetadata)) {
            return;
        }
        if (from.getOwner().getComponentId() instanceof ProjectComponentIdentifier && !(incomingId = (ProjectComponentIdentifier)from.getOwner().getComponentId()).getBuild().isCurrentBuild()) {
            return;
        }
        this.buildableArtifactSets.add(artifacts.getId());
    }

    @Override
    public void finishArtifacts() {
    }

    public VisitedArtifactsResults complete() {
        LinkedHashMap artifactsById = Maps.newLinkedHashMap();
        if (this.sortOrder != ResolutionStrategyInternal.SortOrder.DEFAULT) {
            for (Set<ArtifactSet> sets : this.sortedNodeIds.values()) {
                for (ArtifactSet set : sets) {
                    artifactsById.put(set.getId(), set.snapshot());
                }
            }
        } else {
            for (Map.Entry<Long, ArtifactSet> entry : this.artifactSets.entrySet()) {
                ArtifactSet resolvedArtifacts = entry.getValue().snapshot();
                artifactsById.put(entry.getKey(), resolvedArtifacts);
            }
        }
        return new DefaultResolvedArtifactResults(artifactsById, this.buildableArtifactSets);
    }
}

