/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.transform.ArtifactTransform;
import org.gradle.api.artifacts.transform.ArtifactTransformException;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.internal.reflect.DirectInstantiator;

class ArtifactTransformRegistration {
    public final AttributeContainer from;
    public final AttributeContainer to;
    public final Class<? extends ArtifactTransform> type;
    public final Action<? super ArtifactTransform> config;
    private Transformer<List<File>, File> transform;

    ArtifactTransformRegistration(AttributeContainer from, AttributeContainer to, Class<? extends ArtifactTransform> type, Action<? super ArtifactTransform> config) {
        this.from = from;
        this.to = to;
        this.type = type;
        this.config = config;
        this.transform = this.createArtifactTransformer();
    }

    Class<? extends ArtifactTransform> getType() {
        return this.type;
    }

    Transformer<List<File>, File> getTransform() {
        return this.transform;
    }

    private Transformer<List<File>, File> createArtifactTransformer() {
        ArtifactTransform artifactTransform = (ArtifactTransform)DirectInstantiator.INSTANCE.newInstance(this.type, new Object[0]);
        this.config.execute((Object)artifactTransform);
        return new ArtifactFileTransformer(artifactTransform, this.to);
    }

    private static class ArtifactFileTransformer
    implements Transformer<List<File>, File> {
        private final ArtifactTransform artifactTransform;
        private final AttributeContainer outputAttributes;

        private ArtifactFileTransformer(ArtifactTransform artifactTransform, AttributeContainer outputAttributes) {
            this.artifactTransform = artifactTransform;
            this.outputAttributes = outputAttributes;
        }

        public List<File> transform(File input) {
            List<File> outputs;
            if (this.artifactTransform.getOutputDirectory() != null) {
                this.artifactTransform.getOutputDirectory().mkdirs();
            }
            if ((outputs = this.doTransform(input)) == null) {
                throw new ArtifactTransformException(input, this.outputAttributes, this.artifactTransform, (Throwable)new NullPointerException("Illegal null output from ArtifactTransform"));
            }
            for (File output : outputs) {
                if (output.exists()) continue;
                throw new ArtifactTransformException(input, this.outputAttributes, this.artifactTransform, (Throwable)new FileNotFoundException("ArtifactTransform output '" + output.getPath() + "' does not exist"));
            }
            return outputs;
        }

        private List<File> doTransform(File input) {
            try {
                return this.artifactTransform.transform(input, this.outputAttributes);
            }
            catch (Exception e) {
                throw new ArtifactTransformException(input, this.outputAttributes, this.artifactTransform, (Throwable)e);
            }
        }
    }
}

