/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iom_j.itf;

import ch.interlis.ili2c.metamodel.AbstractClassDef;
import ch.interlis.ili2c.metamodel.AbstractLeafElement;
import ch.interlis.ili2c.metamodel.AreaType;
import ch.interlis.ili2c.metamodel.AssociationDef;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Enumeration;
import ch.interlis.ili2c.metamodel.EnumerationType;
import ch.interlis.ili2c.metamodel.Extendable;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.PolylineType;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.SurfaceOrAreaType;
import ch.interlis.ili2c.metamodel.SurfaceType;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.TypeModel;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.ili2c.metamodel.ViewableTransferElement;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ModelUtilities {
    private ModelUtilities() {
    }

    public static HashMap getTagMap(TransferDescription td) {
        HashMap<String, Element> ret = new HashMap<String, Element>();
        for (Object mObj : td) {
            Model model;
            if (!(mObj instanceof Model) || (model = (Model)mObj) instanceof TypeModel) continue;
            for (Object tObj : model) {
                if (tObj instanceof Topic) {
                    Topic topic = (Topic)tObj;
                    for (Viewable<?> obj : topic.getViewables()) {
                        if (!(obj instanceof Viewable)) continue;
                        Viewable<?> v = obj;
                        String className = v.getScopedName((Container)null);
                        ret.put(className, v);
                        Iterator<Extendable> attri = v.getAttributes();
                        while (attri.hasNext()) {
                            AttributeDef attr;
                            Type type;
                            Extendable attrObj = attri.next();
                            if (!(attrObj instanceof AttributeDef) || !((type = Type.findReal((attr = (AttributeDef)attrObj).getDomain())) instanceof SurfaceOrAreaType)) continue;
                            String name = String.valueOf(v.getContainer().getScopedName(null)) + "." + v.getName() + "_" + attr.getName();
                            ret.put(name, attr);
                        }
                    }
                    continue;
                }
                if (!(tObj instanceof Viewable)) continue;
                Viewable v = (Viewable)tObj;
                ret.put(v.getScopedName((Container)null), v);
                Iterator<Extendable> attri = v.getAttributes();
                while (attri.hasNext()) {
                    AttributeDef attr;
                    Type type;
                    Extendable attrObj = attri.next();
                    if (!(attrObj instanceof AttributeDef) || !((type = Type.findReal((attr = (AttributeDef)attrObj).getDomain())) instanceof SurfaceOrAreaType)) continue;
                    String name = String.valueOf(v.getContainer().getScopedName(null)) + "." + v.getName() + "_" + attr.getName();
                    ret.put(name, attr);
                }
            }
        }
        return ret;
    }

    public static ArrayList getItfTables(TransferDescription td, Topic topic) {
        ArrayList<Element> ret = new ArrayList<Element>();
        for (Viewable<?> obj : topic.getViewables()) {
            AttributeDef attr;
            Type type;
            Extendable attrObj;
            Viewable<?> v;
            if (!(obj instanceof Viewable) || (v = obj) instanceof Table && !((Table)v).isIdentifiable() || ModelUtilities.isPureRefAssoc(v)) continue;
            Iterator<Extendable> attri = null;
            attri = v.getAttributes();
            while (attri.hasNext()) {
                attrObj = attri.next();
                if (!(attrObj instanceof AttributeDef) || !((type = Type.findReal((attr = (AttributeDef)attrObj).getDomain())) instanceof AreaType)) continue;
                ret.add(attr);
            }
            ret.add(v);
            attri = v.getAttributes();
            while (attri.hasNext()) {
                attrObj = attri.next();
                if (!(attrObj instanceof AttributeDef) || !((type = Type.findReal((attr = (AttributeDef)attrObj).getDomain())) instanceof SurfaceType)) continue;
                ret.add(attr);
            }
        }
        return ret;
    }

    public static ArrayList getItfTables(TransferDescription td, String modelName, String topicName) {
        for (Object mObj : td) {
            Model model;
            if (!(mObj instanceof Model) || !(model = (Model)mObj).getName().equals(modelName)) continue;
            for (Object tObj : model) {
                Topic topic;
                if (!(tObj instanceof Topic) || !(topic = (Topic)tObj).getName().equals(topicName)) continue;
                return ModelUtilities.getItfTables(td, topic);
            }
        }
        return null;
    }

    public static ArrayList getPolylineAttrs(AbstractClassDef table) {
        ArrayList<AttributeDef> ret = new ArrayList<AttributeDef>();
        Iterator<Extendable> iter = table.getAttributes();
        while (iter.hasNext()) {
            AttributeDef attr = (AttributeDef)iter.next();
            Type type = Type.findReal(attr.getDomain());
            if (!(type instanceof PolylineType)) continue;
            ret.add(attr);
        }
        return ret;
    }

    public static ArrayList getIli1AttrList(AbstractClassDef table) {
        ArrayList<ViewableTransferElement> attrlist = new ArrayList<ViewableTransferElement>();
        Iterator<Element> iter = table.getAttributesAndRoles();
        while (iter.hasNext()) {
            Element obj = iter.next();
            if (obj instanceof AttributeDef) {
                attrlist.add(new ViewableTransferElement(obj));
                continue;
            }
            if (!(obj instanceof RoleDef) || ((AssociationDef)table).isLightweight()) continue;
            attrlist.add(new ViewableTransferElement(obj, false));
        }
        ArrayList<RoleDef> rolesSorted = new ArrayList<RoleDef>(table.getLightweightAssociations());
        Collections.sort(rolesSorted, new Comparator(){

            public int compare(Object o1, Object o2) {
                int idx2;
                int idx1 = ((RoleDef)o1).getIli1AttrIdx();
                if (idx1 == (idx2 = ((RoleDef)o2).getIli1AttrIdx())) {
                    return 0;
                }
                if (idx1 == -1) {
                    return 1;
                }
                if (idx2 == -1) {
                    return -1;
                }
                if (idx1 < idx2) {
                    return -1;
                }
                return 1;
            }
        });
        for (RoleDef role : rolesSorted) {
            RoleDef oppend = role.getOppEnd();
            if (role.getIli1AttrIdx() == -1) {
                attrlist.add(new ViewableTransferElement(oppend, true));
                continue;
            }
            attrlist.add(role.getIli1AttrIdx(), new ViewableTransferElement(oppend, true));
        }
        return attrlist;
    }

    public static HashSet getEnumTypes(TransferDescription td) {
        HashSet<AbstractLeafElement> ret = new HashSet<AbstractLeafElement>();
        for (Object mObj : td) {
            if (!(mObj instanceof Model)) continue;
            Model model = (Model)mObj;
            for (Object tObj : model) {
                Type type;
                if (tObj instanceof Domain) {
                    Domain domain = (Domain)tObj;
                    Type type2 = domain.getType();
                    if (!(type2 instanceof EnumerationType)) continue;
                    ret.add(domain);
                    continue;
                }
                if (tObj instanceof Topic) {
                    Topic topic = (Topic)tObj;
                    for (Viewable<?> obj : topic.getViewables()) {
                        if (obj instanceof Domain) {
                            Domain domain = (Domain)((Object)obj);
                            type = domain.getType();
                            if (!(type instanceof EnumerationType)) continue;
                            ret.add(domain);
                            continue;
                        }
                        if (!(obj instanceof Viewable)) continue;
                        Viewable<?> v = obj;
                        Iterator<Extendable> attri = v.getAttributes();
                        while (attri.hasNext()) {
                            AttributeDef attr;
                            Type type3;
                            Extendable attrObj = attri.next();
                            if (!(attrObj instanceof AttributeDef) || !((type3 = (attr = (AttributeDef)attrObj).getDomain()) instanceof EnumerationType)) continue;
                            ret.add(attr);
                        }
                    }
                    continue;
                }
                if (!(tObj instanceof Viewable)) continue;
                Viewable v = (Viewable)tObj;
                Iterator<Extendable> attri = v.getAttributes();
                while (attri.hasNext()) {
                    AttributeDef attr;
                    Extendable attrObj = attri.next();
                    if (!(attrObj instanceof AttributeDef) || !((type = (attr = (AttributeDef)attrObj).getDomain()) instanceof EnumerationType)) continue;
                    ret.add(attr);
                }
            }
        }
        return ret;
    }

    public static String code2string(int code) throws UnsupportedEncodingException {
        byte[] bytes = new byte[]{(byte)code};
        return new String(bytes, "ISO-8859-1");
    }

    public static void buildEnumList(List accu, String prefix1, Enumeration enumer) {
        Iterator<Enumeration.Element> iter = enumer.getElements();
        String prefix = "";
        if (prefix1.length() > 0) {
            prefix = String.valueOf(prefix1) + ".";
        }
        while (iter.hasNext()) {
            Enumeration.Element ee = iter.next();
            Enumeration subEnum = ee.getSubEnumeration();
            if (subEnum != null) {
                ModelUtilities.buildEnumList(accu, String.valueOf(prefix) + ee.getName(), subEnum);
                continue;
            }
            accu.add(String.valueOf(prefix) + ee.getName());
        }
    }

    public static String getHelperTableMainTableRef(AttributeDef attr) {
        return "_itf_ref_" + attr.getContainer().getName();
    }

    public static String getHelperTableGeomAttrName(AttributeDef attr) {
        return "_itf_geom_" + attr.getContainer().getName();
    }

    public static boolean isPureRefAssoc(Viewable v) {
        if (!(v instanceof AssociationDef)) {
            return false;
        }
        AssociationDef assoc = (AssociationDef)v;
        return assoc.isLightweight() && !assoc.getAttributes().hasNext() && !assoc.getLightweightAssociations().iterator().hasNext();
    }
}

