#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: memory
version: 0.14.3
id: memory-0.14.3-9wQQTseliVGKJ09laFleog
key: memory-0.14.3-9wQQTseliVGKJ09laFleog
license: BSD3
copyright: Vincent Hanquez <vincent@snarc.org>
maintainer: vincent@snarc.org
stability: experimental
homepage: https://github.com/vincenthz/hs-memory
synopsis: memory and related abstraction stuff
description:
    Chunk of memory, polymorphic byte array management and manipulation
    .
    * A polymorphic byte array abstraction and function similar to strict ByteString.
    .
    * Different type of byte array abstraction.
    .
    * Raw memory IO operations (memory set, memory copy, ..)
    .
    * Aliasing with endianness support.
    .
    * Encoding : Base16, Base32, Base64.
    .
    * Hashing : FNV, SipHash
category: memory
author: Vincent Hanquez <vincent@snarc.org>
exposed: True
exposed-modules:
    Data.ByteArray Data.ByteArray.Encoding Data.ByteArray.Mapping
    Data.ByteArray.Pack Data.ByteArray.Parse Data.ByteArray.Hash
    Data.Memory.Endian Data.Memory.PtrMethods Data.Memory.ExtendedWords
    Data.Memory.Encoding.Base16 Data.Memory.Encoding.Base32
    Data.Memory.Encoding.Base64
hidden-modules: Data.Memory.Internal.Compat
                Data.Memory.Internal.CompatPrim Data.Memory.Internal.CompatPrim64
                Data.Memory.Internal.DeepSeq Data.Memory.Internal.Imports
                Data.Memory.Internal.Scrubber Data.Memory.Hash.SipHash
                Data.Memory.Hash.FNV Data.ByteArray.Pack.Internal
                Data.ByteArray.Types Data.ByteArray.Bytes
                Data.ByteArray.ScrubbedBytes Data.ByteArray.Methods
                Data.ByteArray.MemView Data.ByteArray.View Data.Memory.MemMap.Posix
abi: a7a185c45714cbd20f52fe3fa28ca48f
trusted: False
import-dirs: /usr/lib/ghc-8.0.1/site-local/memory-0.14.3
library-dirs: /usr/lib/ghc-8.0.1/site-local/memory-0.14.3
data-dir: /usr/share/arm-linux-ghc-8.0.1/memory-0.14.3
hs-libraries: HSmemory-0.14.3-9wQQTseliVGKJ09laFleog
depends:
    base-4.9.0.0 bytestring-0.10.8.1 deepseq-1.4.2.0
    foundation-0.0.6-JZAfKSgePaKzhmuMs624l ghc-prim-0.5.0.0
haddock-interfaces: /usr/share/doc/haskell-memory/html/memory.haddock
haddock-html: /usr/share/doc/haskell-memory/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
