/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.hash;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.core.hash.BucketsStrategy;
import org.jruby.truffle.core.hash.CompareHashKeysNode;
import org.jruby.truffle.core.hash.Entry;
import org.jruby.truffle.core.hash.FreezeHashKeyIfNeededNode;
import org.jruby.truffle.core.hash.FreezeHashKeyIfNeededNodeGen;
import org.jruby.truffle.core.hash.HashGuards;
import org.jruby.truffle.core.hash.HashLookupResult;
import org.jruby.truffle.core.hash.HashNode;
import org.jruby.truffle.core.hash.HashOperations;
import org.jruby.truffle.core.hash.LookupEntryNode;
import org.jruby.truffle.core.hash.PackedArrayStrategy;
import org.jruby.truffle.core.hash.SetNodeGen;
import org.jruby.truffle.language.RubyNode;

@ImportStatic(value={HashGuards.class})
@NodeChildren(value={@NodeChild(value="hash", type=RubyNode.class), @NodeChild(value="key", type=RubyNode.class), @NodeChild(value="value", type=RubyNode.class), @NodeChild(value="byIdentity", type=RubyNode.class)})
public abstract class SetNode
extends RubyNode {
    @Node.Child
    private HashNode hashNode = new HashNode();
    @Node.Child
    private LookupEntryNode lookupEntryNode;
    @Node.Child
    private CompareHashKeysNode compareHashKeysNode = new CompareHashKeysNode();
    @Node.Child
    private FreezeHashKeyIfNeededNode freezeHashKeyIfNeededNode = FreezeHashKeyIfNeededNodeGen.create(null, null);

    public static SetNode create() {
        return SetNodeGen.create(null, null, null, null);
    }

    public abstract Object executeSet(VirtualFrame var1, DynamicObject var2, Object var3, Object var4, boolean var5);

    @Specialization(guards={"isNullHash(hash)"})
    public Object setNull(VirtualFrame frame, DynamicObject hash, Object originalKey, Object value, boolean byIdentity, @Cached(value="createBinaryProfile()") ConditionProfile byIdentityProfile) {
        assert (HashOperations.verifyStore(this.getContext(), hash));
        boolean compareByIdentity = byIdentityProfile.profile(byIdentity);
        Object key = this.freezeHashKeyIfNeededNode.executeFreezeIfNeeded(frame, originalKey, compareByIdentity);
        int hashed = this.hashNode.hash(frame, key, compareByIdentity);
        Object[] store = PackedArrayStrategy.createStore(this.getContext(), hashed, key, value);
        assert (HashOperations.verifyStore(this.getContext(), store, 1, null, null));
        Layouts.HASH.setStore(hash, store);
        Layouts.HASH.setSize(hash, 1);
        Layouts.HASH.setFirstInSequence(hash, null);
        Layouts.HASH.setLastInSequence(hash, null);
        assert (HashOperations.verifyStore(this.getContext(), hash));
        return value;
    }

    @ExplodeLoop
    @Specialization(guards={"isPackedHash(hash)"})
    public Object setPackedArray(VirtualFrame frame, DynamicObject hash, Object originalKey, Object value, boolean byIdentity, @Cached(value="createBinaryProfile()") ConditionProfile byIdentityProfile, @Cached(value="createBinaryProfile()") ConditionProfile strategyProfile, @Cached(value="create()") BranchProfile extendProfile) {
        assert (HashOperations.verifyStore(this.getContext(), hash));
        boolean compareByIdentity = byIdentityProfile.profile(byIdentity);
        Object key = this.freezeHashKeyIfNeededNode.executeFreezeIfNeeded(frame, originalKey, compareByIdentity);
        int hashed = this.hashNode.hash(frame, key, compareByIdentity);
        Object[] store = (Object[])Layouts.HASH.getStore(hash);
        int size = Layouts.HASH.getSize(hash);
        for (int n = 0; n < this.getContext().getOptions().HASH_PACKED_ARRAY_MAX; ++n) {
            if (n >= size) continue;
            int otherHashed = PackedArrayStrategy.getHashed(store, n);
            Object otherKey = PackedArrayStrategy.getKey(store, n);
            if (!this.equalKeys(frame, compareByIdentity, key, hashed, otherKey, otherHashed)) continue;
            PackedArrayStrategy.setValue(store, n, value);
            assert (HashOperations.verifyStore(this.getContext(), hash));
            return value;
        }
        extendProfile.enter();
        if (strategyProfile.profile(size + 1 <= this.getContext().getOptions().HASH_PACKED_ARRAY_MAX)) {
            PackedArrayStrategy.setHashedKeyValue(store, size, hashed, key, value);
            Layouts.HASH.setSize(hash, size + 1);
            return value;
        }
        PackedArrayStrategy.promoteToBuckets(this.getContext(), hash, store, size);
        BucketsStrategy.addNewEntry(this.getContext(), hash, hashed, key, value);
        assert (HashOperations.verifyStore(this.getContext(), hash));
        return value;
    }

    @Specialization(guards={"isBucketHash(hash)"})
    public Object setBuckets(VirtualFrame frame, DynamicObject hash, Object originalKey, Object value, boolean byIdentity, @Cached(value="createBinaryProfile()") ConditionProfile byIdentityProfile, @Cached(value="createBinaryProfile()") ConditionProfile foundProfile, @Cached(value="createBinaryProfile()") ConditionProfile bucketCollisionProfile, @Cached(value="createBinaryProfile()") ConditionProfile appendingProfile, @Cached(value="createBinaryProfile()") ConditionProfile resizeProfile) {
        assert (HashOperations.verifyStore(this.getContext(), hash));
        boolean compareByIdentity = byIdentityProfile.profile(byIdentity);
        Object key = this.freezeHashKeyIfNeededNode.executeFreezeIfNeeded(frame, originalKey, compareByIdentity);
        HashLookupResult result = this.lookup(frame, hash, key);
        Entry entry = result.getEntry();
        if (foundProfile.profile(entry == null)) {
            Entry[] entries = (Entry[])Layouts.HASH.getStore(hash);
            Entry newEntry = new Entry(result.getHashed(), key, value);
            if (bucketCollisionProfile.profile(result.getPreviousEntry() == null)) {
                entries[result.getIndex()] = newEntry;
            } else {
                result.getPreviousEntry().setNextInLookup(newEntry);
            }
            Entry lastInSequence = Layouts.HASH.getLastInSequence(hash);
            if (appendingProfile.profile(lastInSequence == null)) {
                Layouts.HASH.setFirstInSequence(hash, newEntry);
            } else {
                lastInSequence.setNextInSequence(newEntry);
                newEntry.setPreviousInSequence(lastInSequence);
            }
            Layouts.HASH.setLastInSequence(hash, newEntry);
            int newSize = Layouts.HASH.getSize(hash) + 1;
            Layouts.HASH.setSize(hash, newSize);
            if (resizeProfile.profile((double)newSize / (double)entries.length > 0.75)) {
                BucketsStrategy.resize(this.getContext(), hash);
            }
        } else {
            entry.setKeyValue(result.getHashed(), key, value);
        }
        assert (HashOperations.verifyStore(this.getContext(), hash));
        return value;
    }

    private HashLookupResult lookup(VirtualFrame frame, DynamicObject hash, Object key) {
        if (this.lookupEntryNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.lookupEntryNode = this.insert(new LookupEntryNode());
        }
        return this.lookupEntryNode.lookup(frame, hash, key);
    }

    protected boolean equalKeys(VirtualFrame frame, boolean compareByIdentity, Object key, int hashed, Object otherKey, int otherHashed) {
        return this.compareHashKeysNode.equalKeys(frame, compareByIdentity, key, hashed, otherKey, otherHashed);
    }
}

