#ifndef _EFL_CANVAS_TEXT_EO_H_
#define _EFL_CANVAS_TEXT_EO_H_

#ifndef _EFL_CANVAS_TEXT_EO_CLASS_TYPE
#define _EFL_CANVAS_TEXT_EO_CLASS_TYPE

typedef Eo Efl_Canvas_Text;

#endif

#ifndef _EFL_CANVAS_TEXT_EO_TYPES
#define _EFL_CANVAS_TEXT_EO_TYPES

typedef struct _Efl_Canvas_Text_Style Efl_Canvas_Text_Style;


#endif
#define EFL_CANVAS_TEXT_CLASS efl_canvas_text_class_get()

EWAPI const Eo_Class *efl_canvas_text_class_get(void);

/**
 * @brief BiDi delimiters are used for in-paragraph separation of bidi
 * segments. This is useful for example in recipients fields of e-mail clients
 * where bidi oddities can occur when mixing RTL and LTR.
 *
 * @param[in] delim A null terminated string of delimiters, e.g ",|" or @c null
 * if empty.
 *
 * @since 1.1
 *
 * @ingroup Efl_Canvas_Text
 */
EOAPI void efl_canvas_text_bidi_delimiters_set(Eo *obj, const char *delim);

/**
 * @brief BiDi delimiters are used for in-paragraph separation of bidi
 * segments. This is useful for example in recipients fields of e-mail clients
 * where bidi oddities can occur when mixing RTL and LTR.
 *
 * @return A null terminated string of delimiters, e.g ",|" or @c null if
 * empty.
 *
 * @since 1.1
 *
 * @ingroup Efl_Canvas_Text
 */
EOAPI const char *efl_canvas_text_bidi_delimiters_get(const Eo *obj);

/**
 * @brief When true, newline character will behave as a paragraph separator.
 *
 * @param[in] mode @c true for legacy mode, @c false otherwise.
 *
 * @since 1.1
 *
 * @ingroup Efl_Canvas_Text
 */
EOAPI void efl_canvas_text_legacy_newline_set(Eo *obj, Eina_Bool mode);

/**
 * @brief When true, newline character will behave as a paragraph separator.
 *
 * @return @c true for legacy mode, @c false otherwise.
 *
 * @since 1.1
 *
 * @ingroup Efl_Canvas_Text
 */
EOAPI Eina_Bool efl_canvas_text_legacy_newline_get(const Eo *obj);

/**
 * @brief The text style of the object.
 *
 * @c key is how you reference the style (for deletion or fetching). @c NULL as
 * key indicates the style has the highest priority (default style). The style
 * priority is the order of creation, styles created first are applied first
 * with the exception of @c NULL which is implicitly first.
 *
 * Set @c style to @c NULL to delete it.
 *
 * @param[in] key The name to the style. @c NULL is the default style
 * @param[in] style The style.
 *
 * @ingroup Efl_Canvas_Text
 */
EOAPI void efl_canvas_text_style_set(Eo *obj, const char * key, const char *style);

/**
 * @brief The text style of the object.
 *
 * @c key is how you reference the style (for deletion or fetching). @c NULL as
 * key indicates the style has the highest priority (default style). The style
 * priority is the order of creation, styles created first are applied first
 * with the exception of @c NULL which is implicitly first.
 *
 * Set @c style to @c NULL to delete it.
 *
 * @param[in] key The name to the style. @c NULL is the default style
 *
 * @return The style.
 *
 * @ingroup Efl_Canvas_Text
 */
EOAPI const char *efl_canvas_text_style_get(const Eo *obj, const char * key);

/**
 * @brief The formatted width and height.
 *
 * This calculates the actual size after restricting the textblock to the
 * current size of the object.
 *
 * The main difference between this and @ref efl_canvas_text_size_native_get is
 * that the "native" function does not wrapping into account it just calculates
 * the real width of the object if it was placed on an infinite canvas, while
 * this function gives the size after wrapping according to the size
 * restrictions of the object.
 *
 * For example for a textblock containing the text: "You shall not pass!" with
 * no margins or padding and assuming a monospace font and a size of 7x10 char
 * widths (for simplicity) has a native size of 19x1 and a formatted size of
 * 5x4.
 *
 * @param[out] w The width of the object.
 * @param[out] h The height of the object.
 *
 * @ingroup Efl_Canvas_Text
 */
EOAPI void efl_canvas_text_size_formatted_get(const Eo *obj, Evas_Coord *w, Evas_Coord *h);

/** The object's main cursor.
 *
 * @ingroup Efl_Canvas_Text
 */
EOAPI Efl_Canvas_Text_Cursor *efl_canvas_text_cursor_get(const Eo *obj);

/**
 * @brief The native width and height.
 *
 * This calculates the actual size without taking account the current size of
 * the object.
 *
 * The main difference between this and @ref efl_canvas_text_size_formatted_get
 * is that the "native" function does not take wrapping into account it just
 * calculates the real width of the object if it was placed on an infinite
 * canvas, while the "formatted" function gives the size after  wrapping text
 * according to the size restrictions of the object.
 *
 * For example for a textblock containing the text: "You shall not pass!" with
 * no margins or padding and assuming a monospace font and a size of 7x10 char
 * widths (for simplicity) has a native size of 19x1 and a formatted size of
 * 5x4.
 *
 * @param[out] w The width returned.
 * @param[out] h The height returned.
 *
 * @ingroup Efl_Canvas_Text
 */
EOAPI void efl_canvas_text_size_native_get(const Eo *obj, Evas_Coord *w, Evas_Coord *h);

EOAPI void efl_canvas_text_style_insets_get(const Eo *obj, Evas_Coord *l, Evas_Coord *r, Evas_Coord *t, Evas_Coord *b);

/**
 * @brief Whether the object is empty (no text) or not
 *
 * @return @c true if empty
 *
 * @ingroup Efl_Canvas_Text
 */
EOAPI Eina_Bool efl_canvas_text_is_empty_get(const Eo *obj);

/**
 * @brief A new format for @c annotation.
 *
 * This will replace the format applied by @c annotation with @c format.
 * Assumes that @c annotation is a handle for an existing annotation, i.e. one
 * that was added using @ref efl_canvas_text_annotation_insert to this object.
 * Otherwise, this will fail and return @c false.
 *
 * @param[in] annotation
 * @param[in] format
 *
 * @return @c true on success, @c false otherwise.
 *
 * @since 1.18
 *
 * @ingroup Efl_Canvas_Text
 */
EOAPI Eina_Bool efl_canvas_text_annotation_set(Eo *obj, Efl_Canvas_Text_Annotation * annotation, const char *format);

/**
 * @brief A new format for @c annotation.
 *
 * This will replace the format applied by @c annotation with @c format.
 * Assumes that @c annotation is a handle for an existing annotation, i.e. one
 * that was added using @ref efl_canvas_text_annotation_insert to this object.
 * Otherwise, this will fail and return @c false.
 *
 * @param[in] annotation
 *
 * @since 1.18
 *
 * @ingroup Efl_Canvas_Text
 */
EOAPI const char *efl_canvas_text_annotation_get(const Eo *obj, Efl_Canvas_Text_Annotation * annotation);

/**
 * @brief Add obstacle evas object @c eo_obs to be observed during layout of
 * text.
 *
 * The textblock does the layout of the text according to the position of the
 * obstacle.
 *
 * @param[in] eo_obs
 *
 * @return @c true on success, @c false otherwise.
 *
 * @since 1.15
 *
 * @ingroup Efl_Canvas_Text
 */
EOAPI Eina_Bool efl_canvas_text_obstacle_add(Eo *obj, Efl_Canvas_Object *eo_obs);

/**
 * @brief Removes @c eo_obs from observation during text layout.
 *
 * @param[in] eo_obs
 *
 * @return @c true on success, @c false otherwise.
 *
 * @since 1.15
 *
 * @ingroup Efl_Canvas_Text
 */
EOAPI Eina_Bool efl_canvas_text_obstacle_del(Eo *obj, Efl_Canvas_Object *eo_obs);

/**
 * @brief Triggers for relayout due to obstacles' state change.
 *
 * The obstacles alone don't affect the layout, until this is called. Use this
 * after doing changes (moving, positioning etc.) in the obstacles that you
 *  would like to be considered in the layout.
 *
 * For example: if you have just repositioned the obstacles to differrent
 * coordinates relative to the textblock, you need to call this so it will
 * consider this new state and will relayout the text.
 *
 * @since 1.15
 *
 * @ingroup Efl_Canvas_Text
 */
EOAPI void efl_canvas_text_obstacles_update(Eo *obj);

/**
 * @brief Returns an iterator of all the handles in a range.
 *
 * @param[in] start
 * @param[in] end
 *
 * @return Handle of the Annotation
 *
 * @since 1.18
 *
 * @ingroup Efl_Canvas_Text
 */
EOAPI Eina_Iterator *efl_canvas_text_range_annotations_get(Eo *obj, const Efl_Canvas_Text_Cursor *start, const Efl_Canvas_Text_Cursor *end);

/**
 * @brief Deletes @c annotation.
 *
 * All formats applied by @c annotations will be removed and it will be
 * deleted.
 *
 * @param[in] annotation
 *
 * @return @c true on success, @c false otherwise.
 *
 * @ingroup Efl_Canvas_Text
 */
EOAPI Eina_Bool efl_canvas_text_annotation_del(Eo *obj, Efl_Canvas_Text_Annotation *annotation);

/**
 * @brief Inserts an annotation format in a specified range [$start, @c end -
 * 1].
 *
 * This will add both opening and closing formats for the given @c format.
 * Returns a handle to manipulate the inserted annotation.
 *
 * @param[in] start
 * @param[in] end
 * @param[in] format
 *
 * @since 1.18
 *
 * @ingroup Efl_Canvas_Text
 */
EOAPI Efl_Canvas_Text_Annotation *efl_canvas_text_annotation_insert(Eo *obj, Efl_Canvas_Text_Cursor *start, Efl_Canvas_Text_Cursor *end, const char *format);

/**
 * @brief Get the geometry of a range.  The geometry is the geometry in which
 * rectangles in middle lines of range are merged into one big rectangle.
 *
 * @param[in] cur1
 * @param[in] cur2
 *
 * @since 1.13
 *
 * @ingroup Efl_Canvas_Text
 */
EOAPI Eina_Iterator *efl_canvas_text_range_geometry_get(Eo *obj, const Efl_Canvas_Text_Cursor *cur1, const Efl_Canvas_Text_Cursor *cur2);

/**
 * @brief Deletes the range between given cursors.
 *
 * @param[in] cur1 Range start position.
 * @param[in] cur2 Range end position.
 *
 * @ingroup Efl_Canvas_Text
 */
EOAPI void efl_canvas_text_range_delete(Eo *obj, Efl_Canvas_Text_Cursor *cur1, Efl_Canvas_Text_Cursor *cur2);

/**
 * @brief Returns the currently visible range.
 *
 * The given @c start and @c end cursor act like an out-variables here, as
 * these are set to the positions of the start and the end of the visible range
 * in the text, respectively.
 *
 * @param[in] start Range start position.
 * @param[in] end Range end position.
 *
 * @return @c true on success, @c false otherwise.
 *
 * @since 1.18
 *
 * @ingroup Efl_Canvas_Text
 */
EOAPI Eina_Bool efl_canvas_text_visible_range_get(Eo *obj, Efl_Canvas_Text_Cursor *start, Efl_Canvas_Text_Cursor *end);

/**
 * @brief Returns the text in the range between @c cur1 and @c cur2.
 *
 * @param[in] cur1 Range start position.
 * @param[in] cur2 Range end position.
 *
 * @return The text in the given range.
 *
 * @ingroup Efl_Canvas_Text
 */
EOAPI char *efl_canvas_text_range_text_get(Eo *obj, const Efl_Canvas_Text_Cursor *cur1, const Efl_Canvas_Text_Cursor *cur2);

/**
 * @brief Queries a given object item for its geometry
 *
 * Note that the provided annotation should be an object item type.
 *
 * @param[in] an Given annotation to query
 * @param[out] x
 * @param[out] y
 * @param[out] w
 * @param[out] h
 *
 * @return @c true if given annotation is an object item, @c false otherwise
 *
 * @ingroup Efl_Canvas_Text
 */
EOAPI Eina_Bool efl_canvas_text_object_item_geometry_get(Eo *obj, const Efl_Canvas_Text_Annotation *an, Evas_Coord *x, Evas_Coord *y, Evas_Coord *w, Evas_Coord *h);

EOAPI extern const Eo_Event_Description _EFL_CANVAS_TEXT_EVENT_CHANGED;

/** The content (text or annotations) have changed.
 *
 * @ingroup Efl_Canvas_Text
 */
#define EFL_CANVAS_TEXT_EVENT_CHANGED (&(_EFL_CANVAS_TEXT_EVENT_CHANGED))

#endif
