/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report;

import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.sdb.XParametersSupplier;
import com.sun.star.sdbc.SQLException;
import com.sun.star.sdbc.XResultSetMetaData;
import com.sun.star.sdbc.XResultSetMetaDataSupplier;
import com.sun.star.sdbc.XRow;
import com.sun.star.sdbc.XRowSet;
import com.sun.star.sdbcx.XColumnsSupplier;
import com.sun.star.uno.Any;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.DateTime;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.libreoffice.report.DataSource;
import org.libreoffice.report.DataSourceException;

public class SDBCReportData
implements DataSource {
    private final XRowSet rowSet;
    private final XRow row;
    private int rowCount;
    private XIndexAccess parameters;
    private int firstParameterIndex = -1;
    private int columnCount;
    private final String[] columnNames;
    private final int[] columnTypes;

    public SDBCReportData(XRowSet rowSet) throws SQLException {
        this.row = (XRow)UnoRuntime.queryInterface(XRow.class, (Object)rowSet);
        this.rowSet = rowSet;
        if (rowSet == null) {
            this.rowCount = 0;
            this.columnCount = 0;
            this.columnTypes = new int[1];
            this.columnNames = new String[1];
        } else {
            XParametersSupplier xSuppParams = (XParametersSupplier)UnoRuntime.queryInterface(XParametersSupplier.class, (Object)rowSet);
            if (xSuppParams != null) {
                this.parameters = xSuppParams.getParameters();
            }
            XColumnsSupplier columnsSup = (XColumnsSupplier)UnoRuntime.queryInterface(XColumnsSupplier.class, (Object)rowSet);
            XNameAccess columns = columnsSup.getColumns();
            String[] columnNamesList = columns.getElementNames();
            XResultSetMetaDataSupplier sup = (XResultSetMetaDataSupplier)UnoRuntime.queryInterface(XResultSetMetaDataSupplier.class, (Object)rowSet);
            XResultSetMetaData resultSetMetaData = sup.getMetaData();
            this.columnCount = resultSetMetaData.getColumnCount();
            this.firstParameterIndex = this.columnCount + 1;
            if (this.parameters != null) {
                this.columnCount += this.parameters.getCount();
            }
            this.columnTypes = new int[this.columnCount];
            this.columnNames = new String[this.columnCount];
            for (int i = 1; i <= this.columnCount; ++i) {
                if (i < this.firstParameterIndex) {
                    this.columnNames[i - 1] = columnNamesList[i - 1];
                    this.columnTypes[i - 1] = resultSetMetaData.getColumnType(i);
                    continue;
                }
                try {
                    XPropertySet paramColumn = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.parameters.getByIndex(i - this.firstParameterIndex));
                    this.columnNames[i - 1] = (String)paramColumn.getPropertyValue("Name");
                    this.columnTypes[i - 1] = (Integer)paramColumn.getPropertyValue("Type");
                    continue;
                }
                catch (Exception e) {
                    this.columnNames[i - 1] = "Error";
                    this.columnTypes[i - 1] = 1;
                }
            }
            if (rowSet.last()) {
                this.rowCount = rowSet.getRow();
                rowSet.beforeFirst();
            } else {
                this.rowCount = 0;
            }
        }
    }

    public int getColumnCount() throws DataSourceException {
        return this.columnCount;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public String getColumnName(int column) throws DataSourceException {
        return this.columnNames[column - 1];
    }

    public boolean absolute(int row) throws DataSourceException {
        if (this.rowSet == null) {
            return false;
        }
        try {
            if (row == 0) {
                this.rowSet.beforeFirst();
                return true;
            }
            return this.rowSet.absolute(row);
        }
        catch (SQLException e) {
            throw new DataSourceException(e.getMessage(), e);
        }
    }

    public boolean next() throws DataSourceException {
        if (this.rowSet == null) {
            return false;
        }
        try {
            return this.rowSet.next();
        }
        catch (SQLException e) {
            throw new DataSourceException(e.getMessage(), e);
        }
    }

    public void close() throws DataSourceException {
    }

    private static Date getDate(Object obj) {
        Date date;
        if (obj instanceof com.sun.star.util.Date) {
            com.sun.star.util.Date unodate = (com.sun.star.util.Date)obj;
            date = Date.valueOf(SDBCReportData.getDateString(unodate.Year, unodate.Month, unodate.Day).toString());
        } else {
            date = null;
        }
        return date;
    }

    private static StringBuffer getTimeString(int hours, int minutes, int seconds) {
        StringBuffer timeString = new StringBuffer();
        if (hours < 10) {
            timeString.append('0');
        }
        timeString.append(hours);
        timeString.append(':');
        if (minutes < 10) {
            timeString.append('0');
        }
        timeString.append(minutes);
        timeString.append(':');
        if (seconds < 10) {
            timeString.append('0');
        }
        timeString.append(seconds);
        return timeString;
    }

    private static StringBuffer getDateString(int years, int months, int days) {
        StringBuffer str = new StringBuffer();
        str.append(years);
        StringBuffer str2 = new StringBuffer("0000");
        str2.delete(0, str.length());
        str.insert(0, str2);
        str.append('-');
        if (months < 10) {
            str.append('0');
        }
        str.append(months);
        str.append('-');
        if (days < 10) {
            str.append('0');
        }
        str.append(days);
        return str;
    }

    private static Time getTime(Object obj) {
        Time time;
        if (obj instanceof com.sun.star.util.Time) {
            com.sun.star.util.Time unoTime = (com.sun.star.util.Time)obj;
            time = Time.valueOf(SDBCReportData.getTimeString(unoTime.Hours, unoTime.Minutes, unoTime.Seconds).toString());
        } else {
            time = null;
        }
        return time;
    }

    private static Timestamp getTimestamp(Object obj) {
        Timestamp ts;
        if (obj instanceof DateTime) {
            DateTime unoTs = (DateTime)obj;
            StringBuffer str = SDBCReportData.getDateString(unoTs.Year, unoTs.Month, unoTs.Day);
            str.append(' ');
            str.append(SDBCReportData.getTimeString(unoTs.Hours, unoTs.Minutes, unoTs.Seconds));
            str.append('.');
            str.append(String.format("%09d", unoTs.NanoSeconds));
            ts = Timestamp.valueOf(str.toString());
        } else {
            ts = null;
        }
        return ts;
    }

    public Object getObject(int column) throws DataSourceException {
        if (this.rowSet == null) {
            return null;
        }
        try {
            boolean wasNull;
            Object obj;
            boolean isParameterValue;
            boolean bl = isParameterValue = this.parameters != null && column >= this.firstParameterIndex;
            if (isParameterValue) {
                XPropertySet paramCol = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.parameters.getByIndex(column - this.firstParameterIndex));
                obj = paramCol.getPropertyValue("Value");
                wasNull = obj == null;
            } else {
                obj = this.row.getObject(column, null);
                wasNull = this.row.wasNull();
            }
            obj = wasNull ? null : this.convertObject(this.columnTypes[column - 1], obj);
            return obj;
        }
        catch (SQLException ex) {
            throw new DataSourceException(ex.getMessage(), ex);
        }
        catch (UnknownPropertyException ex) {
            throw new DataSourceException(ex.getMessage(), ex);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new DataSourceException(ex.getMessage(), ex);
        }
        catch (WrappedTargetException ex) {
            throw new DataSourceException(ex.getMessage(), ex);
        }
    }

    private Object convertObject(int type, Object obj) {
        Object ret;
        switch (type) {
            case 91: {
                ret = SDBCReportData.getDate(obj);
                break;
            }
            case 92: {
                ret = SDBCReportData.getTime(obj);
                break;
            }
            case 93: {
                ret = SDBCReportData.getTimestamp(obj);
                break;
            }
            case 2: 
            case 3: {
                if (!(obj instanceof Any)) {
                    try {
                        ret = new BigDecimal(String.valueOf(obj));
                    }
                    catch (NumberFormatException ex) {
                        ret = obj;
                    }
                    break;
                }
                ret = obj;
                break;
            }
            default: {
                ret = obj;
            }
        }
        return ret;
    }
}

