/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.Locale;
import java.util.function.Function;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

enum DateFormat {
    Iso8601{

        @Override
        Function<String, DateTime> getFunction(String format, DateTimeZone timezone, Locale locale) {
            return arg_0 -> ((DateTimeFormatter)ISODateTimeFormat.dateTimeParser().withZone(timezone)).parseDateTime(arg_0);
        }
    }
    ,
    Unix{

        @Override
        Function<String, DateTime> getFunction(String format, DateTimeZone timezone, Locale locale) {
            return date -> new DateTime((long)(Float.parseFloat(date) * 1000.0f), timezone);
        }
    }
    ,
    UnixMs{

        @Override
        Function<String, DateTime> getFunction(String format, DateTimeZone timezone, Locale locale) {
            return date -> new DateTime(Long.parseLong(date), timezone);
        }
    }
    ,
    Tai64n{

        @Override
        Function<String, DateTime> getFunction(String format, DateTimeZone timezone, Locale locale) {
            return date -> new DateTime(this.parseMillis((String)date), timezone);
        }

        private long parseMillis(String date) {
            if (date.startsWith("@")) {
                date = date.substring(1);
            }
            long base = Long.parseLong(date.substring(1, 16), 16);
            long rest = Long.parseLong(date.substring(16, 24), 16);
            return base * 1000L - 10000L + rest / 1000000L;
        }
    }
    ,
    Joda{

        @Override
        Function<String, DateTime> getFunction(String format, DateTimeZone timezone, Locale locale) {
            DateTimeFormatter parser = DateTimeFormat.forPattern((String)format).withZone(timezone).withLocale(locale);
            return text -> parser.withDefaultYear(new DateTime(DateTimeZone.UTC).getYear()).parseDateTime(text);
        }
    };


    abstract Function<String, DateTime> getFunction(String var1, DateTimeZone var2, Locale var3);

    static DateFormat fromString(String format) {
        switch (format) {
            case "ISO8601": {
                return Iso8601;
            }
            case "UNIX": {
                return Unix;
            }
            case "UNIX_MS": {
                return UnixMs;
            }
            case "TAI64N": {
                return Tai64n;
            }
        }
        return Joda;
    }
}

