/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import org.apache.logging.log4j.ThreadContextAccess;
import org.apache.logging.log4j.core.ContextDataInjector;
import org.apache.logging.log4j.core.impl.ThreadContextDataInjector;
import org.apache.logging.log4j.spi.CopyOnWrite;
import org.apache.logging.log4j.spi.ThreadContextMap;
import org.apache.logging.log4j.spi.ThreadContextMap2;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.PropertiesUtil;

public class ContextDataInjectorFactory {
    public static ContextDataInjector createInjector() {
        String className = PropertiesUtil.getProperties().getStringProperty("log4j2.ContextDataInjector");
        if (className == null) {
            return ContextDataInjectorFactory.createDefaultInjector();
        }
        try {
            Class<ContextDataInjector> cls = LoaderUtil.loadClass((String)className).asSubclass(ContextDataInjector.class);
            return cls.newInstance();
        }
        catch (Exception dynamicFailed) {
            ContextDataInjector result = ContextDataInjectorFactory.createDefaultInjector();
            StatusLogger.getLogger().warn("Could not create ContextDataInjector for '{}', using default {}: {}", (Object)className, (Object)result.getClass().getName(), (Object)dynamicFailed);
            return result;
        }
    }

    private static ContextDataInjector createDefaultInjector() {
        ThreadContextMap threadContextMap = ThreadContextAccess.getThreadContextMap();
        if (threadContextMap instanceof CopyOnWrite && threadContextMap instanceof ThreadContextMap2) {
            return new ThreadContextDataInjector.ForCopyOnWriteThreadContextMap();
        }
        if (threadContextMap instanceof ThreadContextMap2) {
            return new ThreadContextDataInjector.ForGarbageFreeThreadContextMap();
        }
        return new ThreadContextDataInjector.ForDefaultThreadContextMap();
    }
}

