/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.tasks.list;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.admin.cluster.node.tasks.list.TaskGroup;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.tasks.TaskInfo;

public class ListTasksResponse
extends BaseTasksResponse
implements ToXContentObject {
    private List<TaskInfo> tasks;
    private Map<String, List<TaskInfo>> perNodeTasks;
    private List<TaskGroup> groups;

    public ListTasksResponse() {
        this(null, null, null);
    }

    public ListTasksResponse(List<TaskInfo> tasks, List<TaskOperationFailure> taskFailures, List<? extends FailedNodeException> nodeFailures) {
        super(taskFailures, nodeFailures);
        this.tasks = tasks == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<TaskInfo>(tasks));
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.tasks = Collections.unmodifiableList(in.readList(TaskInfo::new));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeList(this.tasks);
    }

    public Map<String, List<TaskInfo>> getPerNodeTasks() {
        if (this.perNodeTasks == null) {
            this.perNodeTasks = this.tasks.stream().collect(Collectors.groupingBy(t -> t.getTaskId().getNodeId()));
        }
        return this.perNodeTasks;
    }

    public List<TaskGroup> getTaskGroups() {
        if (this.groups == null) {
            this.buildTaskGroups();
        }
        return this.groups;
    }

    private void buildTaskGroups() {
        HashMap<TaskId, TaskGroup.Builder> taskGroups = new HashMap<TaskId, TaskGroup.Builder>();
        ArrayList<TaskGroup.Builder> topLevelTasks = new ArrayList<TaskGroup.Builder>();
        for (TaskInfo taskInfo : this.tasks) {
            taskGroups.put(taskInfo.getTaskId(), TaskGroup.builder(taskInfo));
        }
        for (TaskGroup.Builder taskGroup : taskGroups.values()) {
            TaskId parentTaskId = taskGroup.getTaskInfo().getParentTaskId();
            if (parentTaskId.isSet()) {
                TaskGroup.Builder parentTask = (TaskGroup.Builder)taskGroups.get(parentTaskId);
                if (parentTask != null) {
                    parentTask.addGroup(taskGroup);
                    continue;
                }
                topLevelTasks.add(taskGroup);
                continue;
            }
            topLevelTasks.add(taskGroup);
        }
        this.groups = Collections.unmodifiableList(topLevelTasks.stream().map(TaskGroup.Builder::build).collect(Collectors.toList()));
    }

    public List<TaskInfo> getTasks() {
        return this.tasks;
    }

    public XContentBuilder toXContentGroupedByNode(XContentBuilder builder, ToXContent.Params params, DiscoveryNodes discoveryNodes) throws IOException {
        this.toXContentCommon(builder, params);
        builder.startObject("nodes");
        for (Map.Entry<String, List<TaskInfo>> entry : this.getPerNodeTasks().entrySet()) {
            DiscoveryNode node = discoveryNodes.get(entry.getKey());
            builder.startObject(entry.getKey());
            if (node != null) {
                builder.field("name", node.getName());
                builder.field("transport_address", node.getAddress().toString());
                builder.field("host", node.getHostName());
                builder.field("ip", node.getAddress());
                builder.startArray("roles");
                for (DiscoveryNode.Role role : node.getRoles()) {
                    builder.value(role.getRoleName());
                }
                builder.endArray();
                if (!node.getAttributes().isEmpty()) {
                    builder.startObject("attributes");
                    for (Map.Entry entry2 : node.getAttributes().entrySet()) {
                        builder.field((String)entry2.getKey(), (String)entry2.getValue());
                    }
                    builder.endObject();
                }
            }
            builder.startObject("tasks");
            for (TaskInfo taskInfo : entry.getValue()) {
                builder.startObject(taskInfo.getTaskId().toString());
                taskInfo.toXContent(builder, params);
                builder.endObject();
            }
            builder.endObject();
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public XContentBuilder toXContentGroupedByParents(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.toXContentCommon(builder, params);
        builder.startObject("tasks");
        for (TaskGroup group : this.getTaskGroups()) {
            builder.field(group.getTaskInfo().getTaskId().toString());
            group.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toXContentGroupedByParents(builder, params);
        builder.endObject();
        return builder;
    }

    private void toXContentCommon(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.getTaskFailures() != null && this.getTaskFailures().size() > 0) {
            builder.startArray("task_failures");
            for (TaskOperationFailure taskOperationFailure : this.getTaskFailures()) {
                builder.startObject();
                builder.value((Object)taskOperationFailure);
                builder.endObject();
            }
            builder.endArray();
        }
        if (this.getNodeFailures() != null && this.getNodeFailures().size() > 0) {
            builder.startArray("node_failures");
            for (FailedNodeException failedNodeException : this.getNodeFailures()) {
                builder.startObject();
                failedNodeException.toXContent(builder, params);
                builder.endObject();
            }
            builder.endArray();
        }
    }

    public String toString() {
        return Strings.toString(this);
    }
}

