/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.document;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestResponseListener;

public abstract class RestHeadAction
extends BaseRestHandler {
    private final boolean source;

    public RestHeadAction(Settings settings, boolean source) {
        super(settings);
        this.source = source;
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        GetRequest getRequest = new GetRequest(request.param("index"), request.param("type"), request.param("id"));
        getRequest.operationThreaded(true);
        getRequest.refresh(request.paramAsBoolean("refresh", getRequest.refresh()));
        getRequest.routing(request.param("routing"));
        getRequest.parent(request.param("parent"));
        getRequest.preference(request.param("preference"));
        getRequest.realtime(request.paramAsBoolean("realtime", getRequest.realtime()));
        getRequest.storedFields(Strings.EMPTY_ARRAY);
        return channel -> client.get(getRequest, (ActionListener<GetResponse>)new RestResponseListener<GetResponse>(channel){

            @Override
            public RestResponse buildResponse(GetResponse response) {
                if (!response.isExists()) {
                    return new BytesRestResponse(RestStatus.NOT_FOUND, "text/plain; charset=UTF-8", BytesArray.EMPTY);
                }
                if (RestHeadAction.this.source && response.isSourceEmpty()) {
                    return new BytesRestResponse(RestStatus.NOT_FOUND, "text/plain; charset=UTF-8", BytesArray.EMPTY);
                }
                return new BytesRestResponse(RestStatus.OK, "text/plain; charset=UTF-8", BytesArray.EMPTY);
            }
        });
    }

    public static class Source
    extends RestHeadAction {
        public Source(Settings settings, RestController controller) {
            super(settings, true);
            controller.registerHandler(RestRequest.Method.HEAD, "/{index}/{type}/{id}/_source", this);
        }
    }

    public static class Document
    extends RestHeadAction {
        public Document(Settings settings, RestController controller) {
            super(settings, false);
            controller.registerHandler(RestRequest.Method.HEAD, "/{index}/{type}/{id}", this);
        }
    }
}

