/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.notes;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.notes.NoteComment;
import org.openstreetmap.josm.tools.I18n;

public class Note {
    public static final Comparator<Note> DEFAULT_COMPARATOR = (note, note2) -> {
        if (note.getId() < 0L && note2.getId() > 0L) {
            return 1;
        }
        if (note.getId() > 0L && note2.getId() < 0L) {
            return -1;
        }
        if (note.getState() == State.CLOSED && note2.getState() == State.OPEN) {
            return 1;
        }
        if (note.getState() == State.OPEN && note2.getState() == State.CLOSED) {
            return -1;
        }
        return Long.compare(Math.abs(note.getId()), Math.abs(note2.getId()));
    };
    public static final Comparator<Note> DATE_COMPARATOR = (note, note2) -> note.createdAt.compareTo(note2.createdAt);
    public static final Comparator<Note> USER_COMPARATOR = (note, note2) -> {
        String string;
        String string2 = note.getFirstComment().getUser().getName();
        return string2.equals(string = note2.getFirstComment().getUser().getName()) ? DATE_COMPARATOR.compare((Note)note, (Note)note2) : string2.compareTo(string);
    };
    public static final Comparator<Note> LAST_ACTION_COMPARATOR = (note, note2) -> NoteComment.DATE_COMPARATOR.compare(note.getLastComment(), note2.getLastComment());
    private long id;
    private LatLon latLon;
    private Date createdAt;
    private Date closedAt;
    private State state;
    private List<NoteComment> comments = new ArrayList<NoteComment>();

    public Note(LatLon latLon) {
        this.latLon = latLon;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long l) {
        this.id = l;
    }

    public LatLon getLatLon() {
        return this.latLon;
    }

    public Date getCreatedAt() {
        return Note.cloneDate(this.createdAt);
    }

    public void setCreatedAt(Date date) {
        this.createdAt = Note.cloneDate(date);
    }

    public Date getClosedAt() {
        return Note.cloneDate(this.closedAt);
    }

    public void setClosedAt(Date date) {
        this.closedAt = Note.cloneDate(date);
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public List<NoteComment> getComments() {
        return this.comments;
    }

    public NoteComment getLastComment() {
        return this.comments.isEmpty() ? null : this.comments.get(this.comments.size() - 1);
    }

    public void addComment(NoteComment noteComment) {
        this.comments.add(noteComment);
    }

    public NoteComment getFirstComment() {
        return this.comments.isEmpty() ? null : this.comments.get(0);
    }

    public void updateWith(Note note) {
        this.comments = note.comments;
        this.createdAt = Note.cloneDate(note.createdAt);
        this.id = note.id;
        this.state = note.state;
        this.latLon = note.latLon;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Note note = (Note)object;
        return this.id == note.id;
    }

    public String toString() {
        return I18n.tr("Note", new Object[0]) + ' ' + this.id + ": " + this.getFirstComment();
    }

    static Date cloneDate(Date date) {
        return date != null ? (Date)date.clone() : null;
    }

    public static enum State {
        OPEN,
        CLOSED;

    }
}

