/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.ast;

import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.language.SourceIndexLength;
import org.jruby.truffle.parser.ast.NilImplicitParseNode;
import org.jruby.truffle.parser.ast.NodeType;
import org.jruby.truffle.parser.ast.ParseNode;
import org.jruby.truffle.parser.ast.visitor.NodeVisitor;

public class ListParseNode
extends ParseNode {
    private static final ParseNode[] EMPTY = new ParseNode[0];
    private static final int INITIAL_SIZE = 4;
    private ParseNode[] list;
    private int size = 0;

    public ListParseNode(SourceIndexLength position, ParseNode firstNode) {
        super(position, firstNode != null && firstNode.containsVariableAssignment);
        this.list = new ParseNode[4];
        this.addInternal(firstNode);
    }

    public ListParseNode(SourceIndexLength position) {
        super(position, false);
        this.list = EMPTY;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.LISTNODE;
    }

    protected void growList(int mustBeDelta) {
        int newSize = this.list.length * 2;
        if (this.size + mustBeDelta >= newSize) {
            newSize = (int)((double)(this.size + mustBeDelta) * 1.5);
        }
        ParseNode[] newList = new ParseNode[newSize];
        System.arraycopy(this.list, 0, newList, 0, this.size);
        this.list = newList;
    }

    protected void addInternal(ParseNode node) {
        if (this.size >= this.list.length) {
            this.growList(1);
        }
        this.list[this.size++] = node;
    }

    protected void addAllInternal(ListParseNode other) {
        if (this.size + other.size() >= this.list.length) {
            this.growList(other.size);
        }
        System.arraycopy(other.list, 0, this.list, this.size, other.size);
        this.size += other.size;
    }

    public ListParseNode add(ParseNode node) {
        if (node == null || node == NilImplicitParseNode.NIL) {
            this.addInternal(NilImplicitParseNode.NIL);
            return this;
        }
        if (node.containsVariableAssignment()) {
            this.containsVariableAssignment = true;
        }
        this.addInternal(node);
        if (this.getPosition() == null) {
            this.setPosition(node.getPosition());
        }
        return this;
    }

    public int size() {
        return this.size;
    }

    public ListParseNode addAll(ListParseNode other) {
        if (other != null && other.size() > 0) {
            if (other.containsVariableAssignment()) {
                this.containsVariableAssignment = true;
            }
            this.addAllInternal(other);
            if (this.getPosition() == null) {
                this.setPosition(other.getPosition());
            }
        }
        return this;
    }

    public ListParseNode addAll(ParseNode[] other, int index, int length) {
        for (int i = 0; i < length; ++i) {
            this.addInternal(other[index + i]);
        }
        return this;
    }

    public ListParseNode addAll(ParseNode other) {
        return this.add(other);
    }

    public ParseNode getLast() {
        return this.size == 0 ? null : this.list[this.size - 1];
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public ParseNode[] children() {
        ParseNode[] properList = new ParseNode[this.size];
        System.arraycopy(this.list, 0, properList, 0, this.size);
        return properList;
    }

    @Override
    @Deprecated
    public List<ParseNode> childNodes() {
        return Arrays.asList(this.children());
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visitListNode(this);
    }

    public ParseNode get(int idx) {
        return this.list[idx];
    }
}

