/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.ast;

import java.util.List;
import org.jruby.truffle.language.SourceIndexLength;
import org.jruby.truffle.parser.ast.NodeType;
import org.jruby.truffle.parser.ast.ParseNode;
import org.jruby.truffle.parser.ast.visitor.NodeVisitor;

public class Match3ParseNode
extends ParseNode {
    private final ParseNode receiverNode;
    private final ParseNode valueNode;

    public Match3ParseNode(SourceIndexLength position, ParseNode receiverNode, ParseNode valueNode) {
        super(position, receiverNode.containsVariableAssignment() || valueNode.containsVariableAssignment());
        assert (receiverNode != null) : "receiverNode is not null";
        assert (valueNode != null) : "valueNode is not null";
        this.receiverNode = receiverNode;
        this.valueNode = valueNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.MATCH3NODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitMatch3Node(this);
    }

    public ParseNode getReceiverNode() {
        return this.receiverNode;
    }

    public ParseNode getValueNode() {
        return this.valueNode;
    }

    @Override
    public List<ParseNode> childNodes() {
        return ParseNode.createList(this.receiverNode, this.valueNode);
    }

    @Override
    public boolean needsDefinitionCheck() {
        return false;
    }
}

