/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.LexicalScope;
import org.jruby.truffle.language.RubyGuards;

public class RubyConstant {
    private final DynamicObject declaringModule;
    private final Object value;
    private final boolean isPrivate;
    private final boolean autoload;
    private final boolean isDeprecated;

    public RubyConstant(DynamicObject declaringModule, Object value, boolean isPrivate, boolean autoload, boolean isDeprecated) {
        assert (RubyGuards.isRubyModule(declaringModule));
        this.declaringModule = declaringModule;
        this.value = value;
        this.isPrivate = isPrivate;
        this.autoload = autoload;
        this.isDeprecated = isDeprecated;
    }

    public DynamicObject getDeclaringModule() {
        return this.declaringModule;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    public RubyConstant withPrivate(boolean isPrivate) {
        if (isPrivate == this.isPrivate) {
            return this;
        }
        return new RubyConstant(this.declaringModule, this.value, isPrivate, this.autoload, this.isDeprecated);
    }

    public RubyConstant withDeprecated() {
        if (this.isDeprecated()) {
            return this;
        }
        return new RubyConstant(this.declaringModule, this.value, this.isPrivate, this.autoload, true);
    }

    public boolean isVisibleTo(RubyContext context, LexicalScope lexicalScope, DynamicObject module) {
        CompilerAsserts.neverPartOfCompilation();
        assert (RubyGuards.isRubyModule(module));
        assert (lexicalScope == null || lexicalScope.getLiveModule() == module);
        if (!this.isPrivate) {
            return true;
        }
        if (lexicalScope != null) {
            while (lexicalScope != context.getRootLexicalScope()) {
                if (lexicalScope.getLiveModule() == this.declaringModule) {
                    return true;
                }
                lexicalScope = lexicalScope.getParent();
            }
        }
        if (RubyGuards.isRubyClass(module)) {
            for (DynamicObject included : Layouts.MODULE.getFields(module).parentAncestors()) {
                if (included != this.declaringModule) continue;
                return true;
            }
        }
        return lexicalScope != null && context.getCoreLibrary().getObjectClass() == this.declaringModule;
    }

    public boolean isAutoload() {
        return this.autoload;
    }
}

