/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk.byscroll;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.bulk.byscroll.SuccessfullyProcessed;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.tasks.TaskInfo;

public abstract class BulkByScrollTask
extends CancellableTask {
    public BulkByScrollTask(long id, String type, String action, String description, TaskId parentTaskId) {
        super(id, type, action, description, parentTaskId);
    }

    public abstract int runningSliceSubTasks();

    public abstract void rethrottle(float var1);

    @Override
    public abstract Status getStatus();

    public abstract TaskInfo getInfoGivenSliceInfo(String var1, List<TaskInfo> var2);

    @Override
    public boolean shouldCancelChildrenOnCancellation() {
        return true;
    }

    public static class StatusOrException
    implements Writeable,
    ToXContent {
        private final Status status;
        private final Exception exception;

        public StatusOrException(Status status) {
            this.status = status;
            this.exception = null;
        }

        public StatusOrException(Exception exception) {
            this.status = null;
            this.exception = exception;
        }

        public StatusOrException(StreamInput in) throws IOException {
            if (in.readBoolean()) {
                this.status = new Status(in);
                this.exception = null;
            } else {
                this.status = null;
                this.exception = in.readException();
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (this.exception == null) {
                out.writeBoolean(true);
                this.status.writeTo(out);
            } else {
                out.writeBoolean(false);
                out.writeException(this.exception);
            }
        }

        public Status getStatus() {
            return this.status;
        }

        public Exception getException() {
            return this.exception;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this.exception == null) {
                this.status.toXContent(builder, params);
            } else {
                builder.startObject();
                ElasticsearchException.generateThrowableXContent(builder, params, this.exception);
                builder.endObject();
            }
            return builder;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != StatusOrException.class) {
                return false;
            }
            StatusOrException other = (StatusOrException)obj;
            return Objects.equals(this.status, other.status) && Objects.equals(this.exception, other.exception);
        }

        public int hashCode() {
            return Objects.hash(this.status, this.exception);
        }
    }

    public static class Status
    implements Task.Status,
    SuccessfullyProcessed {
        public static final String NAME = "bulk-by-scroll";
        public static final String INCLUDE_CREATED = "include_created";
        public static final String INCLUDE_UPDATED = "include_updated";
        private final Integer sliceId;
        private final long total;
        private final long updated;
        private final long created;
        private final long deleted;
        private final int batches;
        private final long versionConflicts;
        private final long noops;
        private final long bulkRetries;
        private final long searchRetries;
        private final TimeValue throttled;
        private final float requestsPerSecond;
        private final String reasonCancelled;
        private final TimeValue throttledUntil;
        private final List<StatusOrException> sliceStatuses;

        public Status(Integer sliceId, long total, long updated, long created, long deleted, int batches, long versionConflicts, long noops, long bulkRetries, long searchRetries, TimeValue throttled, float requestsPerSecond, @Nullable String reasonCancelled, TimeValue throttledUntil) {
            this.sliceId = sliceId == null ? null : Integer.valueOf(this.checkPositive(sliceId, "sliceId"));
            this.total = this.checkPositive(total, "total");
            this.updated = this.checkPositive(updated, "updated");
            this.created = this.checkPositive(created, "created");
            this.deleted = this.checkPositive(deleted, "deleted");
            this.batches = this.checkPositive(batches, "batches");
            this.versionConflicts = this.checkPositive(versionConflicts, "versionConflicts");
            this.noops = this.checkPositive(noops, "noops");
            this.bulkRetries = this.checkPositive(bulkRetries, "bulkRetries");
            this.searchRetries = this.checkPositive(searchRetries, "searchRetries");
            this.throttled = throttled;
            this.requestsPerSecond = requestsPerSecond;
            this.reasonCancelled = reasonCancelled;
            this.throttledUntil = throttledUntil;
            this.sliceStatuses = Collections.emptyList();
        }

        public Status(List<StatusOrException> sliceStatuses, @Nullable String reasonCancelled) {
            this.sliceId = null;
            this.reasonCancelled = reasonCancelled;
            long mergedTotal = 0L;
            long mergedUpdated = 0L;
            long mergedCreated = 0L;
            long mergedDeleted = 0L;
            int mergedBatches = 0;
            long mergedVersionConflicts = 0L;
            long mergedNoops = 0L;
            long mergedBulkRetries = 0L;
            long mergedSearchRetries = 0L;
            long mergedThrottled = 0L;
            float mergedRequestsPerSecond = 0.0f;
            long mergedThrottledUntil = Long.MAX_VALUE;
            for (StatusOrException slice : sliceStatuses) {
                if (slice == null || slice.status == null) continue;
                mergedTotal += slice.status.getTotal();
                mergedUpdated += slice.status.getUpdated();
                mergedCreated += slice.status.getCreated();
                mergedDeleted += slice.status.getDeleted();
                mergedBatches += slice.status.getBatches();
                mergedVersionConflicts += slice.status.getVersionConflicts();
                mergedNoops += slice.status.getNoops();
                mergedBulkRetries += slice.status.getBulkRetries();
                mergedSearchRetries += slice.status.getSearchRetries();
                mergedThrottled += slice.status.getThrottled().nanos();
                mergedRequestsPerSecond += slice.status.getRequestsPerSecond();
                mergedThrottledUntil = Math.min(mergedThrottledUntil, slice.status.getThrottledUntil().nanos());
            }
            this.total = mergedTotal;
            this.updated = mergedUpdated;
            this.created = mergedCreated;
            this.deleted = mergedDeleted;
            this.batches = mergedBatches;
            this.versionConflicts = mergedVersionConflicts;
            this.noops = mergedNoops;
            this.bulkRetries = mergedBulkRetries;
            this.searchRetries = mergedSearchRetries;
            this.throttled = TimeValue.timeValueNanos(mergedThrottled);
            this.requestsPerSecond = mergedRequestsPerSecond;
            this.throttledUntil = TimeValue.timeValueNanos(mergedThrottledUntil == Long.MAX_VALUE ? 0L : mergedThrottledUntil);
            this.sliceStatuses = sliceStatuses;
        }

        public Status(StreamInput in) throws IOException {
            this.sliceId = in.getVersion().onOrAfter(Version.V_5_1_1_UNRELEASED) ? in.readOptionalVInt() : null;
            this.total = in.readVLong();
            this.updated = in.readVLong();
            this.created = in.readVLong();
            this.deleted = in.readVLong();
            this.batches = in.readVInt();
            this.versionConflicts = in.readVLong();
            this.noops = in.readVLong();
            this.bulkRetries = in.readVLong();
            this.searchRetries = in.readVLong();
            this.throttled = new TimeValue(in);
            this.requestsPerSecond = in.readFloat();
            this.reasonCancelled = in.readOptionalString();
            this.throttledUntil = new TimeValue(in);
            this.sliceStatuses = in.getVersion().onOrAfter(Version.V_5_1_1_UNRELEASED) ? in.readList(stream -> stream.readOptionalWriteable(StatusOrException::new)) : Collections.emptyList();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (out.getVersion().onOrAfter(Version.V_5_1_1_UNRELEASED)) {
                out.writeOptionalVInt(this.sliceId);
            }
            out.writeVLong(this.total);
            out.writeVLong(this.updated);
            out.writeVLong(this.created);
            out.writeVLong(this.deleted);
            out.writeVInt(this.batches);
            out.writeVLong(this.versionConflicts);
            out.writeVLong(this.noops);
            out.writeVLong(this.bulkRetries);
            out.writeVLong(this.searchRetries);
            this.throttled.writeTo(out);
            out.writeFloat(this.requestsPerSecond);
            out.writeOptionalString(this.reasonCancelled);
            this.throttledUntil.writeTo(out);
            if (out.getVersion().onOrAfter(Version.V_5_1_1_UNRELEASED)) {
                out.writeVInt(this.sliceStatuses.size());
                for (StatusOrException sliceStatus : this.sliceStatuses) {
                    out.writeOptionalWriteable(sliceStatus);
                }
            }
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.innerXContent(builder, params);
            return builder.endObject();
        }

        public XContentBuilder innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this.sliceId != null) {
                builder.field("slice_id", this.sliceId);
            }
            builder.field("total", this.total);
            if (params.paramAsBoolean(INCLUDE_UPDATED, true)) {
                builder.field("updated", this.updated);
            }
            if (params.paramAsBoolean(INCLUDE_CREATED, true)) {
                builder.field("created", this.created);
            }
            builder.field("deleted", this.deleted);
            builder.field("batches", this.batches);
            builder.field("version_conflicts", this.versionConflicts);
            builder.field("noops", this.noops);
            builder.startObject("retries");
            builder.field("bulk", this.bulkRetries);
            builder.field("search", this.searchRetries);
            builder.endObject();
            builder.timeValueField("throttled_millis", "throttled", this.throttled);
            builder.field("requests_per_second", this.requestsPerSecond == Float.POSITIVE_INFINITY ? -1.0f : this.requestsPerSecond);
            if (this.reasonCancelled != null) {
                builder.field("canceled", this.reasonCancelled);
            }
            builder.timeValueField("throttled_until_millis", "throttled_until", this.throttledUntil);
            if (!this.sliceStatuses.isEmpty()) {
                builder.startArray("slices");
                for (StatusOrException slice : this.sliceStatuses) {
                    if (slice == null) {
                        builder.nullValue();
                        continue;
                    }
                    slice.toXContent(builder, params);
                }
                builder.endArray();
            }
            return builder;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("BulkIndexByScrollResponse[");
            this.innerToString(builder);
            return builder.append(']').toString();
        }

        public void innerToString(StringBuilder builder) {
            builder.append("sliceId=").append(this.sliceId);
            builder.append(",updated=").append(this.updated);
            builder.append(",created=").append(this.created);
            builder.append(",deleted=").append(this.deleted);
            builder.append(",batches=").append(this.batches);
            builder.append(",versionConflicts=").append(this.versionConflicts);
            builder.append(",noops=").append(this.noops);
            builder.append(",retries=").append(this.bulkRetries);
            if (this.reasonCancelled != null) {
                builder.append(",canceled=").append(this.reasonCancelled);
            }
            builder.append(",throttledUntil=").append(this.throttledUntil);
            if (!this.sliceStatuses.isEmpty()) {
                builder.append(",workers=").append(this.sliceStatuses);
            }
        }

        Integer getSliceId() {
            return this.sliceId;
        }

        public long getTotal() {
            return this.total;
        }

        @Override
        public long getUpdated() {
            return this.updated;
        }

        @Override
        public long getCreated() {
            return this.created;
        }

        @Override
        public long getDeleted() {
            return this.deleted;
        }

        public int getBatches() {
            return this.batches;
        }

        public long getVersionConflicts() {
            return this.versionConflicts;
        }

        public long getNoops() {
            return this.noops;
        }

        public long getBulkRetries() {
            return this.bulkRetries;
        }

        public long getSearchRetries() {
            return this.searchRetries;
        }

        public TimeValue getThrottled() {
            return this.throttled;
        }

        public float getRequestsPerSecond() {
            return this.requestsPerSecond;
        }

        public String getReasonCancelled() {
            return this.reasonCancelled;
        }

        public TimeValue getThrottledUntil() {
            return this.throttledUntil;
        }

        public List<StatusOrException> getSliceStatuses() {
            return this.sliceStatuses;
        }

        private int checkPositive(int value, String name) {
            if (value < 0) {
                throw new IllegalArgumentException(name + " must be greater than 0 but was [" + value + "]");
            }
            return value;
        }

        private long checkPositive(long value, String name) {
            if (value < 0L) {
                throw new IllegalArgumentException(name + " must be greater than 0 but was [" + value + "]");
            }
            return value;
        }
    }
}

