/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.replication;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.UnavailableShardsException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.action.support.replication.ReplicationOperation;
import org.elasticsearch.action.support.replication.ReplicationRequest;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.action.support.replication.ReplicationTask;
import org.elasticsearch.client.transport.NoNodeAvailableException;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardNotFoundException;
import org.elasticsearch.indices.IndexClosedException;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportChannelResponseHandler;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public abstract class TransportReplicationAction<Request extends ReplicationRequest<Request>, ReplicaRequest extends ReplicationRequest<ReplicaRequest>, Response extends ReplicationResponse>
extends TransportAction<Request, Response> {
    private final TransportService transportService;
    protected final ClusterService clusterService;
    private final IndicesService indicesService;
    private final ShardStateAction shardStateAction;
    private final TransportRequestOptions transportOptions;
    private final String executor;
    private final String transportReplicaAction;
    private final String transportPrimaryAction;
    private final ReplicasProxy replicasProxy;

    protected TransportReplicationAction(Settings settings, String actionName, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<Request> request, Supplier<ReplicaRequest> replicaRequest, String executor) {
        super(settings, actionName, threadPool, actionFilters, indexNameExpressionResolver, transportService.getTaskManager());
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.shardStateAction = shardStateAction;
        this.executor = executor;
        this.transportPrimaryAction = actionName + "[p]";
        this.transportReplicaAction = actionName + "[r]";
        transportService.registerRequestHandler(actionName, request, "same", new OperationTransportHandler());
        transportService.registerRequestHandler(this.transportPrimaryAction, () -> new ConcreteShardRequest(request), executor, new PrimaryOperationTransportHandler());
        transportService.registerRequestHandler(this.transportReplicaAction, () -> new ConcreteShardRequest(replicaRequest), executor, true, true, new ReplicaOperationTransportHandler());
        this.transportOptions = this.transportOptions();
        this.replicasProxy = new ReplicasProxy();
    }

    @Override
    protected final void doExecute(Request request, ActionListener<Response> listener) {
        throw new UnsupportedOperationException("the task parameter is required for this operation");
    }

    @Override
    protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
        new ReroutePhase(this, (ReplicationTask)task, request, listener).run();
    }

    protected abstract Response newResponseInstance();

    protected void resolveRequest(MetaData metaData, IndexMetaData indexMetaData, Request request) {
        if (((ReplicationRequest)request).waitForActiveShards() == ActiveShardCount.DEFAULT) {
            ((ReplicationRequest)request).waitForActiveShards(indexMetaData.getWaitForActiveShards());
        }
    }

    protected abstract PrimaryResult<ReplicaRequest, Response> shardOperationOnPrimary(Request var1, IndexShard var2) throws Exception;

    protected abstract ReplicaResult shardOperationOnReplica(ReplicaRequest var1, IndexShard var2) throws Exception;

    @Nullable
    protected ClusterBlockLevel globalBlockLevel() {
        return null;
    }

    @Nullable
    protected ClusterBlockLevel indexBlockLevel() {
        return null;
    }

    protected boolean resolveIndex() {
        return true;
    }

    protected TransportRequestOptions transportOptions() {
        return TransportRequestOptions.EMPTY;
    }

    protected boolean retryPrimaryException(Throwable e) {
        return e.getClass() == ReplicationOperation.RetryOnPrimaryException.class || TransportActions.isShardNotAvailableException(e);
    }

    private IndexShard getIndexShard(ShardId shardId) {
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        return indexService.getShard(shardId.id());
    }

    private void acquirePrimaryShardReference(ShardId shardId, String allocationId, final ActionListener<PrimaryShardReference> onReferenceAcquired) {
        final IndexShard indexShard = this.getIndexShard(shardId);
        if (!indexShard.routingEntry().primary()) {
            throw new ReplicationOperation.RetryOnPrimaryException(indexShard.shardId(), "actual shard is not a primary " + indexShard.routingEntry());
        }
        String actualAllocationId = indexShard.routingEntry().allocationId().getId();
        if (!actualAllocationId.equals(allocationId)) {
            throw new ShardNotFoundException(shardId, "expected aID [{}] but found [{}]", allocationId, actualAllocationId);
        }
        ActionListener<Releasable> onAcquired = new ActionListener<Releasable>(){

            @Override
            public void onResponse(Releasable releasable) {
                onReferenceAcquired.onResponse(new PrimaryShardReference(indexShard, releasable));
            }

            @Override
            public void onFailure(Exception e) {
                onReferenceAcquired.onFailure(e);
            }
        };
        indexShard.acquirePrimaryOperationLock(onAcquired, this.executor);
    }

    protected boolean shouldExecuteReplication(IndexMetaData indexMetaData) {
        return !IndexMetaData.isIndexUsingShadowReplicas(indexMetaData.getSettings());
    }

    static void setPhase(ReplicationTask task, String phase) {
        if (task != null) {
            task.setPhase(phase);
        }
    }

    public static final class ConcreteShardRequest<R extends TransportRequest>
    extends TransportRequest {
        private String targetAllocationID;
        private R request;

        ConcreteShardRequest(Supplier<R> requestSupplier) {
            this.request = (TransportRequest)requestSupplier.get();
            this.targetAllocationID = null;
        }

        ConcreteShardRequest(R request, String targetAllocationID) {
            Objects.requireNonNull(request);
            Objects.requireNonNull(targetAllocationID);
            this.request = request;
            this.targetAllocationID = targetAllocationID;
        }

        @Override
        public void setParentTask(String parentTaskNode, long parentTaskId) {
            ((TransportRequest)this.request).setParentTask(parentTaskNode, parentTaskId);
        }

        @Override
        public void setParentTask(TaskId taskId) {
            ((TransportRequest)this.request).setParentTask(taskId);
        }

        @Override
        public TaskId getParentTask() {
            return ((TransportRequest)this.request).getParentTask();
        }

        @Override
        public Task createTask(long id, String type, String action, TaskId parentTaskId) {
            return ((TransportRequest)this.request).createTask(id, type, action, parentTaskId);
        }

        @Override
        public String getDescription() {
            return "[" + ((TransportRequest)this.request).getDescription() + "] for aID [" + this.targetAllocationID + "]";
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.targetAllocationID = in.readString();
            ((TransportRequest)this.request).readFrom(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.targetAllocationID);
            ((TransportRequest)this.request).writeTo(out);
        }

        public R getRequest() {
            return this.request;
        }

        public String getTargetAllocationID() {
            return this.targetAllocationID;
        }

        public String toString() {
            return "request: " + this.request + ", target allocation id: " + this.targetAllocationID;
        }
    }

    final class ReplicasProxy
    implements ReplicationOperation.Replicas<ReplicaRequest> {
        ReplicasProxy() {
        }

        @Override
        public void performOn(ShardRouting replica, ReplicaRequest request, ActionListener<TransportResponse.Empty> listener) {
            String nodeId = replica.currentNodeId();
            DiscoveryNode node = TransportReplicationAction.this.clusterService.state().nodes().get(nodeId);
            if (node == null) {
                listener.onFailure(new NoNodeAvailableException("unknown node [" + nodeId + "]"));
                return;
            }
            TransportReplicationAction.this.transportService.sendRequest(node, TransportReplicationAction.this.transportReplicaAction, new ConcreteShardRequest(request, replica.allocationId().getId()), TransportReplicationAction.this.transportOptions, new ActionListenerResponseHandler<TransportResponse.Empty>(listener, () -> TransportResponse.Empty.INSTANCE));
        }

        @Override
        public void failShard(ShardRouting replica, long primaryTerm, String message, Exception exception, Runnable onSuccess, Consumer<Exception> onPrimaryDemoted, Consumer<Exception> onIgnoredFailure) {
            TransportReplicationAction.this.shardStateAction.remoteShardFailed(replica.shardId(), replica.allocationId().getId(), primaryTerm, message, exception, this.createListener(onSuccess, onPrimaryDemoted, onIgnoredFailure));
        }

        @Override
        public void markShardCopyAsStale(ShardId shardId, String allocationId, long primaryTerm, Runnable onSuccess, Consumer<Exception> onPrimaryDemoted, Consumer<Exception> onIgnoredFailure) {
            TransportReplicationAction.this.shardStateAction.remoteShardFailed(shardId, allocationId, primaryTerm, "mark copy as stale", null, this.createListener(onSuccess, onPrimaryDemoted, onIgnoredFailure));
        }

        private ShardStateAction.Listener createListener(final Runnable onSuccess, final Consumer<Exception> onPrimaryDemoted, final Consumer<Exception> onIgnoredFailure) {
            return new ShardStateAction.Listener(){

                @Override
                public void onSuccess() {
                    onSuccess.run();
                }

                @Override
                public void onFailure(Exception shardFailedError) {
                    if (shardFailedError instanceof ShardStateAction.NoLongerPrimaryShardException) {
                        onPrimaryDemoted.accept(shardFailedError);
                    } else {
                        assert (shardFailedError instanceof TransportException || shardFailedError instanceof NodeClosedException) : shardFailedError;
                        onIgnoredFailure.accept(shardFailedError);
                    }
                }
            };
        }
    }

    class PrimaryShardReference
    implements ReplicationOperation.Primary<Request, ReplicaRequest, PrimaryResult<ReplicaRequest, Response>>,
    Releasable {
        private final IndexShard indexShard;
        private final Releasable operationLock;

        PrimaryShardReference(IndexShard indexShard, Releasable operationLock) {
            this.indexShard = indexShard;
            this.operationLock = operationLock;
        }

        @Override
        public void close() {
            this.operationLock.close();
        }

        public boolean isRelocated() {
            return this.indexShard.state() == IndexShardState.RELOCATED;
        }

        @Override
        public void failShard(String reason, Exception e) {
            try {
                this.indexShard.failShard(reason, e);
            }
            catch (Exception inner) {
                e.addSuppressed(inner);
            }
        }

        @Override
        public PrimaryResult perform(Request request) throws Exception {
            PrimaryResult result = TransportReplicationAction.this.shardOperationOnPrimary(request, this.indexShard);
            if (result.replicaRequest() != null) {
                ((ReplicationRequest)result.replicaRequest()).primaryTerm(this.indexShard.getPrimaryTerm());
            }
            return result;
        }

        @Override
        public ShardRouting routingEntry() {
            return this.indexShard.routingEntry();
        }
    }

    static final class ReroutePhase
    extends AbstractRunnable {
        private final ActionListener<Response> listener;
        private final Request request;
        private final ReplicationTask task;
        private final ClusterStateObserver observer;
        private final AtomicBoolean finished = new AtomicBoolean();
        final /* synthetic */ TransportReplicationAction this$0;

        ReroutePhase(ReplicationTask task, Request request, ActionListener<Response> listener) {
            this.this$0 = this$0;
            this.request = request;
            if (task != null) {
                ((TransportRequest)this.request).setParentTask(this$0.clusterService.localNode().getId(), task.getId());
            }
            this.listener = listener;
            this.task = task;
            this.observer = new ClusterStateObserver(this$0.clusterService, ((ReplicationRequest)request).timeout(), ((TransportReplicationAction)this$0).logger, ((TransportReplicationAction)this$0).threadPool.getThreadContext());
        }

        @Override
        public void onFailure(Exception e) {
            this.finishWithUnexpectedFailure(e);
        }

        @Override
        protected void doRun() {
            TransportReplicationAction.setPhase(this.task, "routing");
            ClusterState state = this.observer.setAndGetObservedState();
            if (this.handleBlockExceptions(state)) {
                return;
            }
            String concreteIndex = this.concreteIndex(state);
            IndexMetaData indexMetaData = state.metaData().index(concreteIndex);
            if (indexMetaData == null) {
                this.retry(new IndexNotFoundException(concreteIndex));
                return;
            }
            if (indexMetaData.getState() == IndexMetaData.State.CLOSE) {
                throw new IndexClosedException(indexMetaData.getIndex());
            }
            this.this$0.resolveRequest(state.metaData(), indexMetaData, this.request);
            assert (((ReplicationRequest)this.request).shardId() != null) : "request shardId must be set in resolveRequest";
            assert (((ReplicationRequest)this.request).waitForActiveShards() != ActiveShardCount.DEFAULT) : "request waitForActiveShards must be set in resolveRequest";
            ShardRouting primary = this.primary(state);
            if (this.retryIfUnavailable(state, primary)) {
                return;
            }
            DiscoveryNode node = state.nodes().get(primary.currentNodeId());
            if (primary.currentNodeId().equals(state.nodes().getLocalNodeId())) {
                this.performLocalAction(state, primary, node);
            } else {
                this.performRemoteAction(state, primary, node);
            }
        }

        private void performLocalAction(ClusterState state, ShardRouting primary, DiscoveryNode node) {
            TransportReplicationAction.setPhase(this.task, "waiting_on_primary");
            if (this.this$0.logger.isTraceEnabled()) {
                this.this$0.logger.trace("send action [{}] on primary [{}] for request [{}] with cluster state version [{}] to [{}] ", (Object)this.this$0.transportPrimaryAction, (Object)((ReplicationRequest)this.request).shardId(), this.request, (Object)state.version(), (Object)primary.currentNodeId());
            }
            this.performAction(node, this.this$0.transportPrimaryAction, true, new ConcreteShardRequest(this.request, primary.allocationId().getId()));
        }

        private void performRemoteAction(ClusterState state, ShardRouting primary, DiscoveryNode node) {
            if (state.version() < ((ReplicationRequest)this.request).routedBasedOnClusterVersion()) {
                this.this$0.logger.trace("failed to find primary [{}] for request [{}] despite sender thinking it would be here. Local cluster state version [{}]] is older than on sending node (version [{}]), scheduling a retry...", (Object)((ReplicationRequest)this.request).shardId(), this.request, (Object)state.version(), (Object)((ReplicationRequest)this.request).routedBasedOnClusterVersion());
                this.retryBecauseUnavailable(((ReplicationRequest)this.request).shardId(), "failed to find primary as current cluster state with version [" + state.version() + "] is stale (expected at least [" + ((ReplicationRequest)this.request).routedBasedOnClusterVersion() + "]");
                return;
            }
            ((ReplicationRequest)this.request).routedBasedOnClusterVersion(state.version());
            if (this.this$0.logger.isTraceEnabled()) {
                this.this$0.logger.trace("send action [{}] on primary [{}] for request [{}] with cluster state version [{}] to [{}]", (Object)this.this$0.actionName, (Object)((ReplicationRequest)this.request).shardId(), this.request, (Object)state.version(), (Object)primary.currentNodeId());
            }
            TransportReplicationAction.setPhase(this.task, "rerouted");
            this.performAction(node, this.this$0.actionName, false, (TransportRequest)this.request);
        }

        private boolean retryIfUnavailable(ClusterState state, ShardRouting primary) {
            if (primary == null || !primary.active()) {
                this.this$0.logger.trace("primary shard [{}] is not yet active, scheduling a retry: action [{}], request [{}], cluster state version [{}]", (Object)((ReplicationRequest)this.request).shardId(), (Object)this.this$0.actionName, this.request, (Object)state.version());
                this.retryBecauseUnavailable(((ReplicationRequest)this.request).shardId(), "primary shard is not active");
                return true;
            }
            if (!state.nodes().nodeExists(primary.currentNodeId())) {
                this.this$0.logger.trace("primary shard [{}] is assigned to an unknown node [{}], scheduling a retry: action [{}], request [{}], cluster state version [{}]", (Object)((ReplicationRequest)this.request).shardId(), (Object)primary.currentNodeId(), (Object)this.this$0.actionName, this.request, (Object)state.version());
                this.retryBecauseUnavailable(((ReplicationRequest)this.request).shardId(), "primary shard isn't assigned to a known node.");
                return true;
            }
            return false;
        }

        private String concreteIndex(ClusterState state) {
            return this.this$0.resolveIndex() ? this.this$0.indexNameExpressionResolver.concreteSingleIndex(state, (IndicesRequest)this.request).getName() : ((ReplicationRequest)this.request).index();
        }

        private ShardRouting primary(ClusterState state) {
            IndexShardRoutingTable indexShard = state.getRoutingTable().shardRoutingTable(((ReplicationRequest)this.request).shardId());
            return indexShard.primaryShard();
        }

        private boolean handleBlockExceptions(ClusterState state) {
            ClusterBlockException blockException;
            ClusterBlockException blockException2;
            ClusterBlockLevel globalBlockLevel = this.this$0.globalBlockLevel();
            if (globalBlockLevel != null && (blockException2 = state.blocks().globalBlockedException(globalBlockLevel)) != null) {
                this.handleBlockException(blockException2);
                return true;
            }
            ClusterBlockLevel indexBlockLevel = this.this$0.indexBlockLevel();
            if (indexBlockLevel != null && (blockException = state.blocks().indexBlockedException(indexBlockLevel, this.concreteIndex(state))) != null) {
                this.handleBlockException(blockException);
                return true;
            }
            return false;
        }

        private void handleBlockException(ClusterBlockException blockException) {
            if (blockException.retryable()) {
                this.this$0.logger.trace("cluster is blocked, scheduling a retry", (Throwable)blockException);
                this.retry(blockException);
            } else {
                this.finishAsFailed(blockException);
            }
        }

        private void performAction(final DiscoveryNode node, String action, final boolean isPrimaryAction, final TransportRequest requestToPerform) {
            this.this$0.transportService.sendRequest(node, action, requestToPerform, this.this$0.transportOptions, new TransportResponseHandler<Response>(){

                @Override
                public Response newInstance() {
                    return ReroutePhase.this.this$0.newResponseInstance();
                }

                @Override
                public String executor() {
                    return "same";
                }

                @Override
                public void handleResponse(Response response) {
                    ReroutePhase.this.finishOnSuccess(response);
                }

                @Override
                public void handleException(TransportException exp) {
                    try {
                        Throwable cause = exp.unwrapCause();
                        if (cause instanceof ConnectTransportException || cause instanceof NodeClosedException || isPrimaryAction && ReroutePhase.this.this$0.retryPrimaryException(cause)) {
                            ReroutePhase.this.this$0.logger.trace(() -> new ParameterizedMessage("received an error from node [{}] for request [{}], scheduling a retry", (Object)node.getId(), (Object)requestToPerform), (Throwable)exp);
                            ReroutePhase.this.retry(exp);
                        } else {
                            ReroutePhase.this.finishAsFailed(exp);
                        }
                    }
                    catch (Exception e) {
                        e.addSuppressed(exp);
                        ReroutePhase.this.finishWithUnexpectedFailure(e);
                    }
                }
            });
        }

        void retry(Exception failure) {
            assert (failure != null);
            if (this.observer.isTimedOut()) {
                this.finishAsFailed(failure);
                return;
            }
            TransportReplicationAction.setPhase(this.task, "waiting_for_retry");
            ((ReplicationRequest)this.request).onRetry();
            this.observer.waitForNextChange(new ClusterStateObserver.Listener(){

                @Override
                public void onNewClusterState(ClusterState state) {
                    ReroutePhase.this.run();
                }

                @Override
                public void onClusterServiceClose() {
                    ReroutePhase.this.finishAsFailed(new NodeClosedException(ReroutePhase.this.this$0.clusterService.localNode()));
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    ReroutePhase.this.run();
                }
            });
        }

        void finishAsFailed(Exception failure) {
            if (this.finished.compareAndSet(false, true)) {
                TransportReplicationAction.setPhase(this.task, "failed");
                this.this$0.logger.trace(() -> new ParameterizedMessage("operation failed. action [{}], request [{}]", (Object)this.this$0.actionName, this.request), (Throwable)failure);
                this.listener.onFailure(failure);
            } else assert (false) : "finishAsFailed called but operation is already finished";
        }

        void finishWithUnexpectedFailure(Exception failure) {
            this.this$0.logger.warn(() -> new ParameterizedMessage("unexpected error during the primary phase for action [{}], request [{}]", (Object)this.this$0.actionName, this.request), (Throwable)failure);
            if (this.finished.compareAndSet(false, true)) {
                TransportReplicationAction.setPhase(this.task, "failed");
                this.listener.onFailure(failure);
            } else assert (false) : "finishWithUnexpectedFailure called but operation is already finished";
        }

        void finishOnSuccess(Response response) {
            if (this.finished.compareAndSet(false, true)) {
                TransportReplicationAction.setPhase(this.task, "finished");
                if (this.this$0.logger.isTraceEnabled()) {
                    this.this$0.logger.trace("operation succeeded. action [{}],request [{}]", (Object)this.this$0.actionName, this.request);
                }
                this.listener.onResponse(response);
            } else assert (false) : "finishOnSuccess called but operation is already finished";
        }

        void retryBecauseUnavailable(ShardId shardId, String message) {
            this.retry(new UnavailableShardsException(shardId, "{} Timeout: [{}], request: [{}]", message, ((ReplicationRequest)this.request).timeout(), this.request));
        }
    }

    private static final class AsyncReplicaAction
    extends AbstractRunnable
    implements ActionListener<Releasable> {
        private final ReplicaRequest request;
        private final String targetAllocationID;
        private final TransportChannel channel;
        private final IndexShard replica;
        private final ReplicationTask task;
        private final ClusterStateObserver observer;
        final /* synthetic */ TransportReplicationAction this$0;

        AsyncReplicaAction(ReplicaRequest request, String targetAllocationID, TransportChannel channel, ReplicationTask task) {
            this.this$0 = var1_1;
            this.observer = new ClusterStateObserver(this.this$0.clusterService, null, this.this$0.logger, this.this$0.threadPool.getThreadContext());
            this.request = request;
            this.channel = channel;
            this.task = task;
            this.targetAllocationID = targetAllocationID;
            ShardId shardId = ((ReplicationRequest)request).shardId();
            assert (shardId != null) : "request shardId must be set";
            this.replica = ((TransportReplicationAction)var1_1).getIndexShard(shardId);
        }

        @Override
        public void onResponse(Releasable releasable) {
            try {
                ReplicaResult replicaResult = this.this$0.shardOperationOnReplica(this.request, this.replica);
                releasable.close();
                replicaResult.respond(new ResponseListener());
            }
            catch (Exception e) {
                Releasables.closeWhileHandlingException(releasable);
                this.onFailure(e);
            }
        }

        @Override
        public void onFailure(Exception e) {
            if (e instanceof RetryOnReplicaException) {
                this.this$0.logger.trace(() -> new ParameterizedMessage("Retrying operation on replica, action [{}], request [{}]", (Object)this.this$0.transportReplicaAction, this.request), (Throwable)e);
                ((ReplicationRequest)this.request).onRetry();
                this.observer.waitForNextChange(new ClusterStateObserver.Listener(){

                    @Override
                    public void onNewClusterState(ClusterState state) {
                        String extraMessage = "action [" + AsyncReplicaAction.this.this$0.transportReplicaAction + "], request[" + AsyncReplicaAction.this.request + "]";
                        TransportChannelResponseHandler<TransportResponse.Empty> handler = new TransportChannelResponseHandler<TransportResponse.Empty>(AsyncReplicaAction.this.this$0.logger, AsyncReplicaAction.this.channel, extraMessage, () -> TransportResponse.Empty.INSTANCE);
                        AsyncReplicaAction.this.this$0.transportService.sendRequest(AsyncReplicaAction.this.this$0.clusterService.localNode(), AsyncReplicaAction.this.this$0.transportReplicaAction, new ConcreteShardRequest<ReplicationRequest>(AsyncReplicaAction.this.request, AsyncReplicaAction.this.targetAllocationID), handler);
                    }

                    @Override
                    public void onClusterServiceClose() {
                        AsyncReplicaAction.this.responseWithFailure(new NodeClosedException(AsyncReplicaAction.this.this$0.clusterService.localNode()));
                    }

                    @Override
                    public void onTimeout(TimeValue timeout) {
                        throw new AssertionError((Object)"Cannot happen: there is not timeout");
                    }
                });
            } else {
                this.responseWithFailure(e);
            }
        }

        protected void responseWithFailure(Exception e) {
            try {
                TransportReplicationAction.setPhase(this.task, "finished");
                this.channel.sendResponse(e);
            }
            catch (IOException responseException) {
                responseException.addSuppressed(e);
                this.this$0.logger.warn(() -> new ParameterizedMessage("failed to send error message back to client for action [{}]", (Object)this.this$0.transportReplicaAction), (Throwable)responseException);
            }
        }

        @Override
        protected void doRun() throws Exception {
            TransportReplicationAction.setPhase(this.task, "replica");
            String actualAllocationId = this.replica.routingEntry().allocationId().getId();
            if (!actualAllocationId.equals(this.targetAllocationID)) {
                throw new ShardNotFoundException(this.replica.shardId(), "expected aID [{}] but found [{}]", this.targetAllocationID, actualAllocationId);
            }
            this.replica.acquireReplicaOperationLock(((ReplicationRequest)this.request).primaryTerm, this, this.this$0.executor);
        }

        private class ResponseListener
        implements ActionListener<TransportResponse.Empty> {
            private ResponseListener() {
            }

            @Override
            public void onResponse(TransportResponse.Empty response) {
                if (AsyncReplicaAction.this.this$0.logger.isTraceEnabled()) {
                    AsyncReplicaAction.this.this$0.logger.trace("action [{}] completed on shard [{}] for request [{}]", (Object)AsyncReplicaAction.this.this$0.transportReplicaAction, (Object)AsyncReplicaAction.this.request.shardId(), (Object)AsyncReplicaAction.this.request);
                }
                TransportReplicationAction.setPhase(AsyncReplicaAction.this.task, "finished");
                try {
                    AsyncReplicaAction.this.channel.sendResponse(response);
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Exception e) {
                AsyncReplicaAction.this.responseWithFailure(e);
            }
        }
    }

    public static class RetryOnReplicaException
    extends ElasticsearchException {
        public RetryOnReplicaException(ShardId shardId, String msg) {
            super(msg, new Object[0]);
            this.setShard(shardId);
        }

        public RetryOnReplicaException(StreamInput in) throws IOException {
            super(in);
        }
    }

    class ReplicaOperationTransportHandler
    implements TransportRequestHandler<ConcreteShardRequest<ReplicaRequest>> {
        ReplicaOperationTransportHandler() {
        }

        @Override
        public void messageReceived(ConcreteShardRequest<ReplicaRequest> request, TransportChannel channel) throws Exception {
            throw new UnsupportedOperationException("the task parameter is required for this operation");
        }

        @Override
        public void messageReceived(ConcreteShardRequest<ReplicaRequest> requestWithAID, TransportChannel channel, Task task) throws Exception {
            new AsyncReplicaAction(TransportReplicationAction.this, (ReplicationRequest)requestWithAID.request, requestWithAID.targetAllocationID, channel, (ReplicationTask)task).run();
        }
    }

    protected static class ReplicaResult {
        final Exception finalFailure;

        public ReplicaResult(Exception finalFailure) {
            this.finalFailure = finalFailure;
        }

        public ReplicaResult() {
            this(null);
        }

        public void respond(ActionListener<TransportResponse.Empty> listener) {
            if (this.finalFailure == null) {
                listener.onResponse(TransportResponse.Empty.INSTANCE);
            } else {
                listener.onFailure(this.finalFailure);
            }
        }
    }

    protected static class PrimaryResult<ReplicaRequest extends ReplicationRequest<ReplicaRequest>, Response extends ReplicationResponse>
    implements ReplicationOperation.PrimaryResult<ReplicaRequest> {
        final ReplicaRequest replicaRequest;
        public final Response finalResponseIfSuccessful;
        public final Exception finalFailure;

        public PrimaryResult(ReplicaRequest replicaRequest, Response finalResponseIfSuccessful, Exception finalFailure) {
            assert (finalFailure != null ^ finalResponseIfSuccessful != null) : "either a response or a failure has to be not null, found [" + finalFailure + "] failure and [" + finalResponseIfSuccessful + "] response";
            this.replicaRequest = replicaRequest;
            this.finalResponseIfSuccessful = finalResponseIfSuccessful;
            this.finalFailure = finalFailure;
        }

        public PrimaryResult(ReplicaRequest replicaRequest, Response replicationResponse) {
            this(replicaRequest, replicationResponse, null);
        }

        @Override
        public ReplicaRequest replicaRequest() {
            return this.replicaRequest;
        }

        @Override
        public void setShardInfo(ReplicationResponse.ShardInfo shardInfo) {
            if (this.finalResponseIfSuccessful != null) {
                ((ReplicationResponse)this.finalResponseIfSuccessful).setShardInfo(shardInfo);
            }
        }

        public void respond(ActionListener<Response> listener) {
            if (this.finalResponseIfSuccessful != null) {
                listener.onResponse(this.finalResponseIfSuccessful);
            } else {
                listener.onFailure(this.finalFailure);
            }
        }
    }

    static class AsyncPrimaryAction
    extends AbstractRunnable
    implements ActionListener<PrimaryShardReference> {
        private final Request request;
        private final String targetAllocationID;
        private final TransportChannel channel;
        private final ReplicationTask replicationTask;
        final /* synthetic */ TransportReplicationAction this$0;

        AsyncPrimaryAction(Request request, String targetAllocationID, TransportChannel channel, ReplicationTask replicationTask) {
            this.this$0 = this$0;
            this.request = request;
            this.targetAllocationID = targetAllocationID;
            this.channel = channel;
            this.replicationTask = replicationTask;
        }

        @Override
        protected void doRun() throws Exception {
            this.this$0.acquirePrimaryShardReference(((ReplicationRequest)this.request).shardId(), this.targetAllocationID, this);
        }

        @Override
        public void onResponse(PrimaryShardReference primaryShardReference) {
            try {
                if (primaryShardReference.isRelocated()) {
                    primaryShardReference.close();
                    TransportReplicationAction.setPhase(this.replicationTask, "primary_delegation");
                    ShardRouting primary = primaryShardReference.routingEntry();
                    assert (primary.relocating()) : "indexShard is marked as relocated but routing isn't" + primary;
                    DiscoveryNode relocatingNode = this.this$0.clusterService.state().nodes().get(primary.relocatingNodeId());
                    this.this$0.transportService.sendRequest(relocatingNode, this.this$0.transportPrimaryAction, new ConcreteShardRequest(this.request, primary.allocationId().getRelocationId()), this.this$0.transportOptions, new TransportChannelResponseHandler<Response>(this.this$0.logger, this.channel, "rerouting indexing to target primary " + primary, this.this$0::newResponseInstance){

                        @Override
                        public void handleResponse(Response response) {
                            TransportReplicationAction.setPhase(AsyncPrimaryAction.this.replicationTask, "finished");
                            super.handleResponse(response);
                        }

                        @Override
                        public void handleException(TransportException exp) {
                            TransportReplicationAction.setPhase(AsyncPrimaryAction.this.replicationTask, "finished");
                            super.handleException(exp);
                        }
                    });
                } else {
                    TransportReplicationAction.setPhase(this.replicationTask, "primary");
                    IndexMetaData indexMetaData = this.this$0.clusterService.state().getMetaData().index(((ReplicationRequest)this.request).shardId().getIndex());
                    boolean executeOnReplicas = indexMetaData == null || this.this$0.shouldExecuteReplication(indexMetaData);
                    ActionListener listener = this.createResponseListener(primaryShardReference);
                    this.createReplicatedOperation(this.request, ActionListener.wrap(result -> result.respond(listener), listener::onFailure), primaryShardReference, executeOnReplicas).execute();
                }
            }
            catch (Exception e) {
                Releasables.closeWhileHandlingException(primaryShardReference);
                this.onFailure(e);
            }
        }

        @Override
        public void onFailure(Exception e) {
            TransportReplicationAction.setPhase(this.replicationTask, "finished");
            try {
                this.channel.sendResponse(e);
            }
            catch (IOException inner) {
                inner.addSuppressed(e);
                this.this$0.logger.warn("failed to send response", (Throwable)inner);
            }
        }

        private ActionListener<Response> createResponseListener(final PrimaryShardReference primaryShardReference) {
            return new ActionListener<Response>(){

                @Override
                public void onResponse(Response response) {
                    primaryShardReference.close();
                    TransportReplicationAction.setPhase(AsyncPrimaryAction.this.replicationTask, "finished");
                    try {
                        AsyncPrimaryAction.this.channel.sendResponse((TransportResponse)response);
                    }
                    catch (IOException e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Exception e) {
                    primaryShardReference.close();
                    TransportReplicationAction.setPhase(AsyncPrimaryAction.this.replicationTask, "finished");
                    try {
                        AsyncPrimaryAction.this.channel.sendResponse(e);
                    }
                    catch (IOException e1) {
                        AsyncPrimaryAction.this.this$0.logger.warn("failed to send response", (Throwable)e);
                    }
                }
            };
        }

        protected ReplicationOperation<Request, ReplicaRequest, PrimaryResult<ReplicaRequest, Response>> createReplicatedOperation(Request request, ActionListener<PrimaryResult<ReplicaRequest, Response>> listener, PrimaryShardReference primaryShardReference, boolean executeOnReplicas) {
            return new ReplicationOperation(request, primaryShardReference, listener, executeOnReplicas, this.this$0.replicasProxy, this.this$0.clusterService::state, this.this$0.logger, this.this$0.actionName);
        }
    }

    class PrimaryOperationTransportHandler
    implements TransportRequestHandler<ConcreteShardRequest<Request>> {
        PrimaryOperationTransportHandler() {
        }

        @Override
        public void messageReceived(ConcreteShardRequest<Request> request, TransportChannel channel) throws Exception {
            throw new UnsupportedOperationException("the task parameter is required for this operation");
        }

        @Override
        public void messageReceived(ConcreteShardRequest<Request> request, TransportChannel channel, Task task) {
            new AsyncPrimaryAction(TransportReplicationAction.this, (ReplicationRequest)request.request, request.targetAllocationID, channel, (ReplicationTask)task).run();
        }
    }

    class OperationTransportHandler
    implements TransportRequestHandler<Request> {
        OperationTransportHandler() {
        }

        @Override
        public void messageReceived(Request request, final TransportChannel channel, Task task) throws Exception {
            TransportReplicationAction.this.execute(task, request, new ActionListener<Response>(){

                @Override
                public void onResponse(Response result) {
                    try {
                        channel.sendResponse((TransportResponse)result);
                    }
                    catch (Exception e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Exception e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception inner) {
                        inner.addSuppressed(e);
                        TransportReplicationAction.this.logger.warn(() -> new ParameterizedMessage("Failed to send response for {}", (Object)TransportReplicationAction.this.actionName), (Throwable)inner);
                    }
                }
            });
        }

        @Override
        public void messageReceived(Request request, TransportChannel channel) throws Exception {
            throw new UnsupportedOperationException("the task parameter is required for this operation");
        }
    }
}

