/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.script.StoredScriptSource;

public final class ScriptMetaData
implements MetaData.Custom,
Writeable,
ToXContent {
    private static final Logger LOGGER = ESLoggerFactory.getLogger(ScriptMetaData.class);
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(LOGGER);
    public static final String TYPE = "stored_scripts";
    private final Map<String, StoredScriptSource> scripts;

    static ScriptMetaData putStoredScript(ScriptMetaData previous, String id, StoredScriptSource source) {
        Builder builder = new Builder(previous);
        builder.storeScript(id, source);
        return builder.build();
    }

    static ScriptMetaData deleteStoredScript(ScriptMetaData previous, String id, String lang) {
        Builder builder = new Builder(previous);
        builder.deleteScript(id, lang);
        return builder.build();
    }

    public static ScriptMetaData fromXContent(XContentParser parser) throws IOException {
        HashMap<String, StoredScriptSource> scripts = new HashMap<String, StoredScriptSource>();
        String id = null;
        XContentParser.Token token = parser.currentToken();
        if (token == null) {
            token = parser.nextToken();
        }
        if (token != XContentParser.Token.START_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "unexpected token [" + (Object)((Object)token) + "], expected [{]", new Object[0]);
        }
        token = parser.nextToken();
        while (token != XContentParser.Token.END_OBJECT) {
            switch (token) {
                case FIELD_NAME: {
                    id = parser.currentName();
                    break;
                }
                case VALUE_STRING: {
                    if (id == null) {
                        throw new ParsingException(parser.getTokenLocation(), "unexpected token [" + (Object)((Object)token) + "], expected [<id>, <code>, {]", new Object[0]);
                    }
                    int split = id.indexOf(35);
                    if (split == -1) {
                        throw new IllegalArgumentException("illegal stored script id [" + id + "], does not contain lang");
                    }
                    StoredScriptSource source = new StoredScriptSource(id.substring(0, split), parser.text(), Collections.emptyMap());
                    scripts.put(id, source);
                    id = null;
                    break;
                }
                case START_OBJECT: {
                    if (id == null) {
                        throw new ParsingException(parser.getTokenLocation(), "unexpected token [" + (Object)((Object)token) + "], expected [<id>, <code>, {]", new Object[0]);
                    }
                    StoredScriptSource source = StoredScriptSource.fromXContent(parser);
                    scripts.put(id, source);
                    break;
                }
                default: {
                    throw new ParsingException(parser.getTokenLocation(), "unexpected token [" + (Object)((Object)token) + "], expected [<id>, <code>, {]", new Object[0]);
                }
            }
            token = parser.nextToken();
        }
        return new ScriptMetaData(scripts);
    }

    public static NamedDiff<MetaData.Custom> readDiffFrom(StreamInput in) throws IOException {
        return new ScriptMetadataDiff(in);
    }

    ScriptMetaData(Map<String, StoredScriptSource> scripts) {
        this.scripts = Collections.unmodifiableMap(scripts);
    }

    public ScriptMetaData(StreamInput in) throws IOException {
        HashMap<String, StoredScriptSource> scripts = new HashMap<String, StoredScriptSource>();
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            StoredScriptSource source;
            String id = in.readString();
            if (in.getVersion().before(Version.V_5_3_0_UNRELEASED)) {
                int split = id.indexOf(35);
                if (split == -1) {
                    throw new IllegalArgumentException("illegal stored script id [" + id + "], does not contain lang");
                }
                source = new StoredScriptSource(in);
                source = new StoredScriptSource(id.substring(0, split), source.getCode(), Collections.emptyMap());
            } else {
                source = new StoredScriptSource(in);
            }
            scripts.put(id, source);
        }
        this.scripts = Collections.unmodifiableMap(scripts);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(Version.V_5_3_0_UNRELEASED)) {
            out.writeVInt(this.scripts.size());
            for (Map.Entry<String, StoredScriptSource> entry : this.scripts.entrySet()) {
                out.writeString(entry.getKey());
                entry.getValue().writeTo(out);
            }
        } else {
            HashMap<String, StoredScriptSource> filtered = new HashMap<String, StoredScriptSource>();
            for (Map.Entry<String, StoredScriptSource> entry : this.scripts.entrySet()) {
                if (!entry.getKey().contains("#")) continue;
                filtered.put(entry.getKey(), entry.getValue());
            }
            out.writeVInt(filtered.size());
            for (Map.Entry<String, StoredScriptSource> entry : filtered.entrySet()) {
                out.writeString(entry.getKey());
                entry.getValue().writeTo(out);
            }
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        for (Map.Entry<String, StoredScriptSource> entry : this.scripts.entrySet()) {
            builder.field(entry.getKey());
            entry.getValue().toXContent(builder, params);
        }
        return builder;
    }

    @Override
    public Diff<MetaData.Custom> diff(MetaData.Custom before) {
        return new ScriptMetadataDiff((ScriptMetaData)before, this);
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public EnumSet<MetaData.XContentContext> context() {
        return MetaData.ALL_CONTEXTS;
    }

    StoredScriptSource getStoredScript(String id, String lang) {
        if (lang == null) {
            return this.scripts.get(id);
        }
        return this.scripts.get(lang + "#" + id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScriptMetaData that = (ScriptMetaData)o;
        return this.scripts.equals(that.scripts);
    }

    public int hashCode() {
        return this.scripts.hashCode();
    }

    public String toString() {
        return "ScriptMetaData{scripts=" + this.scripts + '}';
    }

    static final class ScriptMetadataDiff
    implements NamedDiff<MetaData.Custom> {
        final Diff<Map<String, StoredScriptSource>> pipelines;

        ScriptMetadataDiff(ScriptMetaData before, ScriptMetaData after) {
            this.pipelines = DiffableUtils.diff(before.scripts, after.scripts, DiffableUtils.getStringKeySerializer());
        }

        ScriptMetadataDiff(StreamInput in) throws IOException {
            this.pipelines = DiffableUtils.readJdkMapDiff(in, DiffableUtils.getStringKeySerializer(), StoredScriptSource::new, StoredScriptSource::readDiffFrom);
        }

        @Override
        public String getWriteableName() {
            return ScriptMetaData.TYPE;
        }

        @Override
        public MetaData.Custom apply(MetaData.Custom part) {
            return new ScriptMetaData(this.pipelines.apply(((ScriptMetaData)part).scripts));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.pipelines.writeTo(out);
        }
    }

    public static final class Builder {
        private final Map<String, StoredScriptSource> scripts;

        public Builder(ScriptMetaData previous) {
            this.scripts = previous == null ? new HashMap<String, StoredScriptSource>() : new HashMap(previous.scripts);
        }

        public Builder storeScript(String id, StoredScriptSource source) {
            StoredScriptSource previous = this.scripts.put(id, source);
            this.scripts.put(source.getLang() + "#" + id, source);
            if (previous != null && !previous.getLang().equals(source.getLang())) {
                DEPRECATION_LOGGER.deprecated("stored script [" + id + "] already exists using a different lang [" + previous.getLang() + "], the new namespace for stored scripts will only use (id) instead of (lang, id)", new Object[0]);
            }
            return this;
        }

        public Builder deleteScript(String id, String lang) {
            StoredScriptSource source = this.scripts.get(id);
            if (lang == null) {
                if (source == null) {
                    throw new ResourceNotFoundException("stored script [" + id + "] does not exist and cannot be deleted", new Object[0]);
                }
                lang = source.getLang();
            }
            if (source != null && lang.equals(source.getLang())) {
                this.scripts.remove(id);
            }
            if ((source = this.scripts.get(lang + "#" + id)) == null) {
                throw new ResourceNotFoundException("stored script [" + id + "] using lang [" + lang + "] does not exist and cannot be deleted", new Object[0]);
            }
            this.scripts.remove(lang + "#" + id);
            return this;
        }

        public ScriptMetaData build() {
            return new ScriptMetaData(this.scripts);
        }
    }
}

