/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.internal.InternalSearchHit;

public class InternalSearchHits
implements SearchHits {
    public static final InternalSearchHit[] EMPTY = new InternalSearchHit[0];
    private InternalSearchHit[] hits;
    public long totalHits;
    private float maxScore;

    public static InternalSearchHits empty() {
        return new InternalSearchHits(EMPTY, 0L, 0.0f);
    }

    InternalSearchHits() {
    }

    public InternalSearchHits(InternalSearchHit[] hits, long totalHits, float maxScore) {
        this.hits = hits;
        this.totalHits = totalHits;
        this.maxScore = maxScore;
    }

    public void shardTarget(SearchShardTarget shardTarget) {
        for (InternalSearchHit hit : this.hits) {
            hit.shard(shardTarget);
        }
    }

    @Override
    public long totalHits() {
        return this.totalHits;
    }

    @Override
    public long getTotalHits() {
        return this.totalHits();
    }

    @Override
    public float maxScore() {
        return this.maxScore;
    }

    @Override
    public float getMaxScore() {
        return this.maxScore();
    }

    @Override
    public SearchHit[] hits() {
        return this.hits;
    }

    @Override
    public SearchHit getAt(int position) {
        return this.hits[position];
    }

    @Override
    public SearchHit[] getHits() {
        return this.hits();
    }

    @Override
    public Iterator<SearchHit> iterator() {
        return Arrays.stream(this.hits()).iterator();
    }

    public InternalSearchHit[] internalHits() {
        return this.hits;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("hits");
        builder.field("total", this.totalHits);
        if (Float.isNaN(this.maxScore)) {
            builder.nullField("max_score");
        } else {
            builder.field("max_score", this.maxScore);
        }
        builder.field("hits");
        builder.startArray();
        for (InternalSearchHit hit : this.hits) {
            hit.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static InternalSearchHits fromXContent(XContentParser parser) throws IOException {
        if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
            parser.nextToken();
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser::getTokenLocation);
        }
        XContentParser.Token token = parser.currentToken();
        String currentFieldName = null;
        ArrayList<InternalSearchHit> hits = new ArrayList<InternalSearchHit>();
        long totalHits = 0L;
        float maxScore = 0.0f;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if ("total".equals(currentFieldName)) {
                    totalHits = parser.longValue();
                    continue;
                }
                if ("max_score".equals(currentFieldName)) {
                    maxScore = parser.floatValue();
                    continue;
                }
                XContentParserUtils.throwUnknownField(currentFieldName, parser.getTokenLocation());
                continue;
            }
            if (token == XContentParser.Token.VALUE_NULL) {
                if ("max_score".equals(currentFieldName)) {
                    maxScore = Float.NaN;
                    continue;
                }
                XContentParserUtils.throwUnknownField(currentFieldName, parser.getTokenLocation());
                continue;
            }
            if (token != XContentParser.Token.START_ARRAY) continue;
            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                hits.add(InternalSearchHit.fromXContent(parser));
            }
        }
        InternalSearchHits internalSearchHits = new InternalSearchHits(hits.toArray(new InternalSearchHit[hits.size()]), totalHits, maxScore);
        return internalSearchHits;
    }

    public static InternalSearchHits readSearchHits(StreamInput in) throws IOException {
        InternalSearchHits hits = new InternalSearchHits();
        hits.readFrom(in);
        return hits;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.totalHits = in.readVLong();
        this.maxScore = in.readFloat();
        int size = in.readVInt();
        if (size == 0) {
            this.hits = EMPTY;
        } else {
            this.hits = new InternalSearchHit[size];
            for (int i = 0; i < this.hits.length; ++i) {
                this.hits[i] = InternalSearchHit.readSearchHit(in);
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.totalHits);
        out.writeFloat(this.maxScore);
        out.writeVInt(this.hits.length);
        if (this.hits.length > 0) {
            for (InternalSearchHit hit : this.hits) {
                hit.writeTo(out);
            }
        }
    }

    static final class Fields {
        static final String HITS = "hits";
        static final String TOTAL = "total";
        static final String MAX_SCORE = "max_score";

        Fields() {
        }
    }
}

