/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.io.IOException;
import java.util.Optional;
import org.elasticsearch.Version;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.search.internal.ShardSearchRequest;

public class ShardSearchLocalRequest
implements ShardSearchRequest {
    private ShardId shardId;
    private int numberOfShards;
    private SearchType searchType;
    private Scroll scroll;
    private String[] types = Strings.EMPTY_ARRAY;
    private AliasFilter aliasFilter;
    private float indexBoost;
    private SearchSourceBuilder source;
    private Boolean requestCache;
    private long nowInMillis;
    private boolean profile;

    ShardSearchLocalRequest() {
    }

    ShardSearchLocalRequest(SearchRequest searchRequest, ShardId shardId, int numberOfShards, AliasFilter aliasFilter, float indexBoost, long nowInMillis) {
        this(shardId, numberOfShards, searchRequest.searchType(), searchRequest.source(), searchRequest.types(), searchRequest.requestCache(), aliasFilter, indexBoost);
        this.scroll = searchRequest.scroll();
        this.nowInMillis = nowInMillis;
    }

    public ShardSearchLocalRequest(ShardId shardId, String[] types, long nowInMillis, AliasFilter aliasFilter) {
        this.types = types;
        this.nowInMillis = nowInMillis;
        this.aliasFilter = aliasFilter;
        this.shardId = shardId;
        this.indexBoost = 1.0f;
    }

    public ShardSearchLocalRequest(ShardId shardId, int numberOfShards, SearchType searchType, SearchSourceBuilder source, String[] types, Boolean requestCache, AliasFilter aliasFilter, float indexBoost) {
        this.shardId = shardId;
        this.numberOfShards = numberOfShards;
        this.searchType = searchType;
        this.source = source;
        this.types = types;
        this.requestCache = requestCache;
        this.aliasFilter = aliasFilter;
        this.indexBoost = indexBoost;
    }

    @Override
    public ShardId shardId() {
        return this.shardId;
    }

    @Override
    public String[] types() {
        return this.types;
    }

    @Override
    public SearchSourceBuilder source() {
        return this.source;
    }

    @Override
    public void source(SearchSourceBuilder source) {
        this.source = source;
    }

    @Override
    public int numberOfShards() {
        return this.numberOfShards;
    }

    @Override
    public SearchType searchType() {
        return this.searchType;
    }

    @Override
    public QueryBuilder filteringAliases() {
        return this.aliasFilter.getQueryBuilder();
    }

    @Override
    public float indexBoost() {
        return this.indexBoost;
    }

    @Override
    public long nowInMillis() {
        return this.nowInMillis;
    }

    @Override
    public Boolean requestCache() {
        return this.requestCache;
    }

    @Override
    public Scroll scroll() {
        return this.scroll;
    }

    @Override
    public void setProfile(boolean profile) {
        this.profile = profile;
    }

    @Override
    public boolean isProfile() {
        return this.profile;
    }

    protected void innerReadFrom(StreamInput in) throws IOException {
        Optional<SearchSourceBuilder.IndexBoost> boost;
        this.shardId = ShardId.readShardId(in);
        this.searchType = SearchType.fromId(in.readByte());
        this.numberOfShards = in.readVInt();
        this.scroll = in.readOptionalWriteable(Scroll::new);
        this.source = in.readOptionalWriteable(SearchSourceBuilder::new);
        this.types = in.readStringArray();
        this.aliasFilter = new AliasFilter(in);
        this.indexBoost = in.getVersion().onOrAfter(Version.V_5_2_0_UNRELEASED) ? in.readFloat() : (this.source != null ? ((boost = this.source.indexBoosts().stream().filter(ib -> ib.getIndex().equals(this.shardId.getIndexName())).findFirst()).isPresent() ? boost.get().getBoost() : 1.0f) : 1.0f);
        this.nowInMillis = in.readVLong();
        this.requestCache = in.readOptionalBoolean();
    }

    protected void innerWriteTo(StreamOutput out, boolean asKey) throws IOException {
        this.shardId.writeTo(out);
        out.writeByte(this.searchType.id());
        if (!asKey) {
            out.writeVInt(this.numberOfShards);
        }
        out.writeOptionalWriteable(this.scroll);
        out.writeOptionalWriteable(this.source);
        out.writeStringArray(this.types);
        this.aliasFilter.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_5_2_0_UNRELEASED)) {
            out.writeFloat(this.indexBoost);
        }
        if (!asKey) {
            out.writeVLong(this.nowInMillis);
        }
        out.writeOptionalBoolean(this.requestCache);
    }

    @Override
    public BytesReference cacheKey() throws IOException {
        BytesStreamOutput out = new BytesStreamOutput();
        this.innerWriteTo(out, true);
        return new BytesArray(out.bytes().toBytesRef(), true);
    }

    @Override
    public void rewrite(QueryShardContext context) throws IOException {
        SearchSourceBuilder source = this.source;
        SearchSourceBuilder rewritten = null;
        this.aliasFilter = this.aliasFilter.rewrite(context);
        while (rewritten != source) {
            source = rewritten = source.rewrite(context);
        }
        this.source = source;
    }
}

