/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.regexp;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.TopLevel;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.regexp.CompilerState;
import org.mozilla.javascript.regexp.NativeRegExpCtor;
import org.mozilla.javascript.regexp.REBackTrackData;
import org.mozilla.javascript.regexp.RECharSet;
import org.mozilla.javascript.regexp.RECompiled;
import org.mozilla.javascript.regexp.REGlobalData;
import org.mozilla.javascript.regexp.RENode;
import org.mozilla.javascript.regexp.REProgState;
import org.mozilla.javascript.regexp.RegExpImpl;
import org.mozilla.javascript.regexp.SubString;

public class NativeRegExp
extends IdScriptableObject
implements Function {
    static final long serialVersionUID = 4965263491464903264L;
    private static final Object REGEXP_TAG = new Object();
    public static final int JSREG_GLOB = 1;
    public static final int JSREG_FOLD = 2;
    public static final int JSREG_MULTILINE = 4;
    public static final int TEST = 0;
    public static final int MATCH = 1;
    public static final int PREFIX = 2;
    private static final boolean debug = false;
    private static final byte REOP_SIMPLE_START = 1;
    private static final byte REOP_EMPTY = 1;
    private static final byte REOP_BOL = 2;
    private static final byte REOP_EOL = 3;
    private static final byte REOP_WBDRY = 4;
    private static final byte REOP_WNONBDRY = 5;
    private static final byte REOP_DOT = 6;
    private static final byte REOP_DIGIT = 7;
    private static final byte REOP_NONDIGIT = 8;
    private static final byte REOP_ALNUM = 9;
    private static final byte REOP_NONALNUM = 10;
    private static final byte REOP_SPACE = 11;
    private static final byte REOP_NONSPACE = 12;
    private static final byte REOP_BACKREF = 13;
    private static final byte REOP_FLAT = 14;
    private static final byte REOP_FLAT1 = 15;
    private static final byte REOP_FLATi = 16;
    private static final byte REOP_FLAT1i = 17;
    private static final byte REOP_UCFLAT1 = 18;
    private static final byte REOP_UCFLAT1i = 19;
    private static final byte REOP_CLASS = 22;
    private static final byte REOP_NCLASS = 23;
    private static final byte REOP_SIMPLE_END = 23;
    private static final byte REOP_QUANT = 25;
    private static final byte REOP_STAR = 26;
    private static final byte REOP_PLUS = 27;
    private static final byte REOP_OPT = 28;
    private static final byte REOP_LPAREN = 29;
    private static final byte REOP_RPAREN = 30;
    private static final byte REOP_ALT = 31;
    private static final byte REOP_JUMP = 32;
    private static final byte REOP_ASSERT = 41;
    private static final byte REOP_ASSERT_NOT = 42;
    private static final byte REOP_ASSERTTEST = 43;
    private static final byte REOP_ASSERTNOTTEST = 44;
    private static final byte REOP_MINIMALSTAR = 45;
    private static final byte REOP_MINIMALPLUS = 46;
    private static final byte REOP_MINIMALOPT = 47;
    private static final byte REOP_MINIMALQUANT = 48;
    private static final byte REOP_ENDCHILD = 49;
    private static final byte REOP_REPEAT = 51;
    private static final byte REOP_MINIMALREPEAT = 52;
    private static final byte REOP_ALTPREREQ = 53;
    private static final byte REOP_ALTPREREQi = 54;
    private static final byte REOP_ALTPREREQ2 = 55;
    private static final byte REOP_END = 57;
    private static final int ANCHOR_BOL = -2;
    private static final int INDEX_LEN = 2;
    private static final int Id_lastIndex = 1;
    private static final int Id_source = 2;
    private static final int Id_global = 3;
    private static final int Id_ignoreCase = 4;
    private static final int Id_multiline = 5;
    private static final int MAX_INSTANCE_ID = 5;
    private static final int Id_compile = 1;
    private static final int Id_toString = 2;
    private static final int Id_toSource = 3;
    private static final int Id_exec = 4;
    private static final int Id_test = 5;
    private static final int Id_prefix = 6;
    private static final int MAX_PROTOTYPE_ID = 6;
    private RECompiled re;
    Object lastIndex = 0.0;
    private int lastIndexAttr = 6;

    public static void init(Context context, Scriptable scriptable, boolean bl) {
        NativeRegExp nativeRegExp = new NativeRegExp();
        nativeRegExp.re = NativeRegExp.compileRE(context, "", null, false);
        nativeRegExp.activatePrototypeMap(6);
        nativeRegExp.setParentScope(scriptable);
        nativeRegExp.setPrototype(NativeRegExp.getObjectPrototype(scriptable));
        NativeRegExpCtor nativeRegExpCtor = new NativeRegExpCtor();
        nativeRegExp.defineProperty("constructor", nativeRegExpCtor, 2);
        ScriptRuntime.setFunctionProtoAndParent(nativeRegExpCtor, scriptable);
        nativeRegExpCtor.setImmunePrototypeProperty(nativeRegExp);
        if (bl) {
            nativeRegExp.sealObject();
            nativeRegExpCtor.sealObject();
        }
        NativeRegExp.defineProperty(scriptable, "RegExp", nativeRegExpCtor, 2);
    }

    NativeRegExp(Scriptable scriptable, RECompiled rECompiled) {
        this.re = rECompiled;
        this.lastIndex = 0.0;
        ScriptRuntime.setBuiltinProtoAndParent(this, scriptable, TopLevel.Builtins.RegExp);
    }

    @Override
    public String getClassName() {
        return "RegExp";
    }

    @Override
    public String getTypeOf() {
        return "object";
    }

    @Override
    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        return this.execSub(context, scriptable, objectArray, 1);
    }

    @Override
    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) {
        return (Scriptable)this.execSub(context, scriptable, objectArray, 1);
    }

    Scriptable compile(Context context, Scriptable scriptable, Object[] objectArray) {
        if (objectArray.length > 0 && objectArray[0] instanceof NativeRegExp) {
            if (objectArray.length > 1 && objectArray[1] != Undefined.instance) {
                throw ScriptRuntime.typeError0("msg.bad.regexp.compile");
            }
            NativeRegExp nativeRegExp = (NativeRegExp)objectArray[0];
            this.re = nativeRegExp.re;
            this.lastIndex = nativeRegExp.lastIndex;
            return this;
        }
        String string = objectArray.length == 0 || objectArray[0] instanceof Undefined ? "" : NativeRegExp.escapeRegExp(objectArray[0]);
        String string2 = objectArray.length > 1 && objectArray[1] != Undefined.instance ? ScriptRuntime.toString(objectArray[1]) : null;
        this.re = NativeRegExp.compileRE(context, string, string2, false);
        this.lastIndex = 0.0;
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('/');
        if (this.re.source.length != 0) {
            stringBuilder.append(this.re.source);
        } else {
            stringBuilder.append("(?:)");
        }
        stringBuilder.append('/');
        if ((this.re.flags & 1) != 0) {
            stringBuilder.append('g');
        }
        if ((this.re.flags & 2) != 0) {
            stringBuilder.append('i');
        }
        if ((this.re.flags & 4) != 0) {
            stringBuilder.append('m');
        }
        return stringBuilder.toString();
    }

    NativeRegExp() {
    }

    private static RegExpImpl getImpl(Context context) {
        return (RegExpImpl)ScriptRuntime.getRegExpProxy(context);
    }

    private static String escapeRegExp(Object object) {
        String string = ScriptRuntime.toString(object);
        StringBuilder stringBuilder = null;
        int n = 0;
        int n2 = string.indexOf(47);
        while (n2 > -1) {
            if (n2 == n || string.charAt(n2 - 1) != '\\') {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder();
                }
                stringBuilder.append(string, n, n2);
                stringBuilder.append("\\/");
                n = n2 + 1;
            }
            n2 = string.indexOf(47, n2 + 1);
        }
        if (stringBuilder != null) {
            stringBuilder.append(string, n, string.length());
            string = stringBuilder.toString();
        }
        return string;
    }

    private Object execSub(Context context, Scriptable scriptable, Object[] objectArray, int n) {
        Object object;
        String string;
        RegExpImpl regExpImpl = NativeRegExp.getImpl(context);
        if (objectArray.length == 0) {
            string = regExpImpl.input;
            if (string == null) {
                string = ScriptRuntime.toString(Undefined.instance);
            }
        } else {
            string = ScriptRuntime.toString(objectArray[0]);
        }
        double d = 0.0;
        if ((this.re.flags & 1) != 0) {
            d = ScriptRuntime.toInteger(this.lastIndex);
        }
        if (d < 0.0 || (double)string.length() < d) {
            this.lastIndex = 0.0;
            object = null;
        } else {
            int[] nArray = new int[]{(int)d};
            object = this.executeRegExp(context, scriptable, regExpImpl, string, nArray, n);
            if ((this.re.flags & 1) != 0) {
                this.lastIndex = object == null || object == Undefined.instance ? 0.0 : (double)nArray[0];
            }
        }
        return object;
    }

    static RECompiled compileRE(Context context, String string, String string2, boolean bl) {
        int n;
        int n2;
        RECompiled rECompiled = new RECompiled(string);
        int n3 = string.length();
        int n4 = 0;
        if (string2 != null) {
            for (int i = 0; i < string2.length(); ++i) {
                n2 = string2.charAt(i);
                n = 0;
                if (n2 == 103) {
                    n = 1;
                } else if (n2 == 105) {
                    n = 2;
                } else if (n2 == 109) {
                    n = 4;
                } else {
                    NativeRegExp.reportError("msg.invalid.re.flag", String.valueOf((char)n2));
                }
                if ((n4 & n) != 0) {
                    NativeRegExp.reportError("msg.invalid.re.flag", String.valueOf((char)n2));
                }
                n4 |= n;
            }
        }
        rECompiled.flags = n4;
        CompilerState compilerState = new CompilerState(context, rECompiled.source, n3, n4);
        if (bl && n3 > 0) {
            compilerState.result = new RENode(14);
            compilerState.result.chr = compilerState.cpbegin[0];
            compilerState.result.length = n3;
            compilerState.result.flatIndex = 0;
            compilerState.progLength += 5;
        } else {
            if (!NativeRegExp.parseDisjunction(compilerState)) {
                return null;
            }
            if (compilerState.maxBackReference > compilerState.parenCount) {
                compilerState = new CompilerState(context, rECompiled.source, n3, n4);
                compilerState.backReferenceLimit = compilerState.parenCount;
                if (!NativeRegExp.parseDisjunction(compilerState)) {
                    return null;
                }
            }
        }
        rECompiled.program = new byte[compilerState.progLength + 1];
        if (compilerState.classCount != 0) {
            rECompiled.classList = new RECharSet[compilerState.classCount];
            rECompiled.classCount = compilerState.classCount;
        }
        n2 = NativeRegExp.emitREBytecode(compilerState, rECompiled, 0, compilerState.result);
        rECompiled.program[n2++] = 57;
        rECompiled.parenCount = compilerState.parenCount;
        switch (rECompiled.program[0]) {
            case 18: 
            case 19: {
                rECompiled.anchorCh = (char)NativeRegExp.getIndex(rECompiled.program, 1);
                break;
            }
            case 15: 
            case 17: {
                rECompiled.anchorCh = (char)(rECompiled.program[1] & 0xFF);
                break;
            }
            case 14: 
            case 16: {
                n = NativeRegExp.getIndex(rECompiled.program, 1);
                rECompiled.anchorCh = rECompiled.source[n];
                break;
            }
            case 2: {
                rECompiled.anchorCh = -2;
                break;
            }
            case 31: {
                RENode rENode = compilerState.result;
                if (rENode.kid.op != 2 || rENode.kid2.op != 2) break;
                rECompiled.anchorCh = -2;
            }
        }
        return rECompiled;
    }

    static boolean isDigit(char c) {
        return '0' <= c && c <= '9';
    }

    private static boolean isWord(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || NativeRegExp.isDigit(c) || c == '_';
    }

    private static boolean isControlLetter(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z';
    }

    private static boolean isLineTerm(char c) {
        return ScriptRuntime.isJSLineTerminator(c);
    }

    private static boolean isREWhiteSpace(int n) {
        return ScriptRuntime.isJSWhitespaceOrLineTerminator(n);
    }

    private static char upcase(char c) {
        if (c < '\u0080') {
            if ('a' <= c && c <= 'z') {
                return (char)(c + -32);
            }
            return c;
        }
        char c2 = Character.toUpperCase(c);
        return c2 < '\u0080' ? c : c2;
    }

    private static char downcase(char c) {
        if (c < '\u0080') {
            if ('A' <= c && c <= 'Z') {
                return (char)(c + 32);
            }
            return c;
        }
        char c2 = Character.toLowerCase(c);
        return c2 < '\u0080' ? c : c2;
    }

    private static int toASCIIHexDigit(int n) {
        if (n < 48) {
            return -1;
        }
        if (n <= 57) {
            return n - 48;
        }
        if (97 <= (n |= 0x20) && n <= 102) {
            return n - 97 + 10;
        }
        return -1;
    }

    private static boolean parseDisjunction(CompilerState compilerState) {
        int n;
        if (!NativeRegExp.parseAlternative(compilerState)) {
            return false;
        }
        char[] cArray = compilerState.cpbegin;
        if ((n = compilerState.cp++) != cArray.length && cArray[n] == '|') {
            RENode rENode = new RENode(31);
            rENode.kid = compilerState.result;
            if (!NativeRegExp.parseDisjunction(compilerState)) {
                return false;
            }
            rENode.kid2 = compilerState.result;
            compilerState.result = rENode;
            if (rENode.kid.op == 14 && rENode.kid2.op == 14) {
                rENode.op = (byte)((compilerState.flags & 2) == 0 ? 53 : 54);
                rENode.chr = rENode.kid.chr;
                rENode.index = rENode.kid2.chr;
                compilerState.progLength += 13;
            } else if (rENode.kid.op == 22 && rENode.kid.index < 256 && rENode.kid2.op == 14 && (compilerState.flags & 2) == 0) {
                rENode.op = (byte)55;
                rENode.chr = rENode.kid2.chr;
                rENode.index = rENode.kid.index;
                compilerState.progLength += 13;
            } else if (rENode.kid.op == 14 && rENode.kid2.op == 22 && rENode.kid2.index < 256 && (compilerState.flags & 2) == 0) {
                rENode.op = (byte)55;
                rENode.chr = rENode.kid.chr;
                rENode.index = rENode.kid2.index;
                compilerState.progLength += 13;
            } else {
                compilerState.progLength += 9;
            }
        }
        return true;
    }

    private static boolean parseAlternative(CompilerState compilerState) {
        RENode rENode = null;
        RENode rENode2 = null;
        char[] cArray = compilerState.cpbegin;
        block0: while (true) {
            if (compilerState.cp == compilerState.cpend || cArray[compilerState.cp] == '|' || compilerState.parenNesting != 0 && cArray[compilerState.cp] == ')') {
                compilerState.result = rENode == null ? new RENode(1) : rENode;
                return true;
            }
            if (!NativeRegExp.parseTerm(compilerState)) {
                return false;
            }
            if (rENode == null) {
                rENode2 = rENode = compilerState.result;
            } else {
                rENode2.next = compilerState.result;
            }
            while (true) {
                if (rENode2.next == null) continue block0;
                rENode2 = rENode2.next;
            }
            break;
        }
    }

    private static boolean calculateBitmapSize(CompilerState compilerState, RENode rENode, char[] cArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        rENode.bmsize = 0;
        rENode.sense = true;
        if (n == n2) {
            return true;
        }
        if (cArray[n] == '^') {
            ++n;
            rENode.sense = false;
        }
        while (n != n2) {
            int n5 = 0;
            int n6 = 2;
            block0 : switch (cArray[n]) {
                case '\\': {
                    int n7 = ++n;
                    ++n;
                    int n8 = cArray[n7];
                    switch (n8) {
                        case 98: {
                            n5 = 8;
                            break block0;
                        }
                        case 102: {
                            n5 = 12;
                            break block0;
                        }
                        case 110: {
                            n5 = 10;
                            break block0;
                        }
                        case 114: {
                            n5 = 13;
                            break block0;
                        }
                        case 116: {
                            n5 = 9;
                            break block0;
                        }
                        case 118: {
                            n5 = 11;
                            break block0;
                        }
                        case 99: {
                            if (n < n2 && NativeRegExp.isControlLetter(cArray[n])) {
                                n5 = (char)(cArray[n++] & 0x1F);
                            } else {
                                --n;
                            }
                            n5 = 92;
                            break block0;
                        }
                        case 117: {
                            n6 += 2;
                        }
                        case 120: {
                            int n9;
                            int n10 = 0;
                            for (n9 = 0; n9 < n6 && n < n2; ++n9) {
                                if ((n10 = Kit.xDigitToInt(n8 = cArray[n++], n10)) >= 0) continue;
                                n -= n9 + 1;
                                n10 = 92;
                                break;
                            }
                            n5 = n10;
                            break block0;
                        }
                        case 100: {
                            if (bl) {
                                NativeRegExp.reportError("msg.bad.range", "");
                                return false;
                            }
                            n5 = 57;
                            break block0;
                        }
                        case 68: 
                        case 83: 
                        case 87: 
                        case 115: 
                        case 119: {
                            if (bl) {
                                NativeRegExp.reportError("msg.bad.range", "");
                                return false;
                            }
                            rENode.bmsize = 65536;
                            return true;
                        }
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: {
                            int n9;
                            int n10 = n8 - 48;
                            n8 = cArray[n];
                            if (48 <= n8 && n8 <= 55) {
                                n10 = 8 * n10 + (n8 - 48);
                                if (48 <= (n8 = cArray[++n]) && n8 <= 55) {
                                    ++n;
                                    n9 = 8 * n10 + (n8 - 48);
                                    if (n9 <= 255) {
                                        n10 = n9;
                                    } else {
                                        --n;
                                    }
                                }
                            }
                            n5 = n10;
                            break block0;
                        }
                    }
                    n5 = n8;
                    break;
                }
                default: {
                    n5 = cArray[n++];
                }
            }
            if (bl) {
                if (n3 > n5) {
                    NativeRegExp.reportError("msg.bad.range", "");
                    return false;
                }
                bl = false;
            } else if (n < n2 - 1 && cArray[n] == '-') {
                ++n;
                bl = true;
                n3 = (char)n5;
                continue;
            }
            if ((compilerState.flags & 2) != 0) {
                char c;
                char c2 = NativeRegExp.upcase((char)n5);
                n5 = c2 >= (c = NativeRegExp.downcase((char)n5)) ? c2 : c;
            }
            if (n5 <= n4) continue;
            n4 = n5;
        }
        rENode.bmsize = n4 + 1;
        return true;
    }

    private static void doFlat(CompilerState compilerState, char c) {
        compilerState.result = new RENode(14);
        compilerState.result.chr = c;
        compilerState.result.length = 1;
        compilerState.result.flatIndex = -1;
        compilerState.progLength += 3;
    }

    private static int getDecimalValue(char c, CompilerState compilerState, int n, String string) {
        boolean bl = false;
        int n2 = compilerState.cp;
        char[] cArray = compilerState.cpbegin;
        int n3 = c - 48;
        while (compilerState.cp != compilerState.cpend && NativeRegExp.isDigit(c = cArray[compilerState.cp])) {
            if (!bl) {
                int n4 = n3 * 10 + (c - 48);
                if (n4 < n) {
                    n3 = n4;
                } else {
                    bl = true;
                    n3 = n;
                }
            }
            ++compilerState.cp;
        }
        if (bl) {
            NativeRegExp.reportError(string, String.valueOf(cArray, n2, compilerState.cp - n2));
        }
        return n3;
    }

    private static boolean parseTerm(CompilerState compilerState) {
        int n;
        char[] cArray = compilerState.cpbegin;
        char c = cArray[compilerState.cp++];
        int n2 = 2;
        int n3 = compilerState.parenCount;
        block0 : switch (c) {
            case '^': {
                compilerState.result = new RENode(2);
                ++compilerState.progLength;
                return true;
            }
            case '$': {
                compilerState.result = new RENode(3);
                ++compilerState.progLength;
                return true;
            }
            case '\\': {
                if (compilerState.cp < compilerState.cpend) {
                    c = cArray[compilerState.cp++];
                    switch (c) {
                        case 'b': {
                            compilerState.result = new RENode(4);
                            ++compilerState.progLength;
                            return true;
                        }
                        case 'B': {
                            compilerState.result = new RENode(5);
                            ++compilerState.progLength;
                            return true;
                        }
                        case '0': {
                            NativeRegExp.reportWarning(compilerState.cx, "msg.bad.backref", "");
                            int n4 = 0;
                            while (n4 < 32 && compilerState.cp < compilerState.cpend && (c = cArray[compilerState.cp]) >= '0' && c <= '7') {
                                ++compilerState.cp;
                                n4 = 8 * n4 + (c - 48);
                            }
                            c = (char)n4;
                            NativeRegExp.doFlat(compilerState, c);
                            break;
                        }
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            int n5 = compilerState.cp - 1;
                            int n6 = NativeRegExp.getDecimalValue(c, compilerState, 65535, "msg.overlarge.backref");
                            if (n6 > compilerState.backReferenceLimit) {
                                NativeRegExp.reportWarning(compilerState.cx, "msg.bad.backref", "");
                            }
                            if (n6 > compilerState.backReferenceLimit) {
                                compilerState.cp = n5;
                                if (c >= '8') {
                                    c = '\\';
                                    NativeRegExp.doFlat(compilerState, c);
                                    break;
                                }
                                ++compilerState.cp;
                                n6 = c - 48;
                                while (n6 < 32 && compilerState.cp < compilerState.cpend && (c = cArray[compilerState.cp]) >= '0' && c <= '7') {
                                    ++compilerState.cp;
                                    n6 = 8 * n6 + (c - 48);
                                }
                                c = (char)n6;
                                NativeRegExp.doFlat(compilerState, c);
                                break;
                            }
                            compilerState.result = new RENode(13);
                            compilerState.result.parenIndex = n6 - 1;
                            compilerState.progLength += 3;
                            if (compilerState.maxBackReference >= n6) break block0;
                            compilerState.maxBackReference = n6;
                            break;
                        }
                        case 'f': {
                            c = '\f';
                            NativeRegExp.doFlat(compilerState, c);
                            break;
                        }
                        case 'n': {
                            c = '\n';
                            NativeRegExp.doFlat(compilerState, c);
                            break;
                        }
                        case 'r': {
                            c = '\r';
                            NativeRegExp.doFlat(compilerState, c);
                            break;
                        }
                        case 't': {
                            c = '\t';
                            NativeRegExp.doFlat(compilerState, c);
                            break;
                        }
                        case 'v': {
                            c = '\u000b';
                            NativeRegExp.doFlat(compilerState, c);
                            break;
                        }
                        case 'c': {
                            if (compilerState.cp < compilerState.cpend && NativeRegExp.isControlLetter(cArray[compilerState.cp])) {
                                c = (char)(cArray[compilerState.cp++] & 0x1F);
                            } else {
                                --compilerState.cp;
                                c = '\\';
                            }
                            NativeRegExp.doFlat(compilerState, c);
                            break;
                        }
                        case 'u': {
                            n2 += 2;
                        }
                        case 'x': {
                            int n7 = 0;
                            for (n = 0; n < n2 && compilerState.cp < compilerState.cpend; ++n) {
                                if ((n7 = Kit.xDigitToInt(c = cArray[compilerState.cp++], n7)) >= 0) continue;
                                compilerState.cp -= n + 2;
                                n7 = cArray[compilerState.cp++];
                                break;
                            }
                            c = (char)n7;
                            NativeRegExp.doFlat(compilerState, c);
                            break;
                        }
                        case 'd': {
                            compilerState.result = new RENode(7);
                            ++compilerState.progLength;
                            break;
                        }
                        case 'D': {
                            compilerState.result = new RENode(8);
                            ++compilerState.progLength;
                            break;
                        }
                        case 's': {
                            compilerState.result = new RENode(11);
                            ++compilerState.progLength;
                            break;
                        }
                        case 'S': {
                            compilerState.result = new RENode(12);
                            ++compilerState.progLength;
                            break;
                        }
                        case 'w': {
                            compilerState.result = new RENode(9);
                            ++compilerState.progLength;
                            break;
                        }
                        case 'W': {
                            compilerState.result = new RENode(10);
                            ++compilerState.progLength;
                            break;
                        }
                        default: {
                            compilerState.result = new RENode(14);
                            compilerState.result.chr = c;
                            compilerState.result.length = 1;
                            compilerState.result.flatIndex = compilerState.cp - 1;
                            compilerState.progLength += 3;
                            break;
                        }
                    }
                    break;
                }
                NativeRegExp.reportError("msg.trail.backslash", "");
                return false;
            }
            case '(': {
                RENode rENode = null;
                int n8 = compilerState.cp;
                if (compilerState.cp + 1 < compilerState.cpend && cArray[compilerState.cp] == '?' && ((c = cArray[compilerState.cp + 1]) == '=' || c == '!' || c == ':')) {
                    compilerState.cp += 2;
                    if (c == '=') {
                        rENode = new RENode(41);
                        compilerState.progLength += 4;
                    } else if (c == '!') {
                        rENode = new RENode(42);
                        compilerState.progLength += 4;
                    }
                } else {
                    rENode = new RENode(29);
                    compilerState.progLength += 6;
                    rENode.parenIndex = compilerState.parenCount++;
                }
                ++compilerState.parenNesting;
                if (!NativeRegExp.parseDisjunction(compilerState)) {
                    return false;
                }
                if (compilerState.cp == compilerState.cpend || cArray[compilerState.cp] != ')') {
                    NativeRegExp.reportError("msg.unterm.paren", "");
                    return false;
                }
                ++compilerState.cp;
                --compilerState.parenNesting;
                if (rENode == null) break;
                rENode.kid = compilerState.result;
                compilerState.result = rENode;
                break;
            }
            case ')': {
                NativeRegExp.reportError("msg.re.unmatched.right.paren", "");
                return false;
            }
            case '[': {
                int n9;
                compilerState.result = new RENode(22);
                compilerState.result.startIndex = n9 = compilerState.cp;
                while (true) {
                    if (compilerState.cp == compilerState.cpend) {
                        NativeRegExp.reportError("msg.unterm.class", "");
                        return false;
                    }
                    if (cArray[compilerState.cp] == '\\') {
                        ++compilerState.cp;
                    } else if (cArray[compilerState.cp] == ']') break;
                    ++compilerState.cp;
                }
                compilerState.result.kidlen = compilerState.cp - n9;
                compilerState.result.index = compilerState.classCount++;
                if (!NativeRegExp.calculateBitmapSize(compilerState, compilerState.result, cArray, n9, compilerState.cp++)) {
                    return false;
                }
                compilerState.progLength += 3;
                break;
            }
            case '.': {
                compilerState.result = new RENode(6);
                ++compilerState.progLength;
                break;
            }
            case '*': 
            case '+': 
            case '?': {
                NativeRegExp.reportError("msg.bad.quant", String.valueOf(cArray[compilerState.cp - 1]));
                return false;
            }
            default: {
                compilerState.result = new RENode(14);
                compilerState.result.chr = c;
                compilerState.result.length = 1;
                compilerState.result.flatIndex = compilerState.cp - 1;
                compilerState.progLength += 3;
            }
        }
        RENode rENode = compilerState.result;
        if (compilerState.cp == compilerState.cpend) {
            return true;
        }
        boolean bl = false;
        switch (cArray[compilerState.cp]) {
            case '+': {
                compilerState.result = new RENode(25);
                compilerState.result.min = 1;
                compilerState.result.max = -1;
                compilerState.progLength += 8;
                bl = true;
                break;
            }
            case '*': {
                compilerState.result = new RENode(25);
                compilerState.result.min = 0;
                compilerState.result.max = -1;
                compilerState.progLength += 8;
                bl = true;
                break;
            }
            case '?': {
                compilerState.result = new RENode(25);
                compilerState.result.min = 0;
                compilerState.result.max = 1;
                compilerState.progLength += 8;
                bl = true;
                break;
            }
            case '{': {
                n = 0;
                int n10 = -1;
                int n11 = compilerState.cp++;
                if (compilerState.cp < cArray.length && NativeRegExp.isDigit(c = cArray[compilerState.cp])) {
                    ++compilerState.cp;
                    n = NativeRegExp.getDecimalValue(c, compilerState, 65535, "msg.overlarge.min");
                    c = cArray[compilerState.cp];
                    if (c == ',') {
                        if (NativeRegExp.isDigit(c = cArray[++compilerState.cp])) {
                            ++compilerState.cp;
                            n10 = NativeRegExp.getDecimalValue(c, compilerState, 65535, "msg.overlarge.max");
                            c = cArray[compilerState.cp];
                            if (n > n10) {
                                NativeRegExp.reportError("msg.max.lt.min", String.valueOf(cArray[compilerState.cp]));
                                return false;
                            }
                        }
                    } else {
                        n10 = n;
                    }
                    if (c == '}') {
                        compilerState.result = new RENode(25);
                        compilerState.result.min = n;
                        compilerState.result.max = n10;
                        compilerState.progLength += 12;
                        bl = true;
                    }
                }
                if (bl) break;
                compilerState.cp = n11;
                break;
            }
        }
        if (!bl) {
            return true;
        }
        ++compilerState.cp;
        compilerState.result.kid = rENode;
        compilerState.result.parenIndex = n3;
        compilerState.result.parenCount = compilerState.parenCount - n3;
        if (compilerState.cp < compilerState.cpend && cArray[compilerState.cp] == '?') {
            ++compilerState.cp;
            compilerState.result.greedy = false;
        } else {
            compilerState.result.greedy = true;
        }
        return true;
    }

    private static void resolveForwardJump(byte[] byArray, int n, int n2) {
        if (n > n2) {
            throw Kit.codeBug();
        }
        NativeRegExp.addIndex(byArray, n, n2 - n);
    }

    private static int getOffset(byte[] byArray, int n) {
        return NativeRegExp.getIndex(byArray, n);
    }

    private static int addIndex(byte[] byArray, int n, int n2) {
        if (n2 < 0) {
            throw Kit.codeBug();
        }
        if (n2 > 65535) {
            throw Context.reportRuntimeError("Too complex regexp");
        }
        byArray[n] = (byte)(n2 >> 8);
        byArray[n + 1] = (byte)n2;
        return n + 2;
    }

    private static int getIndex(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
    }

    private static int emitREBytecode(CompilerState compilerState, RECompiled rECompiled, int n, RENode rENode) {
        byte[] byArray = rECompiled.program;
        while (rENode != null) {
            byArray[n++] = rENode.op;
            switch (rENode.op) {
                case 1: {
                    --n;
                    break;
                }
                case 53: 
                case 54: 
                case 55: {
                    boolean bl = rENode.op == 54;
                    NativeRegExp.addIndex(byArray, n, bl ? NativeRegExp.upcase(rENode.chr) : rENode.chr);
                    NativeRegExp.addIndex(byArray, n += 2, bl ? (int)NativeRegExp.upcase((char)rENode.index) : rENode.index);
                    n += 2;
                }
                case 31: {
                    RENode rENode2 = rENode.kid2;
                    int n2 = n;
                    n += 2;
                    n = NativeRegExp.emitREBytecode(compilerState, rECompiled, n, rENode.kid);
                    byArray[n++] = 32;
                    int n3 = n;
                    NativeRegExp.resolveForwardJump(byArray, n2, n += 2);
                    n = NativeRegExp.emitREBytecode(compilerState, rECompiled, n, rENode2);
                    byArray[n++] = 32;
                    n2 = n;
                    NativeRegExp.resolveForwardJump(byArray, n3, n += 2);
                    NativeRegExp.resolveForwardJump(byArray, n2, n);
                    break;
                }
                case 14: {
                    if (rENode.flatIndex != -1) {
                        while (rENode.next != null && rENode.next.op == 14 && rENode.flatIndex + rENode.length == rENode.next.flatIndex) {
                            rENode.length += rENode.next.length;
                            rENode.next = rENode.next.next;
                        }
                    }
                    if (rENode.flatIndex != -1 && rENode.length > 1) {
                        byArray[n - 1] = (compilerState.flags & 2) != 0 ? 16 : 14;
                        n = NativeRegExp.addIndex(byArray, n, rENode.flatIndex);
                        n = NativeRegExp.addIndex(byArray, n, rENode.length);
                        break;
                    }
                    if (rENode.chr < '\u0100') {
                        byArray[n - 1] = (compilerState.flags & 2) != 0 ? 17 : 15;
                        byArray[n++] = (byte)rENode.chr;
                        break;
                    }
                    byArray[n - 1] = (compilerState.flags & 2) != 0 ? 19 : 18;
                    n = NativeRegExp.addIndex(byArray, n, rENode.chr);
                    break;
                }
                case 29: {
                    n = NativeRegExp.addIndex(byArray, n, rENode.parenIndex);
                    n = NativeRegExp.emitREBytecode(compilerState, rECompiled, n, rENode.kid);
                    byArray[n++] = 30;
                    n = NativeRegExp.addIndex(byArray, n, rENode.parenIndex);
                    break;
                }
                case 13: {
                    n = NativeRegExp.addIndex(byArray, n, rENode.parenIndex);
                    break;
                }
                case 41: {
                    int n3 = n;
                    n += 2;
                    n = NativeRegExp.emitREBytecode(compilerState, rECompiled, n, rENode.kid);
                    byArray[n++] = 43;
                    NativeRegExp.resolveForwardJump(byArray, n3, n);
                    break;
                }
                case 42: {
                    int n3 = n;
                    n += 2;
                    n = NativeRegExp.emitREBytecode(compilerState, rECompiled, n, rENode.kid);
                    byArray[n++] = 44;
                    NativeRegExp.resolveForwardJump(byArray, n3, n);
                    break;
                }
                case 25: {
                    if (rENode.min == 0 && rENode.max == -1) {
                        byArray[n - 1] = rENode.greedy ? 26 : 45;
                    } else if (rENode.min == 0 && rENode.max == 1) {
                        byArray[n - 1] = rENode.greedy ? 28 : 47;
                    } else if (rENode.min == 1 && rENode.max == -1) {
                        byArray[n - 1] = rENode.greedy ? 27 : 46;
                    } else {
                        if (!rENode.greedy) {
                            byArray[n - 1] = 48;
                        }
                        n = NativeRegExp.addIndex(byArray, n, rENode.min);
                        n = NativeRegExp.addIndex(byArray, n, rENode.max + 1);
                    }
                    n = NativeRegExp.addIndex(byArray, n, rENode.parenCount);
                    int n3 = n = NativeRegExp.addIndex(byArray, n, rENode.parenIndex);
                    n += 2;
                    n = NativeRegExp.emitREBytecode(compilerState, rECompiled, n, rENode.kid);
                    byArray[n++] = 49;
                    NativeRegExp.resolveForwardJump(byArray, n3, n);
                    break;
                }
                case 22: {
                    if (!rENode.sense) {
                        byArray[n - 1] = 23;
                    }
                    n = NativeRegExp.addIndex(byArray, n, rENode.index);
                    rECompiled.classList[rENode.index] = new RECharSet(rENode.bmsize, rENode.startIndex, rENode.kidlen, rENode.sense);
                    break;
                }
            }
            rENode = rENode.next;
        }
        return n;
    }

    private static void pushProgState(REGlobalData rEGlobalData, int n, int n2, int n3, REBackTrackData rEBackTrackData, int n4, int n5) {
        rEGlobalData.stateStackTop = new REProgState(rEGlobalData.stateStackTop, n, n2, n3, rEBackTrackData, n4, n5);
    }

    private static REProgState popProgState(REGlobalData rEGlobalData) {
        REProgState rEProgState = rEGlobalData.stateStackTop;
        rEGlobalData.stateStackTop = rEProgState.previous;
        return rEProgState;
    }

    private static void pushBackTrackState(REGlobalData rEGlobalData, byte by, int n) {
        REProgState rEProgState = rEGlobalData.stateStackTop;
        rEGlobalData.backTrackStackTop = new REBackTrackData(rEGlobalData, by, n, rEGlobalData.cp, rEProgState.continuationOp, rEProgState.continuationPc);
    }

    private static void pushBackTrackState(REGlobalData rEGlobalData, byte by, int n, int n2, int n3, int n4) {
        rEGlobalData.backTrackStackTop = new REBackTrackData(rEGlobalData, by, n, n2, n3, n4);
    }

    private static boolean flatNMatcher(REGlobalData rEGlobalData, int n, int n2, String string, int n3) {
        if (rEGlobalData.cp + n2 > n3) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (rEGlobalData.regexp.source[n + i] == string.charAt(rEGlobalData.cp + i)) continue;
            return false;
        }
        rEGlobalData.cp += n2;
        return true;
    }

    private static boolean flatNIMatcher(REGlobalData rEGlobalData, int n, int n2, String string, int n3) {
        if (rEGlobalData.cp + n2 > n3) {
            return false;
        }
        char[] cArray = rEGlobalData.regexp.source;
        for (int i = 0; i < n2; ++i) {
            char c = cArray[n + i];
            char c2 = string.charAt(rEGlobalData.cp + i);
            if (c == c2 || NativeRegExp.upcase(c) == NativeRegExp.upcase(c2)) continue;
            return false;
        }
        rEGlobalData.cp += n2;
        return true;
    }

    private static boolean backrefMatcher(REGlobalData rEGlobalData, int n, String string, int n2) {
        if (rEGlobalData.parens == null || n >= rEGlobalData.parens.length) {
            return false;
        }
        int n3 = rEGlobalData.parensIndex(n);
        if (n3 == -1) {
            return true;
        }
        int n4 = rEGlobalData.parensLength(n);
        if (rEGlobalData.cp + n4 > n2) {
            return false;
        }
        if ((rEGlobalData.regexp.flags & 2) != 0) {
            for (int i = 0; i < n4; ++i) {
                char c;
                char c2 = string.charAt(n3 + i);
                if (c2 == (c = string.charAt(rEGlobalData.cp + i)) || NativeRegExp.upcase(c2) == NativeRegExp.upcase(c)) continue;
                return false;
            }
        } else if (!string.regionMatches(n3, string, rEGlobalData.cp, n4)) {
            return false;
        }
        rEGlobalData.cp += n4;
        return true;
    }

    private static void addCharacterToCharSet(RECharSet rECharSet, char c) {
        int n = c / 8;
        if (c >= rECharSet.length) {
            throw ScriptRuntime.constructError("SyntaxError", "invalid range in character class");
        }
        int n2 = n;
        rECharSet.bits[n2] = (byte)(rECharSet.bits[n2] | 1 << (c & 7));
    }

    private static void addCharacterRangeToCharSet(RECharSet rECharSet, char c, char c2) {
        int n = c / 8;
        int n2 = c2 / 8;
        if (c2 >= rECharSet.length || c > c2) {
            throw ScriptRuntime.constructError("SyntaxError", "invalid range in character class");
        }
        c = (char)(c & 7);
        c2 = (char)(c2 & 7);
        if (n == n2) {
            int n3 = n;
            rECharSet.bits[n3] = (byte)(rECharSet.bits[n3] | 255 >> 7 - (c2 - c) << c);
        } else {
            int n4 = n;
            rECharSet.bits[n4] = (byte)(rECharSet.bits[n4] | 255 << c);
            for (int i = n + 1; i < n2; ++i) {
                rECharSet.bits[i] = -1;
            }
            int n5 = n2;
            rECharSet.bits[n5] = (byte)(rECharSet.bits[n5] | 255 >> 7 - c2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processCharSet(REGlobalData rEGlobalData, RECharSet rECharSet) {
        RECharSet rECharSet2 = rECharSet;
        synchronized (rECharSet2) {
            if (!rECharSet.converted) {
                NativeRegExp.processCharSetImpl(rEGlobalData, rECharSet);
                rECharSet.converted = true;
            }
        }
    }

    private static void processCharSetImpl(REGlobalData rEGlobalData, RECharSet rECharSet) {
        int n = rECharSet.startIndex;
        int n2 = n + rECharSet.strlength;
        char c = '\u0000';
        boolean bl = false;
        int n3 = (rECharSet.length + 7) / 8;
        rECharSet.bits = new byte[n3];
        if (n == n2) {
            return;
        }
        if (rEGlobalData.regexp.source[n] == '^') {
            assert (!rECharSet.sense);
            ++n;
        } else assert (rECharSet.sense);
        block21: while (n != n2) {
            char c2;
            char c3;
            char c4;
            int n4 = 2;
            block0 : switch (rEGlobalData.regexp.source[n]) {
                case '\\': {
                    int n5 = ++n;
                    ++n;
                    c4 = rEGlobalData.regexp.source[n5];
                    switch (c4) {
                        case 'b': {
                            c3 = '\b';
                            break block0;
                        }
                        case 'f': {
                            c3 = '\f';
                            break block0;
                        }
                        case 'n': {
                            c3 = '\n';
                            break block0;
                        }
                        case 'r': {
                            c3 = '\r';
                            break block0;
                        }
                        case 't': {
                            c3 = '\t';
                            break block0;
                        }
                        case 'v': {
                            c3 = '\u000b';
                            break block0;
                        }
                        case 'c': {
                            if (n < n2 && NativeRegExp.isControlLetter(rEGlobalData.regexp.source[n])) {
                                c3 = (char)(rEGlobalData.regexp.source[n++] & 0x1F);
                                break block0;
                            }
                            --n;
                            c3 = '\\';
                            break block0;
                        }
                        case 'u': {
                            n4 += 2;
                        }
                        case 'x': {
                            int n6;
                            int n7 = 0;
                            for (n6 = 0; n6 < n4 && n < n2; ++n6) {
                                if ((c2 = NativeRegExp.toASCIIHexDigit(c4 = rEGlobalData.regexp.source[n++])) < '\u0000') {
                                    n -= n6 + 1;
                                    n7 = 92;
                                    break;
                                }
                                n7 = n7 << 4 | c2;
                            }
                            c3 = (char)n7;
                            break block0;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': {
                            int n6;
                            int n7 = c4 - 48;
                            c4 = rEGlobalData.regexp.source[n];
                            if ('0' <= c4 && c4 <= '7') {
                                n7 = 8 * n7 + (c4 - 48);
                                if ('0' <= (c4 = rEGlobalData.regexp.source[++n]) && c4 <= '7') {
                                    ++n;
                                    n6 = 8 * n7 + (c4 - 48);
                                    if (n6 <= 255) {
                                        n7 = n6;
                                    } else {
                                        --n;
                                    }
                                }
                            }
                            c3 = (char)n7;
                            break block0;
                        }
                        case 'd': {
                            NativeRegExp.addCharacterRangeToCharSet(rECharSet, '0', '9');
                            continue block21;
                        }
                        case 'D': {
                            NativeRegExp.addCharacterRangeToCharSet(rECharSet, '\u0000', '/');
                            NativeRegExp.addCharacterRangeToCharSet(rECharSet, ':', (char)(rECharSet.length - 1));
                            continue block21;
                        }
                        case 's': {
                            int n6;
                            for (n6 = rECharSet.length - 1; n6 >= 0; --n6) {
                                if (!NativeRegExp.isREWhiteSpace(n6)) continue;
                                NativeRegExp.addCharacterToCharSet(rECharSet, (char)n6);
                            }
                            continue block21;
                        }
                        case 'S': {
                            int n6;
                            for (n6 = rECharSet.length - 1; n6 >= 0; --n6) {
                                if (NativeRegExp.isREWhiteSpace(n6)) continue;
                                NativeRegExp.addCharacterToCharSet(rECharSet, (char)n6);
                            }
                            continue block21;
                        }
                        case 'w': {
                            int n6;
                            for (n6 = rECharSet.length - 1; n6 >= 0; --n6) {
                                if (!NativeRegExp.isWord((char)n6)) continue;
                                NativeRegExp.addCharacterToCharSet(rECharSet, (char)n6);
                            }
                            continue block21;
                        }
                        case 'W': {
                            int n6;
                            for (n6 = rECharSet.length - 1; n6 >= 0; --n6) {
                                if (NativeRegExp.isWord((char)n6)) continue;
                                NativeRegExp.addCharacterToCharSet(rECharSet, (char)n6);
                            }
                            continue block21;
                        }
                    }
                    c3 = c4;
                    break;
                }
                default: {
                    c3 = rEGlobalData.regexp.source[n++];
                }
            }
            if (bl) {
                if ((rEGlobalData.regexp.flags & 2) != 0) {
                    assert (c <= c3);
                    c4 = c;
                    while (c4 <= c3) {
                        NativeRegExp.addCharacterToCharSet(rECharSet, c4);
                        c2 = NativeRegExp.upcase(c4);
                        char c5 = NativeRegExp.downcase(c4);
                        if (c4 != c2) {
                            NativeRegExp.addCharacterToCharSet(rECharSet, c2);
                        }
                        if (c4 != c5) {
                            NativeRegExp.addCharacterToCharSet(rECharSet, c5);
                        }
                        if ((c4 = (char)(c4 + '\u0001')) != '\u0000') continue;
                        break;
                    }
                } else {
                    NativeRegExp.addCharacterRangeToCharSet(rECharSet, c, c3);
                }
                bl = false;
                continue;
            }
            if ((rEGlobalData.regexp.flags & 2) != 0) {
                NativeRegExp.addCharacterToCharSet(rECharSet, NativeRegExp.upcase(c3));
                NativeRegExp.addCharacterToCharSet(rECharSet, NativeRegExp.downcase(c3));
            } else {
                NativeRegExp.addCharacterToCharSet(rECharSet, c3);
            }
            if (n >= n2 - 1 || rEGlobalData.regexp.source[n] != '-') continue;
            ++n;
            bl = true;
            c = c3;
        }
    }

    private static boolean classMatcher(REGlobalData rEGlobalData, RECharSet rECharSet, char c) {
        if (!rECharSet.converted) {
            NativeRegExp.processCharSet(rEGlobalData, rECharSet);
        }
        int n = c >> 3;
        return (rECharSet.length == 0 || c >= rECharSet.length || (rECharSet.bits[n] & 1 << (c & 7)) == 0) ^ rECharSet.sense;
    }

    private static boolean reopIsSimple(int n) {
        return n >= 1 && n <= 23;
    }

    private static int simpleMatch(REGlobalData rEGlobalData, String string, int n, byte[] byArray, int n2, int n3, boolean bl) {
        boolean bl2 = false;
        int n4 = rEGlobalData.cp;
        switch (n) {
            case 1: {
                bl2 = true;
                break;
            }
            case 2: {
                if (rEGlobalData.cp != 0 && (!rEGlobalData.multiline || !NativeRegExp.isLineTerm(string.charAt(rEGlobalData.cp - 1)))) break;
                bl2 = true;
                break;
            }
            case 3: {
                if (rEGlobalData.cp != n3 && (!rEGlobalData.multiline || !NativeRegExp.isLineTerm(string.charAt(rEGlobalData.cp)))) break;
                bl2 = true;
                break;
            }
            case 4: {
                bl2 = (rEGlobalData.cp == 0 || !NativeRegExp.isWord(string.charAt(rEGlobalData.cp - 1))) ^ (rEGlobalData.cp >= n3 || !NativeRegExp.isWord(string.charAt(rEGlobalData.cp)));
                break;
            }
            case 5: {
                bl2 = (rEGlobalData.cp == 0 || !NativeRegExp.isWord(string.charAt(rEGlobalData.cp - 1))) ^ (rEGlobalData.cp < n3 && NativeRegExp.isWord(string.charAt(rEGlobalData.cp)));
                break;
            }
            case 6: {
                if (rEGlobalData.cp == n3 || NativeRegExp.isLineTerm(string.charAt(rEGlobalData.cp))) break;
                bl2 = true;
                ++rEGlobalData.cp;
                break;
            }
            case 7: {
                if (rEGlobalData.cp == n3 || !NativeRegExp.isDigit(string.charAt(rEGlobalData.cp))) break;
                bl2 = true;
                ++rEGlobalData.cp;
                break;
            }
            case 8: {
                if (rEGlobalData.cp == n3 || NativeRegExp.isDigit(string.charAt(rEGlobalData.cp))) break;
                bl2 = true;
                ++rEGlobalData.cp;
                break;
            }
            case 9: {
                if (rEGlobalData.cp == n3 || !NativeRegExp.isWord(string.charAt(rEGlobalData.cp))) break;
                bl2 = true;
                ++rEGlobalData.cp;
                break;
            }
            case 10: {
                if (rEGlobalData.cp == n3 || NativeRegExp.isWord(string.charAt(rEGlobalData.cp))) break;
                bl2 = true;
                ++rEGlobalData.cp;
                break;
            }
            case 11: {
                if (rEGlobalData.cp == n3 || !NativeRegExp.isREWhiteSpace(string.charAt(rEGlobalData.cp))) break;
                bl2 = true;
                ++rEGlobalData.cp;
                break;
            }
            case 12: {
                if (rEGlobalData.cp == n3 || NativeRegExp.isREWhiteSpace(string.charAt(rEGlobalData.cp))) break;
                bl2 = true;
                ++rEGlobalData.cp;
                break;
            }
            case 13: {
                int n5 = NativeRegExp.getIndex(byArray, n2);
                n2 += 2;
                bl2 = NativeRegExp.backrefMatcher(rEGlobalData, n5, string, n3);
                break;
            }
            case 14: {
                int n6 = NativeRegExp.getIndex(byArray, n2);
                int n7 = NativeRegExp.getIndex(byArray, n2 += 2);
                n2 += 2;
                bl2 = NativeRegExp.flatNMatcher(rEGlobalData, n6, n7, string, n3);
                break;
            }
            case 15: {
                char c = (char)(byArray[n2++] & 0xFF);
                if (rEGlobalData.cp == n3 || string.charAt(rEGlobalData.cp) != c) break;
                bl2 = true;
                ++rEGlobalData.cp;
                break;
            }
            case 16: {
                int n8 = NativeRegExp.getIndex(byArray, n2);
                int n9 = NativeRegExp.getIndex(byArray, n2 += 2);
                n2 += 2;
                bl2 = NativeRegExp.flatNIMatcher(rEGlobalData, n8, n9, string, n3);
                break;
            }
            case 17: {
                char c;
                char c2 = (char)(byArray[n2++] & 0xFF);
                if (rEGlobalData.cp == n3 || c2 != (c = string.charAt(rEGlobalData.cp)) && NativeRegExp.upcase(c2) != NativeRegExp.upcase(c)) break;
                bl2 = true;
                ++rEGlobalData.cp;
                break;
            }
            case 18: {
                char c = (char)NativeRegExp.getIndex(byArray, n2);
                n2 += 2;
                if (rEGlobalData.cp == n3 || string.charAt(rEGlobalData.cp) != c) break;
                bl2 = true;
                ++rEGlobalData.cp;
                break;
            }
            case 19: {
                char c;
                char c3 = (char)NativeRegExp.getIndex(byArray, n2);
                n2 += 2;
                if (rEGlobalData.cp == n3 || c3 != (c = string.charAt(rEGlobalData.cp)) && NativeRegExp.upcase(c3) != NativeRegExp.upcase(c)) break;
                bl2 = true;
                ++rEGlobalData.cp;
                break;
            }
            case 22: 
            case 23: {
                int n10 = NativeRegExp.getIndex(byArray, n2);
                n2 += 2;
                if (rEGlobalData.cp == n3 || !NativeRegExp.classMatcher(rEGlobalData, rEGlobalData.regexp.classList[n10], string.charAt(rEGlobalData.cp))) break;
                ++rEGlobalData.cp;
                bl2 = true;
                break;
            }
            default: {
                throw Kit.codeBug();
            }
        }
        if (bl2) {
            if (!bl) {
                rEGlobalData.cp = n4;
            }
            return n2;
        }
        rEGlobalData.cp = n4;
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean executeREBytecode(REGlobalData var0, String var1_1, int var2_2) {
        var3_3 = 0;
        var4_4 = var0.regexp.program;
        var5_5 = 57;
        var6_6 = 0;
        var7_7 = false;
        var8_8 = var4_4[var3_3++];
        if (var0.regexp.anchorCh < 0 && NativeRegExp.reopIsSimple(var8_8)) {
            var9_9 = 0;
            while (var0.cp <= var2_2) {
                var10_13 = NativeRegExp.simpleMatch(var0, var1_1, var8_8, var4_4, var3_3, var2_2, true);
                if (var10_13 >= 0) {
                    var9_9 = 1;
                    var3_3 = var10_13;
                    var8_8 = var4_4[var3_3++];
                    break;
                }
                ++var0.skipped;
                ++var0.cp;
            }
            if (var9_9 == 0) {
                return false;
            }
        }
        block26: while (true) {
            block62: {
                block61: {
                    if (!NativeRegExp.reopIsSimple(var8_8)) break block61;
                    var9_9 = NativeRegExp.simpleMatch(var0, var1_1, var8_8, var4_4, var3_3, var2_2, true);
                    v0 = var7_7 = var9_9 >= 0;
                    if (var7_7) {
                        var3_3 = var9_9;
                    }
                    break block62;
                }
                block0 : switch (var8_8) {
                    case 53: 
                    case 54: 
                    case 55: {
                        var9_9 = (char)NativeRegExp.getIndex(var4_4, var3_3);
                        var10_13 = (char)NativeRegExp.getIndex(var4_4, var3_3 += 2);
                        var3_3 += 2;
                        if (var0.cp == var2_2) {
                            var7_7 = false;
                            break;
                        }
                        var11_14 = var1_1.charAt(var0.cp);
                        if (var8_8 != 55) ** GOTO lbl43
                        if (var11_14 != var9_9 && !NativeRegExp.classMatcher(var0, var0.regexp.classList[var10_13], (char)var11_14)) {
                            var7_7 = false;
                            break;
                        }
                        ** GOTO lbl48
lbl43:
                        // 1 sources

                        if (var8_8 == 54) {
                            var11_14 = NativeRegExp.upcase((char)var11_14);
                        }
                        if (var11_14 != var9_9 && var11_14 != var10_13) {
                            var7_7 = false;
                            break;
                        }
                    }
lbl48:
                    // 4 sources

                    case 31: {
                        var9_9 = var3_3 + NativeRegExp.getOffset(var4_4, var3_3);
                        var3_3 += 2;
                        var8_8 = var4_4[var3_3++];
                        var10_13 = var0.cp;
                        if (NativeRegExp.reopIsSimple(var8_8)) {
                            var11_14 = NativeRegExp.simpleMatch(var0, var1_1, var8_8, var4_4, var3_3, var2_2, true);
                            if (var11_14 < 0) {
                                var8_8 = var4_4[var9_9++];
                                var3_3 = var9_9;
                                continue block26;
                            }
                            var7_7 = true;
                            var3_3 = var11_14;
                            var8_8 = var4_4[var3_3++];
                        }
                        var11_14 = var4_4[var9_9++];
                        NativeRegExp.pushBackTrackState(var0, (byte)var11_14, var9_9, var10_13, var5_5, var6_6);
                        continue block26;
                    }
                    case 32: {
                        var9_9 = NativeRegExp.getOffset(var4_4, var3_3);
                        var3_3 += var9_9;
                        var8_8 = var4_4[var3_3++];
                        continue block26;
                    }
                    case 29: {
                        var9_9 = NativeRegExp.getIndex(var4_4, var3_3);
                        var3_3 += 2;
                        var0.setParens(var9_9, var0.cp, 0);
                        var8_8 = var4_4[var3_3++];
                        continue block26;
                    }
                    case 30: {
                        var9_9 = NativeRegExp.getIndex(var4_4, var3_3);
                        var3_3 += 2;
                        var10_13 = var0.parensIndex(var9_9);
                        var0.setParens(var9_9, var10_13, var0.cp - var10_13);
                        var8_8 = var4_4[var3_3++];
                        continue block26;
                    }
                    case 41: {
                        var9_9 = var3_3 + NativeRegExp.getIndex(var4_4, var3_3);
                        var3_3 += 2;
                        var8_8 = var4_4[var3_3++];
                        if (NativeRegExp.reopIsSimple(var8_8) && NativeRegExp.simpleMatch(var0, var1_1, var8_8, var4_4, var3_3, var2_2, false) < 0) {
                            var7_7 = false;
                            break;
                        }
                        NativeRegExp.pushProgState(var0, 0, 0, var0.cp, var0.backTrackStackTop, var5_5, var6_6);
                        NativeRegExp.pushBackTrackState(var0, (byte)43, var9_9);
                        continue block26;
                    }
                    case 42: {
                        var9_9 = var3_3 + NativeRegExp.getIndex(var4_4, var3_3);
                        var3_3 += 2;
                        var8_8 = var4_4[var3_3++];
                        if (NativeRegExp.reopIsSimple(var8_8) && (var10_13 = NativeRegExp.simpleMatch(var0, var1_1, var8_8, var4_4, var3_3, var2_2, false)) >= 0 && var4_4[var10_13] == 44) {
                            var7_7 = false;
                            break;
                        }
                        NativeRegExp.pushProgState(var0, 0, 0, var0.cp, var0.backTrackStackTop, var5_5, var6_6);
                        NativeRegExp.pushBackTrackState(var0, (byte)44, var9_9);
                        continue block26;
                    }
                    case 43: 
                    case 44: {
                        var9_10 = NativeRegExp.popProgState(var0);
                        var0.cp = var9_10.index;
                        var0.backTrackStackTop = var9_10.backTrack;
                        var6_6 = var9_10.continuationPc;
                        var5_5 = var9_10.continuationOp;
                        if (var8_8 != 44) break;
                        var7_7 = var7_7 == false;
                        break;
                    }
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: {
                        var11_15 = false;
                        switch (var8_8) {
                            case 26: {
                                var11_15 = true;
                            }
                            case 45: {
                                var9_9 = 0;
                                var10_13 = -1;
                                break;
                            }
                            case 27: {
                                var11_15 = true;
                            }
                            case 46: {
                                var9_9 = 1;
                                var10_13 = -1;
                                break;
                            }
                            case 28: {
                                var11_15 = true;
                            }
                            case 47: {
                                var9_9 = 0;
                                var10_13 = 1;
                                break;
                            }
                            case 25: {
                                var11_15 = true;
                            }
                            case 48: {
                                var9_9 = NativeRegExp.getOffset(var4_4, var3_3);
                                var10_13 = NativeRegExp.getOffset(var4_4, var3_3 += 2) - 1;
                                var3_3 += 2;
                                break;
                            }
                            default: {
                                throw Kit.codeBug();
                            }
                        }
                        NativeRegExp.pushProgState(var0, var9_9, var10_13, var0.cp, null, var5_5, var6_6);
                        if (var11_15) {
                            NativeRegExp.pushBackTrackState(var0, (byte)51, var3_3);
                            var5_5 = 51;
                            var6_6 = var3_3;
                            var3_3 += 6;
                            var8_8 = var4_4[var3_3++];
                            continue block26;
                        }
                        if (var9_9 != 0) {
                            var5_5 = 52;
                            var6_6 = var3_3;
                            var3_3 += 6;
                            var8_8 = var4_4[var3_3++];
                            continue block26;
                        }
                        NativeRegExp.pushBackTrackState(var0, (byte)52, var3_3);
                        NativeRegExp.popProgState(var0);
                        var3_3 += 4;
                        var3_3 += NativeRegExp.getOffset(var4_4, var3_3);
                        var8_8 = var4_4[var3_3++];
                        continue block26;
                    }
                    case 49: {
                        var7_7 = true;
                        var3_3 = var6_6;
                        var8_8 = var5_5;
                        continue block26;
                    }
                    case 51: {
                        do {
                            var11_16 = NativeRegExp.popProgState(var0);
                            if (!var7_7) {
                                if (var11_16.min == 0) {
                                    var7_7 = true;
                                }
                                var6_6 = var11_16.continuationPc;
                                var5_5 = var11_16.continuationOp;
                                var3_3 += 4;
                                var3_3 += NativeRegExp.getOffset(var4_4, var3_3);
                                break block0;
                            }
                            if (var11_16.min == 0 && var0.cp == var11_16.index) {
                                var7_7 = false;
                                var6_6 = var11_16.continuationPc;
                                var5_5 = var11_16.continuationOp;
                                var3_3 += 4;
                                var3_3 += NativeRegExp.getOffset(var4_4, var3_3);
                                break block0;
                            }
                            var12_19 = var11_16.min;
                            var13_20 = var11_16.max;
                            if (var12_19 != 0) {
                                --var12_19;
                            }
                            if (var13_20 != -1) {
                                --var13_20;
                            }
                            if (var13_20 == 0) {
                                var7_7 = true;
                                var6_6 = var11_16.continuationPc;
                                var5_5 = var11_16.continuationOp;
                                var3_3 += 4;
                                var3_3 += NativeRegExp.getOffset(var4_4, var3_3);
                                break block0;
                            }
                            var9_9 = var3_3 + 6;
                            var10_13 = var4_4[var9_9];
                            var14_21 = var0.cp;
                            if (NativeRegExp.reopIsSimple(var10_13)) {
                                if ((var15_22 = NativeRegExp.simpleMatch(var0, var1_1, var10_13, var4_4, ++var9_9, var2_2, true)) < 0) {
                                    var7_7 = var12_19 == 0;
                                    var6_6 = var11_16.continuationPc;
                                    var5_5 = var11_16.continuationOp;
                                    var3_3 += 4;
                                    var3_3 += NativeRegExp.getOffset(var4_4, var3_3);
                                    break block0;
                                }
                                var7_7 = true;
                                var9_9 = var15_22;
                            }
                            var5_5 = 51;
                            var6_6 = var3_3;
                            NativeRegExp.pushProgState(var0, var12_19, var13_20, var14_21, null, var11_16.continuationOp, var11_16.continuationPc);
                            if (var12_19 != 0) continue;
                            NativeRegExp.pushBackTrackState(var0, (byte)51, var3_3, var14_21, var11_16.continuationOp, var11_16.continuationPc);
                            var15_22 = NativeRegExp.getIndex(var4_4, var3_3);
                            var16_23 = NativeRegExp.getIndex(var4_4, var3_3 + 2);
                            for (var17_24 = 0; var17_24 < var15_22; ++var17_24) {
                                var0.setParens(var16_23 + var17_24, -1, 0);
                            }
                        } while (var4_4[var9_9] == 49);
                        var3_3 = var9_9;
                        var8_8 = var4_4[var3_3++];
                        continue block26;
                    }
                    case 52: {
                        var9_11 = NativeRegExp.popProgState(var0);
                        if (!var7_7) {
                            if (var9_11.max == -1 || var9_11.max > 0) {
                                NativeRegExp.pushProgState(var0, var9_11.min, var9_11.max, var0.cp, null, var9_11.continuationOp, var9_11.continuationPc);
                                var5_5 = 52;
                                var6_6 = var3_3;
                                var10_13 = NativeRegExp.getIndex(var4_4, var3_3);
                                var11_17 = NativeRegExp.getIndex(var4_4, var3_3 += 2);
                                var3_3 += 4;
                                for (var12_19 = 0; var12_19 < var10_13; ++var12_19) {
                                    var0.setParens(var11_17 + var12_19, -1, 0);
                                }
                                var8_8 = var4_4[var3_3++];
                                continue block26;
                            }
                            var6_6 = var9_11.continuationPc;
                            var5_5 = var9_11.continuationOp;
                            break;
                        }
                        if (var9_11.min == 0 && var0.cp == var9_11.index) {
                            var7_7 = false;
                            var6_6 = var9_11.continuationPc;
                            var5_5 = var9_11.continuationOp;
                            break;
                        }
                        var10_13 = var9_11.min;
                        var11_18 = var9_11.max;
                        if (var10_13 != 0) {
                            --var10_13;
                        }
                        if (var11_18 != -1) {
                            --var11_18;
                        }
                        NativeRegExp.pushProgState(var0, var10_13, var11_18, var0.cp, null, var9_11.continuationOp, var9_11.continuationPc);
                        if (var10_13 != 0) {
                            var5_5 = 52;
                            var6_6 = var3_3;
                            var12_19 = NativeRegExp.getIndex(var4_4, var3_3);
                            var13_20 = NativeRegExp.getIndex(var4_4, var3_3 += 2);
                            var3_3 += 4;
                            for (var14_21 = 0; var14_21 < var12_19; ++var14_21) {
                                var0.setParens(var13_20 + var14_21, -1, 0);
                            }
                            var8_8 = var4_4[var3_3++];
                            continue block26;
                        }
                        var6_6 = var9_11.continuationPc;
                        var5_5 = var9_11.continuationOp;
                        NativeRegExp.pushBackTrackState(var0, (byte)52, var3_3);
                        NativeRegExp.popProgState(var0);
                        var3_3 += 4;
                        var3_3 += NativeRegExp.getOffset(var4_4, var3_3);
                        var8_8 = var4_4[var3_3++];
                        continue block26;
                    }
                    case 57: {
                        return true;
                    }
                    default: {
                        throw Kit.codeBug("invalid bytecode");
                    }
                }
            }
            if (!var7_7) {
                var9_12 = var0.backTrackStackTop;
                if (var9_12 != null) {
                    var0.backTrackStackTop = var9_12.previous;
                    var0.parens = var9_12.parens;
                    var0.cp = var9_12.cp;
                    var0.stateStackTop = var9_12.stateStackTop;
                    var5_5 = var9_12.continuationOp;
                    var6_6 = var9_12.continuationPc;
                    var3_3 = var9_12.pc;
                    var8_8 = var9_12.op;
                    continue;
                }
                return false;
            }
            var8_8 = var4_4[var3_3++];
        }
    }

    private static boolean matchRegExp(REGlobalData rEGlobalData, RECompiled rECompiled, String string, int n, int n2, boolean bl) {
        rEGlobalData.parens = (long[])(rECompiled.parenCount != 0 ? new long[rECompiled.parenCount] : null);
        rEGlobalData.backTrackStackTop = null;
        rEGlobalData.stateStackTop = null;
        rEGlobalData.multiline = bl || (rECompiled.flags & 4) != 0;
        rEGlobalData.regexp = rECompiled;
        int n3 = rEGlobalData.regexp.anchorCh;
        for (int i = n; i <= n2; ++i) {
            int n4;
            if (n3 >= 0) {
                while (true) {
                    if (i == n2) {
                        return false;
                    }
                    n4 = string.charAt(i);
                    if (n4 == n3 || (rEGlobalData.regexp.flags & 2) != 0 && NativeRegExp.upcase((char)n4) == NativeRegExp.upcase((char)n3)) break;
                    ++i;
                }
            }
            rEGlobalData.cp = i;
            rEGlobalData.skipped = i - n;
            for (n4 = 0; n4 < rECompiled.parenCount; ++n4) {
                rEGlobalData.parens[n4] = -1L;
            }
            n4 = NativeRegExp.executeREBytecode(rEGlobalData, string, n2) ? 1 : 0;
            rEGlobalData.backTrackStackTop = null;
            rEGlobalData.stateStackTop = null;
            if (n4 != 0) {
                return true;
            }
            if (n3 == -2 && !rEGlobalData.multiline) {
                rEGlobalData.skipped = n2;
                return false;
            }
            i = n + rEGlobalData.skipped;
        }
        return false;
    }

    Object executeRegExp(Context context, Scriptable scriptable, RegExpImpl regExpImpl, String string, int[] nArray, int n) {
        Object object;
        Scriptable scriptable2;
        Object object2;
        int n2;
        boolean bl;
        REGlobalData rEGlobalData = new REGlobalData();
        int n3 = nArray[0];
        int n4 = string.length();
        if (n3 > n4) {
            n3 = n4;
        }
        if (!(bl = NativeRegExp.matchRegExp(rEGlobalData, this.re, string, n3, n4, regExpImpl.multiline))) {
            if (n != 2) {
                return null;
            }
            return Undefined.instance;
        }
        int n5 = nArray[0] = (n2 = rEGlobalData.cp);
        int n6 = n5 - (n3 + rEGlobalData.skipped);
        n2 -= n6;
        if (n == 0) {
            object2 = Boolean.TRUE;
            scriptable2 = null;
        } else {
            object2 = context.newArray(scriptable, 0);
            scriptable2 = (Scriptable)object2;
            object = string.substring(n2, n2 + n6);
            scriptable2.put(0, scriptable2, object);
        }
        if (this.re.parenCount == 0) {
            regExpImpl.parens = null;
            regExpImpl.lastParen = SubString.emptySubString;
        } else {
            object = null;
            regExpImpl.parens = new SubString[this.re.parenCount];
            for (int i = 0; i < this.re.parenCount; ++i) {
                int n7 = rEGlobalData.parensIndex(i);
                if (n7 != -1) {
                    int n8 = rEGlobalData.parensLength(i);
                    regExpImpl.parens[i] = object = new SubString(string, n7, n8);
                    if (n == 0) continue;
                    scriptable2.put(i + 1, scriptable2, (Object)((SubString)object).toString());
                    continue;
                }
                if (n == 0) continue;
                scriptable2.put(i + 1, scriptable2, Undefined.instance);
            }
            regExpImpl.lastParen = object;
        }
        if (n != 0) {
            scriptable2.put("index", scriptable2, (Object)(n3 + rEGlobalData.skipped));
            scriptable2.put("input", scriptable2, (Object)string);
        }
        if (regExpImpl.lastMatch == null) {
            regExpImpl.lastMatch = new SubString();
            regExpImpl.leftContext = new SubString();
            regExpImpl.rightContext = new SubString();
        }
        regExpImpl.lastMatch.str = string;
        regExpImpl.lastMatch.index = n2;
        regExpImpl.lastMatch.length = n6;
        regExpImpl.leftContext.str = string;
        if (context.getLanguageVersion() == 120) {
            regExpImpl.leftContext.index = n3;
            regExpImpl.leftContext.length = rEGlobalData.skipped;
        } else {
            regExpImpl.leftContext.index = 0;
            regExpImpl.leftContext.length = n3 + rEGlobalData.skipped;
        }
        regExpImpl.rightContext.str = string;
        regExpImpl.rightContext.index = n5;
        regExpImpl.rightContext.length = n4 - n5;
        return object2;
    }

    int getFlags() {
        return this.re.flags;
    }

    private static void reportWarning(Context context, String string, String string2) {
        if (context.hasFeature(11)) {
            String string3 = ScriptRuntime.getMessage1(string, string2);
            Context.reportWarning(string3);
        }
    }

    private static void reportError(String string, String string2) {
        String string3 = ScriptRuntime.getMessage1(string, string2);
        throw ScriptRuntime.constructError("SyntaxError", string3);
    }

    @Override
    protected int getMaxInstanceId() {
        return 5;
    }

    @Override
    protected int findInstanceIdInfo(String string) {
        int n;
        int n2 = 0;
        String string2 = null;
        int n3 = string.length();
        if (n3 == 6) {
            char c = string.charAt(0);
            if (c == 'g') {
                string2 = "global";
                n2 = 3;
            } else if (c == 's') {
                string2 = "source";
                n2 = 2;
            }
        } else if (n3 == 9) {
            char c = string.charAt(0);
            if (c == 'l') {
                string2 = "lastIndex";
                n2 = 1;
            } else if (c == 'm') {
                string2 = "multiline";
                n2 = 5;
            }
        } else if (n3 == 10) {
            string2 = "ignoreCase";
            n2 = 4;
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n2 = 0;
        }
        if (n2 == 0) {
            return super.findInstanceIdInfo(string);
        }
        switch (n2) {
            case 1: {
                n = this.lastIndexAttr;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n = 7;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return NativeRegExp.instanceIdInfo(n, n2);
    }

    @Override
    protected String getInstanceIdName(int n) {
        switch (n) {
            case 1: {
                return "lastIndex";
            }
            case 2: {
                return "source";
            }
            case 3: {
                return "global";
            }
            case 4: {
                return "ignoreCase";
            }
            case 5: {
                return "multiline";
            }
        }
        return super.getInstanceIdName(n);
    }

    @Override
    protected Object getInstanceIdValue(int n) {
        switch (n) {
            case 1: {
                return this.lastIndex;
            }
            case 2: {
                return new String(this.re.source);
            }
            case 3: {
                return ScriptRuntime.wrapBoolean((this.re.flags & 1) != 0);
            }
            case 4: {
                return ScriptRuntime.wrapBoolean((this.re.flags & 2) != 0);
            }
            case 5: {
                return ScriptRuntime.wrapBoolean((this.re.flags & 4) != 0);
            }
        }
        return super.getInstanceIdValue(n);
    }

    @Override
    protected void setInstanceIdValue(int n, Object object) {
        switch (n) {
            case 1: {
                this.lastIndex = object;
                return;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return;
            }
        }
        super.setInstanceIdValue(n, object);
    }

    @Override
    protected void setInstanceIdAttributes(int n, int n2) {
        switch (n) {
            case 1: {
                this.lastIndexAttr = n2;
                return;
            }
        }
        super.setInstanceIdAttributes(n, n2);
    }

    @Override
    protected void initPrototypeId(int n) {
        String string;
        int n2;
        switch (n) {
            case 1: {
                n2 = 2;
                string = "compile";
                break;
            }
            case 2: {
                n2 = 0;
                string = "toString";
                break;
            }
            case 3: {
                n2 = 0;
                string = "toSource";
                break;
            }
            case 4: {
                n2 = 1;
                string = "exec";
                break;
            }
            case 5: {
                n2 = 1;
                string = "test";
                break;
            }
            case 6: {
                n2 = 1;
                string = "prefix";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod(REGEXP_TAG, n, string, n2);
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(REGEXP_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        switch (n) {
            case 1: {
                return NativeRegExp.realThis(scriptable2, idFunctionObject).compile(context, scriptable, objectArray);
            }
            case 2: 
            case 3: {
                return NativeRegExp.realThis(scriptable2, idFunctionObject).toString();
            }
            case 4: {
                return NativeRegExp.realThis(scriptable2, idFunctionObject).execSub(context, scriptable, objectArray, 1);
            }
            case 5: {
                Object object = NativeRegExp.realThis(scriptable2, idFunctionObject).execSub(context, scriptable, objectArray, 0);
                return Boolean.TRUE.equals(object) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 6: {
                return NativeRegExp.realThis(scriptable2, idFunctionObject).execSub(context, scriptable, objectArray, 2);
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    private static NativeRegExp realThis(Scriptable scriptable, IdFunctionObject idFunctionObject) {
        if (!(scriptable instanceof NativeRegExp)) {
            throw NativeRegExp.incompatibleCallError(idFunctionObject);
        }
        return (NativeRegExp)scriptable;
    }

    @Override
    protected int findPrototypeId(String string) {
        int n;
        block8: {
            n = 0;
            String string2 = null;
            switch (string.length()) {
                case 4: {
                    char c = string.charAt(0);
                    if (c == 'e') {
                        string2 = "exec";
                        n = 4;
                        break;
                    }
                    if (c != 't') break;
                    string2 = "test";
                    n = 5;
                    break;
                }
                case 6: {
                    string2 = "prefix";
                    n = 6;
                    break;
                }
                case 7: {
                    string2 = "compile";
                    n = 1;
                    break;
                }
                case 8: {
                    char c = string.charAt(3);
                    if (c == 'o') {
                        string2 = "toSource";
                        n = 3;
                        break;
                    }
                    if (c != 't') break;
                    string2 = "toString";
                    n = 2;
                    break;
                }
            }
            if (string2 == null || string2 == string || string2.equals(string)) break block8;
            n = 0;
        }
        return n;
    }
}

