/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.filelock;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.gradle.cache.internal.FileLock;
import org.gradle.cache.internal.filelock.LockState;
import org.gradle.cache.internal.filelock.LockStateSerializer;

public class Version1LockStateSerializer
implements LockStateSerializer {
    public int getSize() {
        return 1;
    }

    public byte getVersion() {
        return 1;
    }

    public LockState createInitialState() {
        return new DirtyFlagLockState(true);
    }

    public void write(DataOutput dataOutput, LockState lockState) throws IOException {
        DirtyFlagLockState state = (DirtyFlagLockState)lockState;
        dataOutput.writeBoolean(!state.dirty);
    }

    public LockState read(DataInput dataInput) throws IOException {
        return new DirtyFlagLockState(!dataInput.readBoolean());
    }

    private static class DirtyFlagLockState
    implements LockState {
        private final boolean dirty;

        private DirtyFlagLockState(boolean dirty) {
            this.dirty = dirty;
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public boolean canDetectChanges() {
            return false;
        }

        public boolean isInInitialState() {
            return false;
        }

        public LockState beforeUpdate() {
            return new DirtyFlagLockState(true);
        }

        public LockState completeUpdate() {
            return new DirtyFlagLockState(false);
        }

        public boolean hasBeenUpdatedSince(FileLock.State state) {
            throw new UnsupportedOperationException("This protocol version does not support detecting changes by other processes.");
        }
    }
}

