/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.CallableReferenceUtilKt;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.DelegatingResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

public class FunctionReferenceGenerationStrategy
extends FunctionGenerationStrategy.CodegenBased {
    private final ResolvedCall<?> resolvedCall;
    private final FunctionDescriptor referencedFunction;
    private final FunctionDescriptor functionDescriptor;
    private final Type receiverType;
    private final StackValue receiverValue;

    public FunctionReferenceGenerationStrategy(@NotNull GenerationState state2, @NotNull FunctionDescriptor functionDescriptor, @NotNull ResolvedCall<?> resolvedCall2, @Nullable Type receiverType, @Nullable StackValue receiverValue) {
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/FunctionReferenceGenerationStrategy", "<init>"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/codegen/FunctionReferenceGenerationStrategy", "<init>"));
        }
        if (resolvedCall2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/codegen/FunctionReferenceGenerationStrategy", "<init>"));
        }
        super(state2);
        this.resolvedCall = resolvedCall2;
        this.referencedFunction = (FunctionDescriptor)resolvedCall2.getResultingDescriptor();
        this.functionDescriptor = functionDescriptor;
        this.receiverType = receiverType;
        this.receiverValue = receiverValue;
        assert (receiverType != null || receiverValue == null) : "A receiver value is provided for unbound function reference. Either this is a bound reference and you forgot to pass receiverType, or you accidentally passed some receiverValue for a reference without receiver";
    }

    @Override
    public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature2) {
        StackValue result2;
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/FunctionReferenceGenerationStrategy", "doGenerateBody"));
        }
        if (signature2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/kotlin/codegen/FunctionReferenceGenerationStrategy", "doGenerateBody"));
        }
        KtCallExpression fakeExpression = this.constructFakeFunctionCall();
        final List<KtValueArgument> fakeArguments = fakeExpression.getValueArguments();
        final ReceiverValue dispatchReceiver = this.computeAndSaveReceiver(signature2, codegen, this.referencedFunction.getDispatchReceiverParameter());
        final ReceiverValue extensionReceiver2 = this.computeAndSaveReceiver(signature2, codegen, this.referencedFunction.getExtensionReceiverParameter());
        this.computeAndSaveArguments(fakeArguments, codegen);
        DelegatingResolvedCall<CallableDescriptor> fakeResolvedCall = new DelegatingResolvedCall<CallableDescriptor>(this.resolvedCall){
            private final Map<ValueParameterDescriptor, ResolvedValueArgument> argumentMap;
            {
                super(x0);
                this.argumentMap = new LinkedHashMap<ValueParameterDescriptor, ResolvedValueArgument>(fakeArguments.size());
                int index2 = 0;
                List<ValueParameterDescriptor> parameters2 = FunctionReferenceGenerationStrategy.this.functionDescriptor.getValueParameters();
                for (ValueArgument argument : fakeArguments) {
                    this.argumentMap.put(parameters2.get(index2), new ExpressionValueArgument(argument));
                    ++index2;
                }
            }

            @Override
            @Nullable
            public ReceiverValue getExtensionReceiver() {
                return extensionReceiver2;
            }

            @Override
            @Nullable
            public ReceiverValue getDispatchReceiver() {
                return dispatchReceiver;
            }

            @Override
            @NotNull
            public List<ResolvedValueArgument> getValueArgumentsByIndex() {
                ArrayList<ResolvedValueArgument> arrayList = new ArrayList<ResolvedValueArgument>(this.argumentMap.values());
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/FunctionReferenceGenerationStrategy$1", "getValueArgumentsByIndex"));
                }
                return arrayList;
            }

            @Override
            @NotNull
            public Map<ValueParameterDescriptor, ResolvedValueArgument> getValueArguments() {
                Map<ValueParameterDescriptor, ResolvedValueArgument> map2 = this.argumentMap;
                if (map2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/FunctionReferenceGenerationStrategy$1", "getValueArguments"));
                }
                return map2;
            }
        };
        Type returnType = codegen.getReturnType();
        if (this.referencedFunction instanceof ConstructorDescriptor) {
            result2 = returnType.getSort() == 9 ? codegen.generateNewArray(fakeExpression, this.referencedFunction.getReturnType(), fakeResolvedCall) : codegen.generateConstructorCall(fakeResolvedCall, returnType);
        } else {
            Call call = CallMaker.makeCall(fakeExpression, null, null, fakeExpression, fakeArguments);
            result2 = codegen.invokeFunction(call, fakeResolvedCall, StackValue.none());
        }
        InstructionAdapter v = codegen.v;
        result2.put(returnType, v);
        v.areturn(returnType);
    }

    @NotNull
    private KtCallExpression constructFakeFunctionCall() {
        StringBuilder fakeFunctionCall = new StringBuilder("callableReferenceFakeCall(");
        Iterator<ValueParameterDescriptor> iterator2 = this.referencedFunction.getValueParameters().iterator();
        while (iterator2.hasNext()) {
            ValueParameterDescriptor descriptor2 = iterator2.next();
            fakeFunctionCall.append("p").append(descriptor2.getIndex());
            if (!iterator2.hasNext()) continue;
            fakeFunctionCall.append(", ");
        }
        fakeFunctionCall.append(")");
        KtCallExpression ktCallExpression = (KtCallExpression)KtPsiFactoryKt.KtPsiFactory(this.state.getProject()).createExpression(fakeFunctionCall.toString());
        if (ktCallExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/FunctionReferenceGenerationStrategy", "constructFakeFunctionCall"));
        }
        return ktCallExpression;
    }

    private void computeAndSaveArguments(@NotNull List<? extends ValueArgument> fakeArguments, @NotNull ExpressionCodegen codegen) {
        if (fakeArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fakeArguments", "org/jetbrains/kotlin/codegen/FunctionReferenceGenerationStrategy", "computeAndSaveArguments"));
        }
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/FunctionReferenceGenerationStrategy", "computeAndSaveArguments"));
        }
        int receivers = (this.referencedFunction.getDispatchReceiverParameter() != null ? 1 : 0) + (this.referencedFunction.getExtensionReceiverParameter() != null ? 1 : 0) - (this.receiverType != null ? 1 : 0);
        List<ValueParameterDescriptor> parameters2 = CollectionsKt.drop(this.functionDescriptor.getValueParameters(), receivers);
        for (int i = 0; i < parameters2.size(); ++i) {
            ValueParameterDescriptor parameter = parameters2.get(i);
            ValueArgument fakeArgument = fakeArguments.get(i);
            Type type2 = this.state.getTypeMapper().mapType(parameter);
            int localIndex = codegen.myFrameMap.getIndex(parameter);
            codegen.tempVariables.put(fakeArgument.getArgumentExpression(), StackValue.local(localIndex, type2));
        }
    }

    @Nullable
    private ReceiverValue computeAndSaveReceiver(@NotNull JvmMethodSignature signature2, @NotNull ExpressionCodegen codegen, @Nullable ReceiverParameterDescriptor receiver) {
        if (signature2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/kotlin/codegen/FunctionReferenceGenerationStrategy", "computeAndSaveReceiver"));
        }
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/FunctionReferenceGenerationStrategy", "computeAndSaveReceiver"));
        }
        if (receiver == null) {
            return null;
        }
        KtExpression receiverExpression = KtPsiFactoryKt.KtPsiFactory(this.state.getProject()).createExpression("callableReferenceFakeReceiver");
        codegen.tempVariables.put(receiverExpression, this.receiverParameterStackValue(signature2, codegen));
        return ExpressionReceiver.Companion.create(receiverExpression, receiver.getType(), BindingContext.EMPTY);
    }

    @NotNull
    private StackValue receiverParameterStackValue(@NotNull JvmMethodSignature signature2, @NotNull ExpressionCodegen codegen) {
        if (signature2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/kotlin/codegen/FunctionReferenceGenerationStrategy", "receiverParameterStackValue"));
        }
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/FunctionReferenceGenerationStrategy", "receiverParameterStackValue"));
        }
        if (this.receiverValue != null) {
            StackValue stackValue = this.receiverValue;
            if (stackValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/FunctionReferenceGenerationStrategy", "receiverParameterStackValue"));
            }
            return stackValue;
        }
        if (this.receiverType != null) {
            ClassDescriptor classDescriptor = (ClassDescriptor)codegen.getContext().getParentContext().getContextDescriptor();
            Type asmType = codegen.getState().getTypeMapper().mapClass(classDescriptor);
            StackValue.Field field = CallableReferenceUtilKt.capturedReceiver(asmType, this.receiverType);
            if (field == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/FunctionReferenceGenerationStrategy", "receiverParameterStackValue"));
            }
            return field;
        }
        StackValue.Local local = StackValue.local(1, signature2.getAsmMethod().getArgumentTypes()[0]);
        if (local == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/FunctionReferenceGenerationStrategy", "receiverParameterStackValue"));
        }
        return local;
    }
}

