/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.fixStack;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.optimization.fixStack.SavedStackDescriptor;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.InsnNode;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.VarInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.Value;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=2, d1={"\u0000H\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001e\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u0016\u0010\r\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0005\u001a\u0016\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0005\u001a,\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u0014\u001a\u001e\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a.\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0012\u001a&\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001c\u001a)\u0010\u001d\u001a\u0004\u0018\u0001H\u001e\"\b\b\u0000\u0010\u001e*\u00020\u001f*\b\u0012\u0004\u0012\u0002H\u001e0\u00142\u0006\u0010 \u001a\u00020\u0012\u00a2\u0006\u0002\u0010!\u001a!\u0010\u000b\u001a\u0004\u0018\u0001H\u001e\"\b\b\u0000\u0010\u001e*\u00020\u001f*\b\u0012\u0004\u0012\u0002H\u001e0\u0014\u00a2\u0006\u0002\u0010\"\u00a8\u0006#"}, d2={"generateLoadInstructions", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "location", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "savedStackDescriptor", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/SavedStackDescriptor;", "generateStoreInstructions", "getPopInstruction", "Lorg/jetbrains/org/objectweb/asm/tree/InsnNode;", "top", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "removeAlwaysFalseIfeq", "node", "replaceAlwaysTrueIfeqWithGoto", "replaceMarkerWithPops", "expectedStackSize", "", "frame", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "restoreStack", "restoreStackWithReturnValue", "nodeToReplace", "returnValue", "returnValueLocalVarIndex", "saveStack", "restoreImmediately", "", "peek", "V", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Value;", "offset", "(Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;I)Lorg/jetbrains/org/objectweb/asm/tree/analysis/Value;", "(Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;)Lorg/jetbrains/org/objectweb/asm/tree/analysis/Value;", "kotlin-compiler"})
public final class StackTransformationUtilsKt {
    @Nullable
    public static final <V extends Value> V top(@NotNull Frame<V> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return StackTransformationUtilsKt.peek($receiver, 0);
    }

    @Nullable
    public static final <V extends Value> V peek(@NotNull Frame<V> $receiver, int offset2) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return (V)($receiver.getStackSize() >= offset2 ? $receiver.getStack($receiver.getStackSize() - offset2 - 1) : (Value)null);
    }

    /*
     * WARNING - void declaration
     */
    public static final void saveStack(@NotNull MethodNode methodNode, @NotNull AbstractInsnNode nodeToReplace, @NotNull SavedStackDescriptor savedStackDescriptor, boolean restoreImmediately) {
        void $receiver;
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        Intrinsics.checkParameterIsNotNull(nodeToReplace, "nodeToReplace");
        Intrinsics.checkParameterIsNotNull(savedStackDescriptor, "savedStackDescriptor");
        InsnList insnList = methodNode.instructions;
        InsnList insnList2 = insnList;
        StackTransformationUtilsKt.generateStoreInstructions(methodNode, nodeToReplace, savedStackDescriptor);
        if (restoreImmediately) {
            StackTransformationUtilsKt.generateLoadInstructions(methodNode, nodeToReplace, savedStackDescriptor);
        }
        $receiver.remove(nodeToReplace);
    }

    /*
     * WARNING - void declaration
     */
    public static final void restoreStack(@NotNull MethodNode methodNode, @NotNull AbstractInsnNode location2, @NotNull SavedStackDescriptor savedStackDescriptor) {
        void $receiver;
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        Intrinsics.checkParameterIsNotNull(location2, "location");
        Intrinsics.checkParameterIsNotNull(savedStackDescriptor, "savedStackDescriptor");
        InsnList insnList = methodNode.instructions;
        InsnList insnList2 = insnList;
        StackTransformationUtilsKt.generateLoadInstructions(methodNode, location2, savedStackDescriptor);
        $receiver.remove(location2);
    }

    /*
     * WARNING - void declaration
     */
    public static final void restoreStackWithReturnValue(@NotNull MethodNode methodNode, @NotNull AbstractInsnNode nodeToReplace, @NotNull SavedStackDescriptor savedStackDescriptor, @NotNull BasicValue returnValue, int returnValueLocalVarIndex) {
        void $receiver;
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        Intrinsics.checkParameterIsNotNull(nodeToReplace, "nodeToReplace");
        Intrinsics.checkParameterIsNotNull(savedStackDescriptor, "savedStackDescriptor");
        Intrinsics.checkParameterIsNotNull(returnValue, "returnValue");
        InsnList insnList = methodNode.instructions;
        InsnList insnList2 = insnList;
        $receiver.insertBefore(nodeToReplace, new VarInsnNode(returnValue.getType().getOpcode(54), returnValueLocalVarIndex));
        StackTransformationUtilsKt.generateLoadInstructions(methodNode, nodeToReplace, savedStackDescriptor);
        $receiver.insertBefore(nodeToReplace, new VarInsnNode(returnValue.getType().getOpcode(21), returnValueLocalVarIndex));
        $receiver.remove(nodeToReplace);
    }

    public static final void generateLoadInstructions(@NotNull MethodNode methodNode, @NotNull AbstractInsnNode location2, @NotNull SavedStackDescriptor savedStackDescriptor) {
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        Intrinsics.checkParameterIsNotNull(location2, "location");
        Intrinsics.checkParameterIsNotNull(savedStackDescriptor, "savedStackDescriptor");
        int localVarIndex = savedStackDescriptor.getFirstLocalVarIndex();
        for (BasicValue value : savedStackDescriptor.getSavedValues()) {
            methodNode.instructions.insertBefore(location2, new VarInsnNode(value.getType().getOpcode(21), localVarIndex));
            localVarIndex += value.getSize();
        }
    }

    public static final void generateStoreInstructions(@NotNull MethodNode methodNode, @NotNull AbstractInsnNode location2, @NotNull SavedStackDescriptor savedStackDescriptor) {
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        Intrinsics.checkParameterIsNotNull(location2, "location");
        Intrinsics.checkParameterIsNotNull(savedStackDescriptor, "savedStackDescriptor");
        int localVarIndex = savedStackDescriptor.getFirstUnusedLocalVarIndex();
        for (BasicValue value : CollectionsKt.asReversed(savedStackDescriptor.getSavedValues())) {
            methodNode.instructions.insertBefore(location2, new VarInsnNode(value.getType().getOpcode(54), localVarIndex -= value.getSize()));
        }
    }

    @NotNull
    public static final InsnNode getPopInstruction(@NotNull BasicValue top) {
        int n;
        Intrinsics.checkParameterIsNotNull(top, "top");
        switch (top.getSize()) {
            case 1: {
                n = 87;
                break;
            }
            case 2: {
                n = 88;
                break;
            }
            default: {
                throw (Throwable)((Object)new AssertionError((Object)"Unexpected value type size"));
            }
        }
        return new InsnNode(n);
    }

    public static final void removeAlwaysFalseIfeq(@NotNull MethodNode methodNode, @NotNull AbstractInsnNode node) {
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        Intrinsics.checkParameterIsNotNull(node, "node");
        InsnList insnList = methodNode.instructions;
        InsnList $receiver = insnList;
        $receiver.remove(node.getNext());
        $receiver.remove(node);
    }

    public static final void replaceAlwaysTrueIfeqWithGoto(@NotNull MethodNode methodNode, @NotNull AbstractInsnNode node) {
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        Intrinsics.checkParameterIsNotNull(node, "node");
        InsnList insnList = methodNode.instructions;
        InsnList $receiver = insnList;
        AbstractInsnNode abstractInsnNode = node.getNext();
        if (abstractInsnNode == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.JumpInsnNode");
        }
        JumpInsnNode next = (JumpInsnNode)abstractInsnNode;
        $receiver.insertBefore(node, new JumpInsnNode(167, next.label));
        $receiver.remove(node);
        $receiver.remove(next);
    }

    /*
     * WARNING - void declaration
     */
    public static final void replaceMarkerWithPops(@NotNull MethodNode methodNode, @NotNull AbstractInsnNode node, int expectedStackSize, @NotNull Frame<BasicValue> frame) {
        void $receiver;
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        Intrinsics.checkParameterIsNotNull(node, "node");
        Intrinsics.checkParameterIsNotNull(frame, "frame");
        InsnList insnList = methodNode.instructions;
        InsnList insnList2 = insnList;
        while (frame.getStackSize() > expectedStackSize) {
            BasicValue top;
            BasicValue basicValue = top = frame.pop();
            Intrinsics.checkExpressionValueIsNotNull(basicValue, "top");
            $receiver.insertBefore(node, StackTransformationUtilsKt.getPopInstruction(basicValue));
        }
        $receiver.remove(node);
    }
}

