/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.compiled;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiBinaryExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaToken;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsElementImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsJavaTokenImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsParsingUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;

class ClsBinaryExpressionImpl
extends ClsElementImpl
implements PsiBinaryExpression {
    private final ClsElementImpl myParent;
    private final PsiJavaToken myOperator;
    private final PsiExpression myLOperand;
    private final PsiExpression myROperand;

    ClsBinaryExpressionImpl(ClsElementImpl parent2, PsiJavaToken sign, PsiExpression left, PsiExpression right) {
        this.myParent = parent2;
        this.myOperator = new ClsJavaTokenImpl(this, sign.getTokenType(), sign.getText());
        this.myLOperand = ClsParsingUtil.psiToClsExpression(left, this);
        this.myROperand = ClsParsingUtil.psiToClsExpression(right, this);
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsBinaryExpressionImpl", "appendMirrorText"));
        }
        buffer.append(this.getText());
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsBinaryExpressionImpl", "setMirror"));
        }
        this.setMirrorCheckingType(element, JavaElementType.BINARY_EXPRESSION);
    }

    @Override
    public String getText() {
        return StringUtil.join(this.myLOperand.getText(), " ", this.myOperator.getText(), " ", this.myROperand.getText());
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray = new PsiElement[]{this.myLOperand, this.myOperator, this.myROperand};
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsBinaryExpressionImpl", "getChildren"));
        }
        return psiElementArray;
    }

    @Override
    public PsiElement getParent() {
        return this.myParent;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsBinaryExpressionImpl", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitBinaryExpression(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    @NotNull
    public PsiExpression getLOperand() {
        PsiExpression psiExpression = this.myLOperand;
        if (psiExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsBinaryExpressionImpl", "getLOperand"));
        }
        return psiExpression;
    }

    @Override
    @NotNull
    public PsiExpression getROperand() {
        PsiExpression psiExpression = this.myROperand;
        if (psiExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsBinaryExpressionImpl", "getROperand"));
        }
        return psiExpression;
    }

    @Override
    @NotNull
    public PsiJavaToken getOperationSign() {
        PsiJavaToken psiJavaToken = this.myOperator;
        if (psiJavaToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsBinaryExpressionImpl", "getOperationSign"));
        }
        return psiJavaToken;
    }

    @Override
    @NotNull
    public IElementType getOperationTokenType() {
        IElementType iElementType = this.myOperator.getTokenType();
        if (iElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsBinaryExpressionImpl", "getOperationTokenType"));
        }
        return iElementType;
    }

    @Override
    public PsiJavaToken getTokenBeforeOperand(@NotNull PsiExpression operand) {
        if (operand == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsBinaryExpressionImpl", "getTokenBeforeOperand"));
        }
        return this.getOperationSign();
    }

    @Override
    public PsiType getType() {
        return this.myLOperand.getType();
    }

    @Override
    @NotNull
    public PsiExpression[] getOperands() {
        PsiExpression[] psiExpressionArray = new PsiExpression[]{this.getLOperand(), this.getROperand()};
        if (psiExpressionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsBinaryExpressionImpl", "getOperands"));
        }
        return psiExpressionArray;
    }

    @Override
    public String toString() {
        return "PsiBinaryExpression:" + this.getText();
    }
}

