/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.foundation.ipc.gradle;

import java.net.Socket;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.execution.TaskExecutionGraphListener;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.initialization.Settings;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.logging.StandardOutputListener;
import org.gradle.api.tasks.TaskState;
import org.gradle.foundation.ipc.basic.ClientProcess;
import org.gradle.foundation.ipc.basic.MessageObject;
import org.gradle.foundation.ipc.basic.Server;
import org.gradle.foundation.ipc.gradle.KillGradleServerProtocol;
import org.gradle.gradleplugin.foundation.GradlePluginLord;

public class ExecuteGradleCommandClientProtocol
implements ClientProcess.Protocol {
    private final Logger logger = Logging.getLogger(ExecuteGradleCommandClientProtocol.class);
    private ClientProcess client;
    private boolean continueConnection = true;
    private Gradle gradle;
    private Server localServer;

    public ExecuteGradleCommandClientProtocol(Gradle gradle) {
        this.gradle = gradle;
    }

    public void initialize(ClientProcess client) {
        this.client = client;
        this.gradle.addListener((Object)new IPCExecutionListener(client));
    }

    public boolean serverConnected(Socket clientSocket) {
        MessageObject message = this.client.readMessage();
        if (message == null) {
            return false;
        }
        if (!"connected".equalsIgnoreCase(message.getMessageType())) {
            this.logger.error("Incorrect server handshaking.");
            return false;
        }
        this.localServer = new Server(new KillGradleServerProtocol());
        this.localServer.start();
        this.client.sendMessage("connected", "client-reply", Integer.valueOf(this.localServer.getPort()));
        return true;
    }

    public boolean continueConnection() {
        return this.continueConnection;
    }

    public void shutdown() {
        this.continueConnection = false;
    }

    private class IPCExecutionListener
    implements BuildListener,
    StandardOutputListener,
    TaskExecutionGraphListener,
    TaskExecutionListener {
        private ClientProcess client;
        private StringBuffer allOutputText = new StringBuffer();
        private StringBuffer bufferedLiveOutput = new StringBuffer();
        private Timer liveOutputTimer;
        private float totalTasksToExecute;
        private float totalTasksExecuted;
        private float percentComplete;

        public IPCExecutionListener(ClientProcess client) {
            this.client = client;
            this.liveOutputTimer = new Timer();
            this.liveOutputTimer.scheduleAtFixedRate(new TimerTask(){

                public void run() {
                    IPCExecutionListener.this.sendLiveOutput();
                }
            }, 500L, 500L);
        }

        public void buildStarted(Gradle build) {
        }

        public void graphPopulated(TaskExecutionGraph taskExecutionGraph) {
            List taskList = taskExecutionGraph.getAllTasks();
            this.totalTasksToExecute = taskList.size();
            this.client.sendMessage("NumberOfTasksToExecute", null, new Integer(taskList.size()));
        }

        public void settingsEvaluated(Settings settings) {
        }

        public void projectsLoaded(Gradle gradle) {
        }

        public void projectsEvaluated(Gradle gradle) {
        }

        public void beforeExecute(Task task) {
            String currentTaskName = task.getProject().getName() + ":" + task.getName();
            this.client.sendMessage("TaskStarted", currentTaskName, new Float(this.percentComplete));
        }

        public void afterExecute(Task task, TaskState state) {
            this.totalTasksExecuted += 1.0f;
            this.percentComplete = this.totalTasksExecuted / this.totalTasksToExecute * 100.0f;
            String currentTaskName = task.getProject().getName() + ":" + task.getName();
            this.client.sendMessage("TaskComplete", currentTaskName, new Float(this.percentComplete));
        }

        public synchronized void onOutput(CharSequence output) {
            this.allOutputText.append(output);
            this.bufferedLiveOutput.append(output);
        }

        private synchronized void sendLiveOutput() {
            if (this.bufferedLiveOutput.length() == 0) {
                return;
            }
            String text = this.bufferedLiveOutput.toString();
            this.bufferedLiveOutput = new StringBuffer();
            this.client.sendMessage("LiveOutput", text);
        }

        public void buildFinished(BuildResult buildResult) {
            boolean wasSuccessful = buildResult.getFailure() == null;
            String output = this.allOutputText.toString();
            this.liveOutputTimer.cancel();
            this.sendLiveOutput();
            String details = GradlePluginLord.getGradleExceptionMessage(buildResult.getFailure(), ExecuteGradleCommandClientProtocol.this.gradle.getStartParameter().getShowStacktrace());
            output = output + details;
            this.client.sendMessage("ExecutionCompleted", output, Boolean.valueOf(wasSuccessful));
            this.client.sendMessage("exiting", null, null);
            this.client.stop();
        }
    }
}

