/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.Arrays;
import org.jmol.api.SmilesMatcherInterface;
import org.jmol.java.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.Edge;
import org.jmol.util.Logger;
import org.jmol.util.Node;
import org.jmol.viewer.Viewer;

public class CIPChirality {
    Viewer vwr;

    public CIPChirality setViewer(Viewer vwr) {
        this.vwr = vwr;
        return this;
    }

    public String getChirality(Node atom) {
        String rs;
        if (atom.getCovalentBondCount() != 4) {
            return "";
        }
        CIPAtom a = new CIPAtom(atom, null, false);
        String string = rs = a.set() ? this.getRorS(a) : "";
        if (Logger.debugging) {
            Logger.info(atom + " " + rs);
        }
        return rs;
    }

    public String getRorS(CIPAtom a) {
        try {
            CIPAtom[] atoms = CIPChirality.sortSubstituents(a.atoms, false);
            if (atoms == null) {
                return "";
            }
            SmilesMatcherInterface sm = this.vwr.getSmilesMatcher();
            switch (sm.getChirality(atoms[3].atom, atoms[2].atom, atoms[1].atom, atoms[0].atom)) {
                case 1: {
                    return "R";
                }
                case 2: {
                    return "S";
                }
            }
            return "";
        }
        catch (Throwable e) {
            e.printStackTrace();
            return "";
        }
    }

    private static CIPAtom[] sortSubstituents(CIPAtom[] atoms, boolean allowTie) {
        int i;
        int i2;
        int n = atoms.length;
        for (i2 = 0; i2 < n; ++i2) {
            atoms[i2].isAbove = 0;
        }
        for (i2 = 0; i2 < n; ++i2) {
            CIPAtom a = atoms[i2];
            block12: for (int j = i2 + 1; j < n; ++j) {
                CIPAtom b = atoms[j];
                int score = (int)Math.signum(a.compareTo(b));
                if (Logger.debugging) {
                    Logger.info("comparing " + a + " and " + b + " = " + score);
                }
                block0 : switch (score) {
                    case 1: {
                        ++a.isAbove;
                        continue block12;
                    }
                    case -1: {
                        ++b.isAbove;
                        continue block12;
                    }
                    case 0: {
                        switch (CIPChirality.breakTie(a, b)) {
                            case 1: {
                                ++a.isAbove;
                                break block0;
                            }
                            case -1: {
                                ++b.isAbove;
                                break block0;
                            }
                            case 0: {
                                if (allowTie) {
                                    ++a.isAbove;
                                    break block0;
                                }
                                return null;
                            }
                        }
                    }
                }
            }
        }
        CIPAtom[] ret = new CIPAtom[n];
        for (i = 0; i < n; ++i) {
            ret[atoms[i].isAbove] = atoms[i];
        }
        if (Logger.debugging) {
            for (i = 0; i < n; ++i) {
                Logger.info("" + ret[i]);
            }
        }
        return ret;
    }

    private static int breakTie(CIPAtom a, CIPAtom b) {
        int score;
        CIPAtom bi;
        CIPAtom ai;
        int i;
        if (!a.set() || !b.set() || a.isTerminal || a.atom == b.atom) {
            return 0;
        }
        if (Logger.debugging) {
            Logger.info("tie for " + a + " and " + b);
        }
        for (i = 0; i < a.nAtoms; ++i) {
            ai = a.atoms[i];
            bi = b.atoms[i];
            score = (int)Math.signum(CIPChirality.compareAB(ai, bi));
            switch (score) {
                case -1: 
                case 1: {
                    return score;
                }
            }
        }
        a.atoms = CIPChirality.sortSubstituents(a.atoms, true);
        b.atoms = CIPChirality.sortSubstituents(b.atoms, true);
        for (i = 0; i < a.nAtoms; ++i) {
            ai = a.atoms[i];
            bi = b.atoms[i];
            score = ai.isDummy == bi.isDummy ? CIPChirality.breakTie(ai, bi) : (ai.isDummy ? -1 : 1);
            switch (score) {
                case -1: 
                case 1: {
                    return score;
                }
            }
        }
        return 0;
    }

    public static int compareAB(CIPAtom a, CIPAtom b) {
        return b.atom == a.atom ? 0 : (b.atom == null ? -1 : (a.atom == null ? 1 : (b.elemNo != a.elemNo ? (b.elemNo < a.elemNo ? -1 : 1) : (b.massNo != a.massNo ? (b.massNo < a.massNo ? -1 : 1) : 0))));
    }

    private class CIPAtom
    implements Comparable<CIPAtom> {
        Node atom;
        int massNo;
        int elemNo;
        CIPAtom parent;
        boolean isDummy = true;
        boolean isTerminal;
        boolean isSet;
        int isAbove;
        BS bsPath;
        CIPAtom[] atoms;
        int nAtoms;

        public String toString() {
            return this.atom.toString() + (this.isDummy ? " *" : " " + (this.isAbove + 1));
        }

        public CIPAtom(Node atom, CIPAtom parent, boolean isDummy) {
            if (atom == null) {
                return;
            }
            this.atom = atom;
            this.parent = parent;
            this.isTerminal = atom.getCovalentBondCount() == 1;
            this.elemNo = atom.getElementNumber();
            this.massNo = atom.getNominalMass();
            this.bsPath = parent == null ? new BS() : BSUtil.copy(parent.bsPath);
            int iatom = atom.getIndex();
            if (this.bsPath.get(iatom)) {
                isDummy = true;
            } else {
                this.bsPath.set(iatom);
            }
            this.isDummy = isDummy;
        }

        boolean set() {
            if (this.isTerminal) {
                return true;
            }
            if (this.isSet) {
                return true;
            }
            this.isSet = true;
            if (this.isDummy) {
                return false;
            }
            this.atoms = new CIPAtom[this.parent == null ? 4 : 3];
            int nBonds = this.atom.getBondCount();
            Edge[] bonds = this.atom.getEdges();
            int pt = 0;
            block5: for (int i = 0; i < nBonds; ++i) {
                Edge bond = bonds[i];
                if (!bond.isCovalent()) continue;
                Node other = bond.getOtherAtomNode(this.atom);
                if (this.parent != null && this.parent.atom == other) continue;
                int order = bond.getCovalentOrder();
                switch (order) {
                    case 3: {
                        if (!this.addAtom(pt++, other, true)) {
                            this.isTerminal = true;
                            return false;
                        }
                    }
                    case 2: {
                        if (!this.addAtom(pt++, other, true)) {
                            this.isTerminal = true;
                            return false;
                        }
                    }
                    case 1: {
                        if (this.addAtom(pt++, other, false)) continue block5;
                        this.isTerminal = true;
                        return false;
                    }
                    default: {
                        this.isTerminal = true;
                        return false;
                    }
                }
            }
            this.isTerminal = pt == 0;
            this.nAtoms = pt;
            while (pt < this.atoms.length) {
                this.atoms[pt] = new CIPAtom(null, null, true);
                ++pt;
            }
            Arrays.sort(this.atoms);
            return !this.isTerminal;
        }

        private boolean addAtom(int i, Node other, boolean isDummy) {
            if (i >= this.atoms.length) {
                return false;
            }
            this.atoms[i] = new CIPAtom(other, this, isDummy);
            return true;
        }

        @Override
        public int compareTo(CIPAtom a) {
            return a.atom == this.atom ? 0 : (a.atom == null ? -1 : (this.atom == null ? 1 : (a.elemNo != this.elemNo ? (a.elemNo < this.elemNo ? -1 : 1) : (a.massNo != this.massNo ? (a.massNo < this.massNo ? -1 : 1) : (a.isDummy != this.isDummy ? (a.isDummy ? -1 : 1) : 0)))));
        }
    }
}

