/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.T3;
import org.jmol.api.SmilesMatcherInterface;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.smiles.InvalidSmilesException;
import org.jmol.smiles.SmilesAtom;
import org.jmol.smiles.SmilesBond;
import org.jmol.smiles.SmilesGenerator;
import org.jmol.smiles.SmilesParser;
import org.jmol.smiles.SmilesSearch;
import org.jmol.smiles.SmilesStereo;
import org.jmol.smiles.VTemp;
import org.jmol.util.BSUtil;
import org.jmol.util.Elements;
import org.jmol.util.Logger;
import org.jmol.util.Node;
import org.jmol.util.Point3fi;

public class SmilesMatcher
implements SmilesMatcherInterface {
    private static final int MODE_BITSET = 1;
    private static final int MODE_ARRAY = 2;
    private static final int MODE_MAP = 3;
    private static final int MODE_ATROP = 4;

    public String getLastException() {
        return InvalidSmilesException.getLastError();
    }

    public String getMolecularFormula(String pattern, boolean isSmarts) throws Exception {
        InvalidSmilesException.clear();
        SmilesSearch search = SmilesParser.newSearch("/nostereo/" + pattern, isSmarts, true);
        search.createTopoMap(null);
        search.nodes = search.targetAtoms;
        return search.getMolecularFormula(!isSmarts, null, false);
    }

    public String getSmiles(Node[] atoms, int ac, BS bsSelected, String bioComment, int flags) throws Exception {
        InvalidSmilesException.clear();
        return new SmilesGenerator().getSmiles(this, atoms, ac, bsSelected, bioComment, flags);
    }

    public int areEqual(String smiles1, String smiles2) throws Exception {
        InvalidSmilesException.clear();
        BS[] result = (BS[])this.findPriv(smiles1, SmilesParser.newSearch(smiles2, false, true), (smiles1.indexOf("*") >= 0 ? 2 : 1) | 8, 2);
        return result == null ? -1 : result.length;
    }

    public boolean areEqualTest(String smiles, SmilesSearch search) throws Exception {
        BS[] ret = (BS[])this.findPriv(smiles, search, 9, 2);
        return ret != null && ret.length == 1;
    }

    public int[][] find(String pattern, String target, int flags) throws Exception {
        InvalidSmilesException.clear();
        target = SmilesParser.cleanPattern(target);
        pattern = SmilesParser.cleanPattern(pattern);
        SmilesSearch search = SmilesParser.newSearch(target, false, true);
        int[][] array = (int[][])this.findPriv(pattern, search, flags, 3);
        int i = array.length;
        while (--i >= 0) {
            int[] a = array[i];
            int j = a.length;
            while (--j >= 0) {
                a[j] = ((SmilesAtom)search.targetAtoms[a[j]]).mapIndex;
            }
        }
        return array;
    }

    public String getRelationship(String smiles1, String smiles2) throws Exception {
        int n2;
        boolean check;
        String mf2;
        if (smiles1 == null || smiles2 == null || smiles1.length() == 0 || smiles2.length() == 0) {
            return "";
        }
        String mf1 = this.getMolecularFormula(smiles1, false);
        if (!mf1.equals(mf2 = this.getMolecularFormula(smiles2, false))) {
            return "none";
        }
        int n1 = PT.countChar((String)PT.rep((String)smiles1, (String)"@@", (String)"@"), (char)'@');
        boolean bl = check = n1 == (n2 = PT.countChar((String)PT.rep((String)smiles2, (String)"@@", (String)"@"), (char)'@')) && this.areEqual(smiles2, smiles1) > 0;
        if (!check) {
            String s = smiles1 + smiles2;
            if (s.indexOf("/") >= 0 || s.indexOf("\\") >= 0 || s.indexOf("@") >= 0) {
                if (n1 == n2 && n1 > 0 && s.indexOf("@SP") < 0) {
                    boolean bl2 = check = this.areEqual("/invertstereo/" + smiles2, smiles1) > 0;
                    if (check) {
                        return "enantiomers";
                    }
                }
                boolean bl3 = check = this.areEqual("/nostereo/" + smiles2, smiles1) > 0;
                if (check) {
                    return n1 == n2 ? "diastereomers" : "ambiguous stereochemistry!";
                }
            }
            return "constitutional isomers";
        }
        return "identical";
    }

    public String reverseChirality(String smiles) {
        smiles = PT.rep((String)smiles, (String)"@@", (String)"!@");
        smiles = PT.rep((String)smiles, (String)"@", (String)"@@");
        smiles = PT.rep((String)smiles, (String)"!@@", (String)"@");
        return smiles;
    }

    public BS getSubstructureSet(String pattern, Node[] atoms, int ac, BS bsSelected, int flags) throws Exception {
        return (BS)this.matchPriv(pattern, atoms, ac, bsSelected, null, true, flags | SmilesParser.getFlags(pattern), 1);
    }

    public void getMMFF94AtomTypes(String[] smarts, Node[] atoms, int ac, BS bsSelected, Lst<BS> ret, Lst<BS>[] vRings) throws Exception {
        InvalidSmilesException.clear();
        SmilesParser sp = new SmilesParser(true, true);
        SmilesSearch search = null;
        int flags = 770;
        search = sp.parse("");
        search.exitFirstMatch = false;
        search.targetAtoms = atoms;
        search.targetAtomCount = Math.abs(ac);
        search.setSelected(bsSelected);
        search.flags = flags;
        search.getRingData(vRings, true, true);
        search.asVector = false;
        search.subSearches = new SmilesSearch[1];
        search.getSelections();
        BS bsDone = new BS();
        for (int i = 0; i < smarts.length; ++i) {
            if (smarts[i] == null || smarts[i].length() == 0 || smarts[i].startsWith("#")) {
                ret.addLast(null);
                continue;
            }
            search.clear();
            search.subSearches[0] = sp.getSubsearch(search, SmilesParser.cleanPattern(smarts[i]), flags);
            BS bs = BSUtil.copy((BS)((BS)search.search()));
            ret.addLast((Object)bs);
            bsDone.or(bs);
            if (bsDone.cardinality() != ac) continue;
            return;
        }
    }

    public BS[] getSubstructureSetArray(String pattern, Node[] atoms, int ac, BS bsSelected, BS bsAromatic, int flags) throws Exception {
        return (BS[])this.matchPriv(pattern, atoms, ac, bsSelected, bsAromatic, true, flags, 2);
    }

    public String getAtropisomerKeys(String pattern, Node[] atoms, int ac, BS bsSelected, BS bsAromatic, int flags) throws Exception {
        return (String)this.matchPriv(pattern, atoms, ac, bsSelected, bsAromatic, false, flags, 4);
    }

    public String polyhedronToSmiles(Node center, int[][] faces, int atomCount, P3[] points, int flags, String details) throws Exception {
        Node[] atoms = new SmilesAtom[atomCount];
        for (int i = 0; i < atomCount; ++i) {
            P3 pt;
            atoms[i] = new SmilesAtom();
            P3 p3 = pt = points == null ? null : points[i];
            if (pt instanceof Node) {
                atoms[i].elementNumber = ((Node)pt).getElementNumber();
                atoms[i].bioAtomName = ((Node)pt).getAtomName();
                atoms[i].atomNumber = ((Node)pt).getAtomNumber();
                atoms[i].setT((T3)pt);
            } else {
                atoms[i].elementNumber = pt instanceof Point3fi ? (int)((Point3fi)pt).sD : -2;
            }
            atoms[i].index = i;
        }
        int nBonds = 0;
        int i = faces.length;
        while (--i >= 0) {
            int n;
            int[] face = faces[i];
            int j = n = face.length;
            while (--j >= 0) {
                int iatom2;
                int iatom = face[j];
                if (iatom >= atomCount || (iatom2 = face[(j + 1) % n]) >= atomCount || atoms[iatom].getBondTo((SmilesAtom)atoms[iatom2]) != null) continue;
                SmilesBond b = new SmilesBond((SmilesAtom)atoms[iatom], (SmilesAtom)atoms[iatom2], 1, false);
                b.index = nBonds++;
            }
        }
        for (i = 0; i < atomCount; ++i) {
            int n = atoms[i].bondCount;
            if (n != 0 && n == atoms[i].bonds.length) continue;
            atoms[i].bonds = (SmilesBond[])AU.arrayCopyObject((Object)atoms[i].bonds, (int)n);
        }
        String s = null;
        SmilesGenerator g = new SmilesGenerator();
        if (points != null) {
            g.polySmilesCenter = (P3)center;
        }
        InvalidSmilesException.clear();
        s = g.getSmiles(this, atoms, atomCount, BSUtil.newBitSet2((int)0, (int)atomCount), null, flags | 0x1000 | 0x10 | 0x20);
        if ((flags & 0x10000) == 65536) {
            s = "//* " + center + " *//\t[" + Elements.elementSymbolFromNumber((int)center.getElementNumber()) + "@PH" + atomCount + (details == null ? "" : "/" + details + "/") + "]." + s;
        }
        return s;
    }

    public int[][] getCorrelationMaps(String pattern, Node[] atoms, int atomCount, BS bsSelected, int flags) throws Exception {
        return (int[][])this.matchPriv(pattern, atoms, atomCount, bsSelected, null, true, flags, 3);
    }

    private Object findPriv(String pattern, SmilesSearch search, int flags, int mode) throws Exception {
        BS bsAromatic = new BS();
        search.setFlags(search.flags | SmilesParser.getFlags(pattern));
        search.createTopoMap(bsAromatic);
        return this.matchPriv(pattern, search.targetAtoms, -search.targetAtoms.length, null, bsAromatic, bsAromatic.isEmpty(), flags, mode);
    }

    private Object matchPriv(String pattern, Node[] atoms, int ac, BS bsSelected, BS bsAromatic, boolean doTestAromatic, int flags, int mode) throws Exception {
        InvalidSmilesException.clear();
        try {
            boolean isSmarts = (flags & 2) == 2;
            SmilesSearch search = SmilesParser.newSearch(pattern, isSmarts, false);
            if (!isSmarts && !search.patternAromatic) {
                if (bsAromatic == null) {
                    bsAromatic = new BS();
                }
                SmilesSearch.normalizeAromaticity(search.patternAtoms, bsAromatic, search.flags);
                search.isNormalized = true;
            }
            search.targetAtoms = atoms;
            search.targetAtomCount = Math.abs(ac);
            if (ac < 0) {
                search.haveTopo = true;
            }
            if (!(ac == 0 || bsSelected != null && bsSelected.isEmpty())) {
                boolean is3D = !(atoms[0] instanceof SmilesAtom);
                search.setSelected(bsSelected);
                search.getSelections();
                if (!doTestAromatic) {
                    search.bsAromatic = bsAromatic;
                }
                search.setRingData(null, null, is3D || doTestAromatic);
                search.exitFirstMatch = (flags & 8) == 8;
                search.mapUnique = (flags & 0x80) == 128;
            }
            switch (mode) {
                case 1: {
                    search.asVector = false;
                    return search.search();
                }
                case 2: {
                    search.asVector = true;
                    Lst vb = (Lst)search.search();
                    return vb.toArray((Object[])new BS[vb.size()]);
                }
                case 4: {
                    search.exitFirstMatch = true;
                    search.setAtropicity = true;
                    search.search();
                    return search.atropKeys;
                }
                case 3: {
                    search.getMaps = true;
                    search.setFlags(flags | search.flags);
                    Lst vl = (Lst)search.search();
                    return vl.toArray((Object[])AU.newInt2((int)vl.size()));
                }
            }
        }
        catch (Exception e) {
            if (Logger.debugging) {
                e.printStackTrace();
            }
            if (InvalidSmilesException.getLastError() == null) {
                InvalidSmilesException.clear();
            }
            throw new InvalidSmilesException(InvalidSmilesException.getLastError());
        }
        return null;
    }

    public String cleanSmiles(String smiles) {
        return SmilesParser.cleanPattern(smiles);
    }

    public int[][] getMapForJME(String jme, Atom[] at, BS bsAtoms) {
        SmilesSearch molecule = new SmilesSearch();
        String[] tokens = PT.getTokens((String)jme);
        int nAtoms = PT.parseInt((String)tokens[0]);
        int nBonds = PT.parseInt((String)tokens[1]);
        int pt = 2;
        int i = 0;
        while (i < nAtoms) {
            String sa = tokens[pt];
            SmilesAtom a = molecule.addAtom();
            int ic = sa.indexOf("+");
            int charge = 0;
            if (ic >= 0) {
                charge = ic == sa.length() - 1 ? 1 : PT.parseInt((String)sa.substring(ic + 1));
            } else {
                ic = sa.indexOf("-");
                if (ic >= 0) {
                    charge = PT.parseInt((String)sa.substring(ic));
                }
            }
            a.setCharge(charge);
            a.setSymbol(ic < 0 ? sa : sa.substring(0, ic));
            ++i;
            pt += 3;
        }
        i = 0;
        while (i < nBonds) {
            int ia = PT.parseInt((String)tokens[pt++]) - 1;
            int ib = PT.parseInt((String)tokens[pt++]) - 1;
            int iorder = PT.parseInt((String)tokens[pt++]);
            SmilesAtom a1 = molecule.patternAtoms[ia];
            SmilesAtom a2 = molecule.patternAtoms[ib];
            int order = 1;
            switch (iorder) {
                default: {
                    break;
                }
                case 2: {
                    order = 2;
                    break;
                }
                case 3: {
                    order = 3;
                }
            }
            new SmilesBond((SmilesAtom)a1, (SmilesAtom)a2, (int)order, (boolean)false).index = i++;
        }
        String s = "";
        try {
            molecule.isSmarts = true;
            molecule.set();
            BS bs = BSUtil.newBitSet2((int)0, (int)nAtoms);
            s = this.getSmiles(molecule.patternAtoms, molecule.ac, bs, null, 34);
            int[][] map = this.getCorrelationMaps(s, molecule.patternAtoms, nAtoms, bs, 42);
            int[][] map2 = this.getCorrelationMaps(s, (Node[])at, bsAtoms.cardinality(), bsAtoms, 42);
            return new int[][]{map[0], map2[0]};
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getChirality(Node atom4, Node atom3, Node atom2, Node atom1) {
        return SmilesStereo.getHandedness(atom4, atom3, atom2, atom1, new VTemp());
    }
}

