Clazz.declarePackage ("JS");
Clazz.load (null, "JS.CIPChirality", ["java.util.Arrays", "JU.BS", "JU.BSUtil", "$.Logger"], function () {
c$ = Clazz.decorateAsClass (function () {
this.vwr = null;
if (!Clazz.isClassDefined ("JS.CIPChirality.CIPAtom")) {
JS.CIPChirality.$CIPChirality$CIPAtom$ ();
}
Clazz.instantialize (this, arguments);
}, JS, "CIPChirality");
Clazz.makeConstructor (c$, 
function () {
});
Clazz.defineMethod (c$, "setViewer", 
function (vwr) {
this.vwr = vwr;
return this;
}, "JV.Viewer");
Clazz.defineMethod (c$, "getChirality", 
function (atom) {
if (atom.getCovalentBondCount () != 4) return "";
var a = Clazz.innerTypeInstance (JS.CIPChirality.CIPAtom, this, null, atom, null, false);
var rs = (a.set () ? this.getRorS (a) : "");
if (JU.Logger.debugging) JU.Logger.info (atom + " " + rs);
return rs;
}, "JU.Node");
Clazz.defineMethod (c$, "getRorS", 
function (a) {
try {
var atoms = JS.CIPChirality.sortSubstituents (a.atoms, false);
if (atoms == null) return "";
var sm = this.vwr.getSmilesMatcher ();
switch (sm.getChirality (atoms[3].atom, atoms[2].atom, atoms[1].atom, atoms[0].atom)) {
case 1:
return "R";
case 2:
return "S";
default:
return "";
}
} catch (e) {
e.printStackTrace ();
return "";
}
}, "JS.CIPChirality.CIPAtom");
c$.sortSubstituents = Clazz.defineMethod (c$, "sortSubstituents", 
 function (atoms, allowTie) {
var n = atoms.length;
for (var i = 0; i < n; i++) atoms[i].isAbove = 0;

for (var i = 0; i < n; i++) {
var a = atoms[i];
for (var j = i + 1; j < n; j++) {
var b = atoms[j];
var score = Clazz.floatToInt (Math.signum (a.compareTo (b)));
if (JU.Logger.debugging) JU.Logger.info ("comparing " + a + " and " + b + " = " + score);
switch (score) {
case 1:
a.isAbove++;
break;
case -1:
b.isAbove++;
break;
case 0:
switch (JS.CIPChirality.breakTie (a, b)) {
case 1:
a.isAbove++;
break;
case -1:
b.isAbove++;
break;
case 0:
if (allowTie) a.isAbove++;
 else return null;
}
}
}
}
var ret =  new Array (n);
for (var i = 0; i < n; i++) ret[atoms[i].isAbove] = atoms[i];

if (JU.Logger.debugging) for (var i = 0; i < n; i++) JU.Logger.info ("" + ret[i]);

return ret;
}, "~A,~B");
c$.breakTie = Clazz.defineMethod (c$, "breakTie", 
 function (a, b) {
if (!a.set () || !b.set () || a.isTerminal || a.atom === b.atom) return 0;
if (JU.Logger.debugging) JU.Logger.info ("tie for " + a + " and " + b);
for (var i = 0; i < a.nAtoms; i++) {
var ai = a.atoms[i];
var bi = b.atoms[i];
var score = Clazz.floatToInt (Math.signum (JS.CIPChirality.compareAB (ai, bi)));
switch (score) {
case -1:
case 1:
return score;
case 0:
break;
}
}
a.atoms = JS.CIPChirality.sortSubstituents (a.atoms, true);
b.atoms = JS.CIPChirality.sortSubstituents (b.atoms, true);
for (var i = 0; i < a.nAtoms; i++) {
var ai = a.atoms[i];
var bi = b.atoms[i];
var score = (ai.isDummy == bi.isDummy ? JS.CIPChirality.breakTie (ai, bi) : ai.isDummy ? -1 : 1);
switch (score) {
case -1:
case 1:
return score;
case 0:
}
}
return 0;
}, "JS.CIPChirality.CIPAtom,JS.CIPChirality.CIPAtom");
c$.compareAB = Clazz.defineMethod (c$, "compareAB", 
function (a, b) {
return b.atom === a.atom ? 0 : b.atom == null ? -1 : a.atom == null ? 1 : b.elemNo != a.elemNo ? (b.elemNo < a.elemNo ? -1 : 1) : b.massNo != a.massNo ? (b.massNo < a.massNo ? -1 : 1) : 0;
}, "JS.CIPChirality.CIPAtom,JS.CIPChirality.CIPAtom");
c$.$CIPChirality$CIPAtom$ = function () {
Clazz.pu$h(self.c$);
c$ = Clazz.decorateAsClass (function () {
Clazz.prepareCallback (this, arguments);
this.atom = null;
this.massNo = 0;
this.elemNo = 0;
this.parent = null;
this.isDummy = true;
this.isTerminal = false;
this.isSet = false;
this.isAbove = 0;
this.bsPath = null;
this.atoms = null;
this.nAtoms = 0;
Clazz.instantialize (this, arguments);
}, JS.CIPChirality, "CIPAtom", null, Comparable);
Clazz.defineMethod (c$, "toString", 
function () {
return this.atom.toString () + (this.isDummy ? " *" : "" + " " + (this.isAbove + 1));
});
Clazz.makeConstructor (c$, 
function (a, b, c) {
if (a == null) return;
this.atom = a;
this.parent = b;
this.isTerminal = a.getCovalentBondCount () == 1;
this.elemNo = a.getElementNumber ();
this.massNo = a.getNominalMass ();
this.bsPath = (b == null ?  new JU.BS () : JU.BSUtil.copy (b.bsPath));
var d = a.getIndex ();
if (this.bsPath.get (d)) {
c = true;
} else {
this.bsPath.set (d);
}this.isDummy = c;
}, "JU.Node,JS.CIPChirality.CIPAtom,~B");
Clazz.defineMethod (c$, "set", 
function () {
if (this.isTerminal) return true;
if (this.isSet) return true;
this.isSet = true;
if (this.isDummy) return false;
this.atoms =  new Array (this.parent == null ? 4 : 3);
var a = this.atom.getBondCount ();
var b = this.atom.getEdges ();
var c = 0;
for (var d = 0; d < a; d++) {
var e = b[d];
if (!e.isCovalent ()) continue;
var f = e.getOtherAtomNode (this.atom);
if (this.parent != null && this.parent.atom === f) continue;
var g = e.getCovalentOrder ();
switch (g) {
case 3:
if (!this.addAtom (c++, f, true)) {
this.isTerminal = true;
return false;
}case 2:
if (!this.addAtom (c++, f, true)) {
this.isTerminal = true;
return false;
}case 1:
if (!this.addAtom (c++, f, false)) {
this.isTerminal = true;
return false;
}break;
default:
this.isTerminal = true;
return false;
}
}
this.isTerminal = (c == 0);
this.nAtoms = c;
for (; c < this.atoms.length; c++) this.atoms[c] = Clazz.innerTypeInstance (JS.CIPChirality.CIPAtom, this, null, null, null, true);

java.util.Arrays.sort (this.atoms);
return !this.isTerminal;
});
Clazz.defineMethod (c$, "addAtom", 
 function (a, b, c) {
if (a >= this.atoms.length) return false;
this.atoms[a] = Clazz.innerTypeInstance (JS.CIPChirality.CIPAtom, this, null, b, this, c);
return true;
}, "~N,JU.Node,~B");
Clazz.overrideMethod (c$, "compareTo", 
function (a) {
return a.atom === this.atom ? 0 : a.atom == null ? -1 : this.atom == null ? 1 : a.elemNo != this.elemNo ? (a.elemNo < this.elemNo ? -1 : 1) : a.massNo != this.massNo ? (a.massNo < this.massNo ? -1 : 1) : a.isDummy != this.isDummy ? (a.isDummy ? -1 : 1) : 0;
}, "JS.CIPChirality.CIPAtom");
c$ = Clazz.p0p ();
};
});
