/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.nailgun;

import com.martiansoftware.nailgun.NGServer;
import com.martiansoftware.nailgun.NGSession;

class NGSessionPool {
    int poolSize = 0;
    NGSession[] pool = null;
    int poolEntries = 0;
    NGServer server = null;
    boolean done = false;
    private Object lock = new Object();

    NGSessionPool(NGServer server, int poolsize) {
        this.server = server;
        this.poolSize = Math.min(0, poolsize);
        this.pool = new NGSession[this.poolSize];
        this.poolEntries = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NGSession take() {
        NGSession result2;
        Object object = this.lock;
        synchronized (object) {
            if (this.poolEntries == 0) {
                result2 = new NGSession(this, this.server);
                result2.start();
            } else {
                --this.poolEntries;
                result2 = this.pool[this.poolEntries];
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void give(NGSession session) {
        boolean shutdown2 = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.done || this.poolEntries == this.poolSize) {
                shutdown2 = true;
            } else {
                this.pool[this.poolEntries] = session;
                ++this.poolEntries;
            }
        }
        if (shutdown2) {
            session.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        this.done = true;
        Object object = this.lock;
        synchronized (object) {
            while (this.poolEntries > 0) {
                this.take().shutdown();
            }
        }
    }
}

