/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.source.Source;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.CoreMethodNodeManager;
import org.jruby.truffle.core.InlinableBuiltin;
import org.jruby.truffle.core.array.ArrayUtils;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.dispatch.RubyCallNode;
import org.jruby.truffle.language.dispatch.RubyCallNodeParameters;
import org.jruby.truffle.language.methods.InternalMethod;
import org.jruby.truffle.language.methods.LookupMethodNode;
import org.jruby.truffle.language.methods.LookupMethodNodeGen;

public class InlinedCoreMethodNode
extends RubyNode {
    private final RubyCallNodeParameters callNodeParameters;
    private final InternalMethod method;
    private final Assumption tracingUnused;
    @Node.Child
    private InlinableBuiltin builtin;
    @Node.Child
    private LookupMethodNode lookupMethodNode;
    @Node.Child
    private RubyNode receiverNode;
    @Node.Children
    private final RubyNode[] argumentNodes;
    private RubyCallNode replacedBy = null;

    public InlinedCoreMethodNode(RubyCallNodeParameters callNodeParameters, InternalMethod method, InlinableBuiltin builtin) {
        this.callNodeParameters = callNodeParameters;
        this.method = method;
        this.tracingUnused = this.getContext().getTraceManager().getUnusedAssumption();
        this.builtin = builtin;
        this.lookupMethodNode = LookupMethodNodeGen.create(false, false, null, null);
        this.receiverNode = callNodeParameters.getReceiver();
        this.argumentNodes = callNodeParameters.getArguments();
    }

    public boolean guard(Object[] args) {
        return args[1] instanceof Integer;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object self = this.receiverNode.execute(frame);
        InternalMethod lookedUpMethod = this.lookupMethodNode.executeLookupMethod(frame, self, this.method.getName());
        Object[] arguments = this.executeArguments(frame, self);
        if (lookedUpMethod == this.method && this.guard(arguments) && this.tracingUnused.isValid()) {
            return this.builtin.executeBuiltin(frame, arguments);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        Object[] argumentsObjects = ArrayUtils.extractRange(arguments, 1, arguments.length);
        return this.rewriteToCallNode().executeWithArgumentsEvaluated(frame, arguments[0], argumentsObjects);
    }

    @ExplodeLoop
    private Object[] executeArguments(VirtualFrame frame, Object self) {
        Object[] arguments = new Object[1 + this.argumentNodes.length];
        arguments[0] = self;
        for (int i = 0; i < this.argumentNodes.length; ++i) {
            arguments[1 + i] = this.argumentNodes[i].execute(frame);
        }
        return arguments;
    }

    private RubyCallNode rewriteToCallNode() {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.atomic(() -> {
            boolean found;
            boolean bl = found = !NodeUtil.forEachChild(this.getParent(), node -> node != this);
            if (found) {
                RubyCallNode callNode;
                this.replacedBy = callNode = new RubyCallNode(this.callNodeParameters.withReceiverAndArguments(this.receiverNode, this.argumentNodes, this.callNodeParameters.getBlock()));
                return this.replace(callNode, this.method.getName() + " could not be executed inline");
            }
            return this.replacedBy;
        });
    }

    public static InlinedCoreMethodNode inlineBuiltin(RubyContext context, Source source, RubyCallNodeParameters callParameters, InternalMethod method, NodeFactory<? extends InlinableBuiltin> builtinFactory) {
        List<RubyNode> arguments = Arrays.asList(new RubyNode[1 + callParameters.getArguments().length]);
        InlinableBuiltin builtinNode = CoreMethodNodeManager.createNodeFromFactory(context, source, null, builtinFactory, arguments);
        return new InlinedCoreMethodNode(callParameters, method, builtinNode);
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        return this.rewriteToCallNode().isDefined(frame);
    }
}

