/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.builtins.Primitive;
import org.jruby.truffle.builtins.PrimitiveArrayArgumentsNode;
import org.jruby.truffle.core.cast.ToFNode;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.objects.IsANode;
import org.jruby.truffle.language.objects.IsANodeGen;

@CoreClass(value="Math")
public abstract class MathNodes {
    public static final double[] ASINH_COEF = new double[]{-0.12820039911738187, -0.05881176118995177, 0.004727465432212481, -4.938363162653618E-4, 5.850620705855741E-5, -7.466998328931368E-6, 1.00116935835582E-6, -1.3903543858708333E-7, 1.9823169483172795E-8, -2.8847468417848845E-9, 4.2672965467159937E-10, -6.397608465436636E-11, 9.699168608906471E-12, -1.4844276972043772E-12, 2.290373793902745E-13, -3.5588395132732646E-14, 5.563969408005679E-15, -8.746250959962468E-16, 1.381524884452669E-16, -2.1916688282900364E-17, 3.490465852482756E-18};
    public static final double[] ATANH_COEF = new double[]{0.0943951023931955, 0.04919843705578616, 0.002102593522455433, 1.0735544497761166E-4, 5.978267249293031E-6, 3.505062030889135E-7, 2.1263743437653402E-8, 1.3216945357155272E-9, 8.36587550117807E-11, 5.370503749311002E-12, 3.4866594701571077E-13, 2.284549509603433E-14, 1.508407105944793E-15, 1.0024188168041091E-16, 6.69867473816507E-18, 4.497954546494931E-19};
    public static final double[] ERFC_COEF = new double[]{-0.049046121234691806, -0.14226120510371365, 0.010035582187599796, -5.768764699767485E-4, 2.741993125219606E-5, -1.1043175507344507E-6, 3.8488755420345036E-8, -1.1808582533875466E-9, 3.2334215826050907E-11, -7.991015947004549E-13, 1.7990725113961456E-14, -3.718635487818693E-16, 7.103599003714253E-18, -1.2612455119155226E-19};
    public static final double[] ERFC2_COEF = new double[]{-0.0696013466023095, -0.04110133936262089, 0.003914495866689627, -4.906395650548979E-4, 7.157479001377036E-5, -1.1530716341312328E-5, 1.9946705902019974E-6, -3.642666471599223E-7, 6.944372610005012E-8, -1.371220902104366E-8, 2.7883896610071373E-9, -5.814164724331161E-10, 1.2389204917527532E-10, -2.6906391453067435E-11, 5.942614350847911E-12, -1.3323867357581197E-12, 3.0280468061771323E-13, -6.966648814941033E-14, 1.620854541053923E-14, -3.809934465250492E-15, 9.040487815978831E-16, -2.1640061950896072E-16, 5.222102233995855E-17, -1.2697296023645554E-17, 3.1091455042761977E-18, -7.663762920320386E-19, 1.9008192513627452E-19};
    public static final double[] ERFCC_COEF = new double[]{0.07151793102029248, -0.026532434337606717, 0.0017111539779208558, -1.6375166345851787E-4, 1.9871293500552038E-5, -2.843712412766555E-6, 4.6061613089631305E-7, -8.227753025879209E-8, 1.5921418727709012E-8, -3.295071362252843E-9, 7.223439760400556E-10, -1.6648558133987297E-10, 4.010392588237665E-11, -1.004816214425731E-11, 2.608275913300334E-12, -6.991110560404025E-13, 1.9294923332617072E-13, -5.470131188754331E-14, 1.5896633097626975E-14, -4.726893980197555E-15, 1.4358733767849847E-15, -4.449510561817358E-16, 1.4048108847682335E-16, -4.5138183877642106E-17, 1.474521541045133E-17, -4.8926214069457765E-18, 1.6476121414106467E-18, -5.626817176329408E-19, 1.9474433822320786E-19};
    private static final double[] FACTORIAL = new double[]{1.0, 1.0, 2.0, 6.0, 24.0, 120.0, 720.0, 5040.0, 40320.0, 362880.0, 3628800.0, 3.99168E7, 4.790016E8, 6.2270208E9, 8.71782912E10, 1.307674368E12, 2.0922789888E13, 3.55687428096E14, 6.402373705728E15, 1.21645100408832E17, 2.43290200817664E18, 5.109094217170944E19, 1.1240007277776077E21};
    private static final double[] NEMES_GAMMA_COEFF = new double[]{1.0, 0.0, 0.08333333333333333, 0.0, 6.944444444444445E-4, 0.0, 6.586199294532628E-4, 0.0, -5.328781782774838E-4, 0.0, 7.927858870060838E-4, 0.0, -0.0018475818932203302, 0.0, 0.006250678247849418, 0.0, -0.02901710246301151, 0.0, 0.1771845724249131, 0.0, -1.3774768170399354};

    public static double chebylevSerie(double x, double[] coef) {
        double b1 = 0.0;
        double b0 = 0.0;
        double b2 = 0.0;
        double twox = 2.0 * x;
        for (int i = coef.length - 1; i >= 0; --i) {
            b2 = b1;
            b1 = b0;
            b0 = twox * b1 - b2 + coef[i];
        }
        return 0.5 * (b0 - b2);
    }

    public static double sign(double x, double y) {
        double abs = x < 0.0 ? -x : x;
        return y < 0.0 ? -abs : abs;
    }

    public static double nemes_gamma(double x) {
        double int_part = (int)x;
        if (x - int_part == 0.0 && 0.0 < int_part && int_part <= (double)FACTORIAL.length) {
            return FACTORIAL[(int)int_part - 1];
        }
        NemesLogGamma l = new NemesLogGamma(x);
        return l.sign * Math.exp(l.value);
    }

    public static class NemesLogGamma {
        public final double value;
        public final double sign;

        public NemesLogGamma(double x) {
            if (Double.isInfinite(x)) {
                this.value = Double.POSITIVE_INFINITY;
                this.sign = 1.0;
                return;
            }
            if (Double.isNaN(x)) {
                this.value = Double.NaN;
                this.sign = 1.0;
                return;
            }
            double int_part = (int)x;
            this.sign = NemesLogGamma.signum(x, int_part);
            if (x - int_part == 0.0 && 0.0 < int_part && int_part <= (double)FACTORIAL.length) {
                this.value = Math.log(FACTORIAL[(int)int_part - 1]);
            } else if (x < 10.0) {
                double rising_factorial = 1.0;
                int i = 0;
                while ((double)i < (double)((int)Math.abs(x)) - int_part + 10.0) {
                    rising_factorial *= x + (double)i;
                    ++i;
                }
                NemesLogGamma l = new NemesLogGamma(x + (double)((int)Math.abs(x)) - int_part + 10.0);
                this.value = l.value - Math.log(Math.abs(rising_factorial));
            } else {
                double temp = 0.0;
                for (int i = 0; i < NEMES_GAMMA_COEFF.length; ++i) {
                    temp += NEMES_GAMMA_COEFF[i] * 1.0 / Math.pow(x, i);
                }
                this.value = x * (Math.log(x) - 1.0 + Math.log(temp)) + (Math.log(2.0) + Math.log(Math.PI) - Math.log(x)) / 2.0;
            }
        }

        private static int signum(double x, double int_part) {
            return int_part % 2.0 == 0.0 && x - int_part != 0.0 && x < 0.0 || NemesLogGamma.negZero(x) ? -1 : 1;
        }

        private static boolean negZero(double x) {
            return x == 0.0 && Double.doubleToRawLongBits(x) != 0L;
        }
    }

    protected static abstract class SimpleDyadicMathNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        protected IsANode isANode = IsANodeGen.create(null, null);
        @Node.Child
        protected ToFNode floatANode = ToFNode.create();
        @Node.Child
        protected ToFNode floatBNode = ToFNode.create();
        protected final BranchProfile exceptionProfile = BranchProfile.create();

        protected SimpleDyadicMathNode() {
        }

        protected double doFunction(double a, double b) {
            throw new UnsupportedOperationException();
        }

        @Specialization
        public double function(int a, int b) {
            return this.doFunction(a, b);
        }

        @Specialization
        public double function(int a, long b) {
            return this.doFunction(a, b);
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public double function(int a, DynamicObject b) {
            return this.doFunction(a, Layouts.BIGNUM.getValue(b).doubleValue());
        }

        @Specialization
        public double function(int a, double b) {
            return this.doFunction(a, b);
        }

        @Specialization
        public double function(long a, int b) {
            return this.doFunction(a, b);
        }

        @Specialization
        public double function(long a, long b) {
            return this.doFunction(a, b);
        }

        @Specialization(guards={"isRubyBignum(a)"})
        public double function(long a, DynamicObject b) {
            return this.doFunction(a, Layouts.BIGNUM.getValue(b).doubleValue());
        }

        @Specialization
        public double function(long a, double b) {
            return this.doFunction(a, b);
        }

        @Specialization(guards={"isRubyBignum(a)"})
        public double function(DynamicObject a, int b) {
            return this.doFunction(Layouts.BIGNUM.getValue(a).doubleValue(), b);
        }

        @Specialization(guards={"isRubyBignum(a)"})
        public double function(DynamicObject a, long b) {
            return this.doFunction(Layouts.BIGNUM.getValue(a).doubleValue(), b);
        }

        @Specialization(guards={"isRubyBignum(a)", "isRubyBignum(b)"})
        public double function(DynamicObject a, DynamicObject b) {
            return this.doFunction(Layouts.BIGNUM.getValue(a).doubleValue(), Layouts.BIGNUM.getValue(b).doubleValue());
        }

        @Specialization(guards={"isRubyBignum(a)"})
        public double function(DynamicObject a, double b) {
            return this.doFunction(Layouts.BIGNUM.getValue(a).doubleValue(), b);
        }

        @Specialization
        public double function(double a, int b) {
            return this.doFunction(a, b);
        }

        @Specialization
        public double function(double a, long b) {
            return this.doFunction(a, b);
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public double function(double a, DynamicObject b) {
            return this.doFunction(a, Layouts.BIGNUM.getValue(b).doubleValue());
        }

        @Specialization
        public double function(double a, double b) {
            return this.doFunction(a, b);
        }

        @Fallback
        public double function(VirtualFrame frame, Object a, Object b) {
            if (!this.isANode.executeIsA(a, this.coreLibrary().getNumericClass()) || !this.isANode.executeIsA(b, this.coreLibrary().getNumericClass())) {
                this.exceptionProfile.enter();
                throw new RaiseException(this.coreExceptions().typeErrorCantConvertInto(a, "Float", this));
            }
            return this.doFunction(this.floatANode.doDouble(frame, a), this.floatBNode.doDouble(frame, b));
        }
    }

    protected static abstract class SimpleMonadicMathNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private IsANode isANode = IsANodeGen.create(null, null);
        @Node.Child
        private ToFNode toFNode = ToFNode.create();
        protected final BranchProfile exceptionProfile = BranchProfile.create();

        protected SimpleMonadicMathNode() {
        }

        protected double doFunction(double a) {
            throw new UnsupportedOperationException();
        }

        @Specialization
        public double function(int a) {
            return this.doFunction(a);
        }

        @Specialization
        public double function(long a) {
            return this.doFunction(a);
        }

        @Specialization(guards={"isRubyBignum(a)"})
        public double function(DynamicObject a) {
            return this.doFunction(Layouts.BIGNUM.getValue(a).doubleValue());
        }

        @Specialization
        public double function(double a) {
            return this.doFunction(a);
        }

        @Fallback
        public double function(VirtualFrame frame, Object a) {
            if (!this.isANode.executeIsA(a, this.coreLibrary().getNumericClass())) {
                this.exceptionProfile.enter();
                throw new RaiseException(this.coreExceptions().typeErrorCantConvertInto(a, "Float", this));
            }
            return this.doFunction(this.toFNode.doDouble(frame, a));
        }
    }

    @CoreMethod(names={"sqrt"}, isModuleFunction=true, required=1)
    public static abstract class SqrtNode
    extends SimpleMonadicMathNode {
        @Override
        protected double doFunction(double a) {
            return Math.sqrt(a);
        }
    }

    @CoreMethod(names={"tanh"}, isModuleFunction=true, required=1)
    public static abstract class TanHNode
    extends SimpleMonadicMathNode {
        @Override
        protected double doFunction(double a) {
            return Math.tanh(a);
        }
    }

    @CoreMethod(names={"tan"}, isModuleFunction=true, required=1)
    public static abstract class TanNode
    extends SimpleMonadicMathNode {
        @Override
        protected double doFunction(double a) {
            return Math.tan(a);
        }
    }

    @CoreMethod(names={"sinh"}, isModuleFunction=true, required=1)
    public static abstract class SinHNode
    extends SimpleMonadicMathNode {
        @Override
        protected double doFunction(double a) {
            return Math.sinh(a);
        }
    }

    @CoreMethod(names={"sin"}, isModuleFunction=true, required=1)
    public static abstract class SinNode
    extends SimpleMonadicMathNode {
        @Override
        protected double doFunction(double a) {
            return Math.sin(a);
        }
    }

    @CoreMethod(names={"log2"}, isModuleFunction=true, required=1)
    public static abstract class Log2Node
    extends SimpleMonadicMathNode {
        private final double LOG2 = Math.log(2.0);

        @Override
        protected double doFunction(double a) {
            if (a < 0.0) {
                this.exceptionProfile.enter();
                throw new RaiseException(this.coreExceptions().mathDomainErrorLog2(this));
            }
            return Math.log(a) / this.LOG2;
        }
    }

    @CoreMethod(names={"log10"}, isModuleFunction=true, required=1)
    public static abstract class Log10Node
    extends SimpleMonadicMathNode {
        @Override
        protected double doFunction(double a) {
            if (a < 0.0) {
                this.exceptionProfile.enter();
                throw new RaiseException(this.coreExceptions().mathDomainErrorLog10(this));
            }
            return Math.log10(a);
        }
    }

    @CoreMethod(names={"log"}, isModuleFunction=true, required=1, optional=1)
    public static abstract class LogNode
    extends SimpleDyadicMathNode {
        @Specialization
        public double function(int a, NotProvided b) {
            return this.doFunction(a);
        }

        @Specialization
        public double function(long a, NotProvided b) {
            return this.doFunction(a);
        }

        @Specialization(guards={"isRubyBignum(a)"})
        public double function(DynamicObject a, NotProvided b) {
            return this.doFunction(Layouts.BIGNUM.getValue(a).doubleValue());
        }

        @Specialization
        public double function(double a, NotProvided b) {
            return this.doFunction(a);
        }

        @Specialization
        public double function(VirtualFrame frame, Object a, NotProvided b, @Cached(value="create()") ToFNode toFNode) {
            if (!this.isANode.executeIsA(a, this.coreLibrary().getNumericClass())) {
                this.exceptionProfile.enter();
                throw new RaiseException(this.coreExceptions().typeErrorCantConvertInto(a, "Float", this));
            }
            return this.doFunction(toFNode.doDouble(frame, a));
        }

        private double doFunction(double a) {
            if (a < 0.0) {
                this.exceptionProfile.enter();
                throw new RaiseException(this.coreExceptions().mathDomainErrorLog(this));
            }
            return Math.log(a);
        }

        @Override
        protected double doFunction(double a, double b) {
            if (a < 0.0) {
                this.exceptionProfile.enter();
                throw new RaiseException(this.coreExceptions().mathDomainErrorLog(this));
            }
            return Math.log(a) / Math.log(b);
        }
    }

    @CoreMethod(names={"lgamma"}, isModuleFunction=true, required=1)
    public static abstract class LGammaNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private IsANode isANode = IsANodeGen.create(null, null);
        @Node.Child
        private ToFNode toFNode = ToFNode.create();
        private final BranchProfile exceptionProfile = BranchProfile.create();

        @Specialization
        public DynamicObject lgamma(int a) {
            return this.lgamma((double)a);
        }

        @Specialization
        public DynamicObject lgamma(long a) {
            return this.lgamma((double)a);
        }

        @Specialization(guards={"isRubyBignum(a)"})
        public DynamicObject lgamma(DynamicObject a) {
            return this.lgamma(Layouts.BIGNUM.getValue(a).doubleValue());
        }

        @Specialization
        public DynamicObject lgamma(double a) {
            if (a < 0.0 && Double.isInfinite(a)) {
                this.exceptionProfile.enter();
                throw new RaiseException(this.coreExceptions().mathDomainErrorLog2(this));
            }
            NemesLogGamma l = new NemesLogGamma(a);
            return this.createArray(new Object[]{l.value, l.sign}, 2);
        }

        @Fallback
        public DynamicObject lgamma(VirtualFrame frame, Object a) {
            if (!this.isANode.executeIsA(a, this.coreLibrary().getNumericClass())) {
                this.exceptionProfile.enter();
                throw new RaiseException(this.coreExceptions().typeErrorCantConvertInto(a, "Float", this));
            }
            return this.lgamma(this.toFNode.doDouble(frame, a));
        }
    }

    @Primitive(name="math_ldexp", needsSelf=false)
    public static abstract class LdexpNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public double ldexp(double a, int b) {
            return a * Math.pow(2.0, b);
        }

        @Fallback
        public Object ldexp(Object a, Object b) {
            return FAILURE;
        }
    }

    @CoreMethod(names={"hypot"}, isModuleFunction=true, required=2)
    public static abstract class HypotNode
    extends SimpleDyadicMathNode {
        @Override
        protected double doFunction(double a, double b) {
            return Math.hypot(a, b);
        }
    }

    @CoreMethod(names={"gamma"}, isModuleFunction=true, required=1)
    public static abstract class GammaNode
    extends SimpleMonadicMathNode {
        @Override
        protected double doFunction(double a) {
            if (a == -1.0) {
                this.exceptionProfile.enter();
                throw new RaiseException(this.coreExceptions().mathDomainErrorGamma(this));
            }
            if (Double.isNaN(a)) {
                return Double.NaN;
            }
            if (Double.isInfinite(a)) {
                if (a > 0.0) {
                    return Double.POSITIVE_INFINITY;
                }
                this.exceptionProfile.enter();
                throw new RaiseException(this.coreExceptions().mathDomainErrorGamma(this));
            }
            double result = MathNodes.nemes_gamma(a);
            if (Double.isInfinite(result)) {
                result = a < 0.0 ? Double.NaN : (a == 0.0 && 1.0 / a < 0.0 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
            }
            if (Double.isNaN(a)) {
                this.exceptionProfile.enter();
                throw new RaiseException(this.coreExceptions().mathDomainErrorGamma(this));
            }
            return result;
        }
    }

    @Primitive(name="math_frexp", needsSelf=false)
    public static abstract class FrExpNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public DynamicObject frexp(double a) {
            double mantissa = a;
            int sign = 1;
            long exponent = 0L;
            if (!Double.isInfinite(mantissa) && mantissa != 0.0) {
                if (mantissa < 0.0) {
                    mantissa = -mantissa;
                    sign = -1;
                }
                while (mantissa < 0.5) {
                    mantissa *= 2.0;
                    --exponent;
                }
                while (mantissa >= 1.0) {
                    mantissa *= 0.5;
                    ++exponent;
                }
            }
            return this.createArray(new Object[]{(double)sign * mantissa, exponent}, 2);
        }

        @Fallback
        public Object frexp(Object a) {
            return FAILURE;
        }
    }

    @CoreMethod(names={"exp"}, isModuleFunction=true, required=1)
    public static abstract class ExpNode
    extends SimpleMonadicMathNode {
        @Override
        protected double doFunction(double a) {
            return Math.exp(a);
        }
    }

    @CoreMethod(names={"erfc"}, isModuleFunction=true, required=1)
    public static abstract class ErfcNode
    extends SimpleMonadicMathNode {
        @Override
        public double doFunction(double a) {
            return ErfcNode.erfc(a);
        }

        public static double erfc(double a) {
            double y = Math.abs(a);
            if (a <= -6.013687357) {
                return 2.0;
            }
            if (y < 1.49012E-8) {
                return 1.0 - 2.0 * a / 1.772453850905516;
            }
            double ysq = y * y;
            if (y < 1.0) {
                return 1.0 - a * (1.0 + MathNodes.chebylevSerie(2.0 * ysq - 1.0, ERFC_COEF));
            }
            if (y <= 4.0) {
                double result = Math.exp(-ysq) / y * (0.5 + MathNodes.chebylevSerie((8.0 / ysq - 5.0) / 3.0, ERFC2_COEF));
                if (a < 0.0) {
                    result = 2.0 - result;
                }
                if (a < 0.0) {
                    result = 2.0 - result;
                }
                if (a < 0.0) {
                    result = 2.0 - result;
                }
                return result;
            }
            double result = Math.exp(-ysq) / y * (0.5 + MathNodes.chebylevSerie(8.0 / ysq - 1.0, ERFCC_COEF));
            if (a < 0.0) {
                result = 2.0 - result;
            }
            return result;
        }
    }

    @CoreMethod(names={"erf"}, isModuleFunction=true, required=1)
    public static abstract class ErfNode
    extends SimpleMonadicMathNode {
        @Override
        protected double doFunction(double a) {
            double y = Math.abs(a);
            if (y <= 1.49012E-8) {
                return 2.0 * a / 1.772453850905516;
            }
            if (y <= 1.0) {
                return a * (1.0 + MathNodes.chebylevSerie(2.0 * a * a - 1.0, ERFC_COEF));
            }
            if (y < 6.013687357) {
                return MathNodes.sign(1.0 - ErfcNode.erfc(y), a);
            }
            if (Double.isNaN(y)) {
                return Double.NaN;
            }
            return MathNodes.sign(1.0, a);
        }
    }

    @CoreMethod(names={"cosh"}, isModuleFunction=true, required=1)
    public static abstract class CosHNode
    extends SimpleMonadicMathNode {
        @Override
        protected double doFunction(double a) {
            return Math.cosh(a);
        }
    }

    @CoreMethod(names={"cos"}, isModuleFunction=true, required=1)
    public static abstract class CosNode
    extends SimpleMonadicMathNode {
        @Override
        protected double doFunction(double a) {
            return Math.cos(a);
        }
    }

    @CoreMethod(names={"cbrt"}, isModuleFunction=true, required=1)
    public static abstract class CbRtNode
    extends SimpleMonadicMathNode {
        @Override
        protected double doFunction(double a) {
            return Math.cbrt(a);
        }
    }

    @CoreMethod(names={"atanh"}, isModuleFunction=true, required=1)
    public static abstract class ATanHNode
    extends SimpleMonadicMathNode {
        @Override
        protected double doFunction(double a) {
            if (a < -1.0 || a > 1.0) {
                this.exceptionProfile.enter();
                throw new RaiseException(this.coreExceptions().mathDomainErrorAtanh(this));
            }
            double y = Math.abs(a);
            if (Double.isNaN(a)) {
                return Double.NaN;
            }
            if (y < 1.82501E-8) {
                return a;
            }
            if (y <= 0.5) {
                return a * (1.0 + MathNodes.chebylevSerie(8.0 * a * a - 1.0, ATANH_COEF));
            }
            if (y < 1.0) {
                return 0.5 * Math.log((1.0 + a) / (1.0 - a));
            }
            if (y == 1.0) {
                return a * Double.POSITIVE_INFINITY;
            }
            return Double.NaN;
        }
    }

    @CoreMethod(names={"atan2"}, isModuleFunction=true, required=2)
    public static abstract class ATan2Node
    extends SimpleDyadicMathNode {
        @Override
        protected double doFunction(double a, double b) {
            return Math.atan2(a, b);
        }
    }

    @CoreMethod(names={"atan"}, isModuleFunction=true, required=1)
    public static abstract class ATanNode
    extends SimpleMonadicMathNode {
        @Override
        protected double doFunction(double a) {
            return Math.atan(a);
        }
    }

    @CoreMethod(names={"asinh"}, isModuleFunction=true, required=1)
    public static abstract class ASinHNode
    extends SimpleMonadicMathNode {
        @Override
        protected double doFunction(double a) {
            double y = Math.abs(a);
            if (Double.isNaN(a)) {
                return Double.NaN;
            }
            if (y <= 1.05367E-8) {
                return a;
            }
            if (y <= 1.0) {
                return a * (1.0 + MathNodes.chebylevSerie(2.0 * a * a - 1.0, ASINH_COEF));
            }
            if (y < 9.490626562E7) {
                return Math.log(a + Math.sqrt(a * a + 1.0));
            }
            double result = 0.6931471805599453 + Math.log(y);
            if (a < 0.0) {
                result *= -1.0;
            }
            return result;
        }
    }

    @CoreMethod(names={"asin"}, isModuleFunction=true, required=1)
    public static abstract class ASinNode
    extends SimpleMonadicMathNode {
        @Override
        protected double doFunction(double a) {
            if (a < -1.0 || a > 1.0) {
                this.exceptionProfile.enter();
                throw new RaiseException(this.coreExceptions().mathDomainErrorAsin(this));
            }
            return Math.asin(a);
        }
    }

    @CoreMethod(names={"acosh"}, isModuleFunction=true, required=1)
    public static abstract class ACosHNode
    extends SimpleMonadicMathNode {
        @Override
        protected double doFunction(double a) {
            if (Double.isNaN(a)) {
                return Double.NaN;
            }
            if (a < 1.0) {
                this.exceptionProfile.enter();
                throw new RaiseException(this.coreExceptions().mathDomainErrorAcosh(this));
            }
            if (a < 9.490626562E7) {
                return Math.log(a + Math.sqrt(a * a - 1.0));
            }
            return 0.6931471805599453 + Math.log(a);
        }
    }

    @CoreMethod(names={"acos"}, isModuleFunction=true, required=1)
    public static abstract class ACosNode
    extends SimpleMonadicMathNode {
        @Override
        protected double doFunction(double a) {
            if (a < -1.0 || a > 1.0) {
                this.exceptionProfile.enter();
                throw new RaiseException(this.coreExceptions().mathDomainErrorAcos(this));
            }
            return Math.acos(a);
        }
    }
}

