/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rope;

import org.jcodings.Encoding;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.core.rope.LeafRope;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.string.ByteList;

public class RopeBuffer
extends LeafRope {
    private final ByteList byteList;

    protected RopeBuffer(byte[] bytes, Encoding encoding, CodeRange codeRange, boolean singleByteOptimizable, int characterLength) {
        super(bytes, encoding, codeRange, singleByteOptimizable, characterLength);
        this.byteList = new ByteList(bytes, encoding, false);
    }

    public RopeBuffer(Rope original) {
        this(original.getBytesCopy(), original.getEncoding(), original.getCodeRange(), original.isSingleByteOptimizable(), original.characterLength());
    }

    public RopeBuffer(ByteList byteList, CodeRange codeRange, boolean singleByteOptimizable, int characterLength) {
        super(byteList.unsafeBytes(), byteList.getEncoding(), codeRange, singleByteOptimizable, characterLength);
        this.byteList = byteList;
    }

    @Override
    public Rope withEncoding(Encoding newEncoding, CodeRange newCodeRange) {
        this.byteList.setEncoding(newEncoding);
        return this;
    }

    @Override
    public byte getByteSlow(int index) {
        return (byte)this.byteList.get(index);
    }

    public ByteList getByteList() {
        return this.byteList;
    }

    @Override
    public String toString() {
        return this.byteList.toString();
    }

    public RopeBuffer dup() {
        return new RopeBuffer(this.byteList.dup(), this.getCodeRange(), this.isSingleByteOptimizable(), this.characterLength());
    }
}

