/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetFieldImpl;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.synthetic.SyntheticJavaPropertyDescriptor;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u001aH\u0016\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/ConstAndJvmFieldPropertiesLowering;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "()V", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "substituteGetter", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrGetFieldImpl;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyGetterDescriptor;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "substituteSetter", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrSetFieldImpl;", "Lorg/jetbrains/kotlin/descriptors/PropertyAccessorDescriptor;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "visitDeclaration", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "visitMemberAccess", "Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "visitProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "kotlin-compiler"})
public final class ConstAndJvmFieldPropertiesLowering
extends IrElementTransformerVoid
implements FileLoweringPass {
    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull(irFile, "irFile");
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, this);
    }

    @Override
    @NotNull
    public IrStatement visitDeclaration(@NotNull IrDeclaration declaration) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        return super.visitDeclaration(declaration);
    }

    @Override
    @NotNull
    public IrStatement visitProperty(@NotNull IrProperty declaration) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        if (JvmCodegenUtil.isConstOrHasJvmFieldAnnotation(declaration.getDescriptor())) {
            declaration.setGetter(null);
            declaration.setSetter(null);
        }
        return super.visitProperty(declaration);
    }

    @Override
    @NotNull
    public IrExpression visitMemberAccess(@NotNull IrMemberAccessExpression expression) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        return super.visitMemberAccess(expression);
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        CallableDescriptor descriptor2 = expression.getDescriptor();
        if (!(descriptor2 instanceof PropertyAccessorDescriptor)) {
            return super.visitCall(expression);
        }
        PropertyDescriptor property = ((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty();
        if (JvmCodegenUtil.isConstOrHasJvmFieldAnnotation(property)) {
            if (descriptor2 instanceof PropertyGetterDescriptor) {
                return this.substituteGetter((PropertyGetterDescriptor)descriptor2, expression);
            }
            return this.substituteSetter((PropertyAccessorDescriptor)descriptor2, expression);
        }
        if (property instanceof SyntheticJavaPropertyDescriptor) {
            expression.setDispatchReceiver(expression.getExtensionReceiver());
            expression.setExtensionReceiver(null);
        }
        return super.visitCall(expression);
    }

    private final IrSetFieldImpl substituteSetter(PropertyAccessorDescriptor descriptor2, IrCall expression) {
        int n = expression.getStartOffset();
        int n2 = expression.getEndOffset();
        PropertyDescriptor propertyDescriptor = descriptor2.getCorrespondingProperty();
        Intrinsics.checkExpressionValueIsNotNull(propertyDescriptor, "descriptor.correspondingProperty");
        IrExpression irExpression = expression.getDispatchReceiver();
        IrExpression irExpression2 = expression.getValueArgument(CollectionsKt.getLastIndex(descriptor2.getValueParameters()));
        if (irExpression2 == null) {
            Intrinsics.throwNpe();
        }
        return new IrSetFieldImpl(n, n2, propertyDescriptor, irExpression, irExpression2, expression.getOrigin(), expression.getSuperQualifier());
    }

    private final IrGetFieldImpl substituteGetter(PropertyGetterDescriptor descriptor2, IrCall expression) {
        int n = expression.getStartOffset();
        int n2 = expression.getEndOffset();
        PropertyDescriptor propertyDescriptor = descriptor2.getCorrespondingProperty();
        Intrinsics.checkExpressionValueIsNotNull(propertyDescriptor, "descriptor.correspondingProperty");
        return new IrGetFieldImpl(n, n2, propertyDescriptor, expression.getDispatchReceiver(), expression.getOrigin(), expression.getSuperQualifier());
    }
}

