/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.js;

import com.google.common.base.Joiner;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.backend.common.output.OutputFileCollection;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.UtilsKt;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.output.outputUtils.OutputUtilsKt;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.ContentRootsKt;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.js.analyze.TopDownAnalyzerFacadeForJS;
import org.jetbrains.kotlin.js.analyzer.JsAnalysisResult;
import org.jetbrains.kotlin.js.config.EcmaVersion;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.config.LibrarySourcesConfig;
import org.jetbrains.kotlin.js.facade.K2JSTranslator;
import org.jetbrains.kotlin.js.facade.MainCallParameters;
import org.jetbrains.kotlin.js.facade.TranslationResult;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.serialization.js.ModuleKind;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;
import org.jetbrains.kotlin.utils.PathUtil;

public class K2JSCompiler
extends CLICompiler<K2JSCompilerArguments> {
    private static final Map<String, ModuleKind> moduleKindMap = new HashMap<String, ModuleKind>();

    public static void main(String ... args) {
        K2JSCompiler.doMain(new K2JSCompiler(), args);
    }

    @Override
    @NotNull
    protected K2JSCompilerArguments createArguments() {
        K2JSCompilerArguments k2JSCompilerArguments = new K2JSCompilerArguments();
        if (k2JSCompilerArguments == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/js/K2JSCompiler", "createArguments"));
        }
        return k2JSCompilerArguments;
    }

    @Override
    @NotNull
    protected ExitCode doExecute(@NotNull K2JSCompilerArguments arguments2, @NotNull CompilerConfiguration configuration, @NotNull Disposable rootDisposable) {
        TranslationResult translationResult;
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/cli/js/K2JSCompiler", "doExecute"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/kotlin/cli/js/K2JSCompiler", "doExecute"));
        }
        if (rootDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootDisposable", "org/jetbrains/kotlin/cli/js/K2JSCompiler", "doExecute"));
        }
        final MessageCollector messageCollector = configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        if (arguments2.freeArgs.isEmpty()) {
            if (arguments2.version) {
                ExitCode exitCode = ExitCode.OK;
                if (exitCode == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/js/K2JSCompiler", "doExecute"));
                }
                return exitCode;
            }
            messageCollector.report(CompilerMessageSeverity.ERROR, "Specify at least one source file or directory", CompilerMessageLocation.NO_LOCATION);
            ExitCode exitCode = ExitCode.COMPILATION_ERROR;
            if (exitCode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/js/K2JSCompiler", "doExecute"));
            }
            return exitCode;
        }
        ContentRootsKt.addKotlinSourceRoots(configuration, arguments2.freeArgs);
        KotlinCoreEnvironment environmentForJS = KotlinCoreEnvironment.createForProduction(rootDisposable, configuration, EnvironmentConfigFiles.JS_CONFIG_FILES);
        Project project = environmentForJS.getProject();
        List<KtFile> sourcesFiles = environmentForJS.getSourceFiles();
        environmentForJS.getConfiguration().put(CLIConfigurationKeys.ALLOW_KOTLIN_PACKAGE, arguments2.allowKotlinPackage);
        if (!UtilsKt.checkKotlinPackageUsage(environmentForJS, sourcesFiles)) {
            ExitCode exitCode = ExitCode.COMPILATION_ERROR;
            if (exitCode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/js/K2JSCompiler", "doExecute"));
            }
            return exitCode;
        }
        if (arguments2.outputFile == null) {
            messageCollector.report(CompilerMessageSeverity.ERROR, "Specify output file via -output", CompilerMessageLocation.NO_LOCATION);
            ExitCode exitCode = ExitCode.COMPILATION_ERROR;
            if (exitCode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/js/K2JSCompiler", "doExecute"));
            }
            return exitCode;
        }
        if (messageCollector.hasErrors()) {
            ExitCode exitCode = ExitCode.COMPILATION_ERROR;
            if (exitCode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/js/K2JSCompiler", "doExecute"));
            }
            return exitCode;
        }
        if (sourcesFiles.isEmpty()) {
            messageCollector.report(CompilerMessageSeverity.ERROR, "No source files", CompilerMessageLocation.NO_LOCATION);
            ExitCode exitCode = ExitCode.COMPILATION_ERROR;
            if (exitCode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/js/K2JSCompiler", "doExecute"));
            }
            return exitCode;
        }
        if (arguments2.verbose) {
            K2JSCompiler.reportCompiledSourcesList(messageCollector, sourcesFiles);
        }
        File outputFile = new File(arguments2.outputFile);
        configuration.put(CommonConfigurationKeys.MODULE_NAME, FileUtil.getNameWithoutExtension(outputFile));
        LibrarySourcesConfig config = new LibrarySourcesConfig(project, configuration);
        if (((JsConfig)config).checkLibFilesAndReportErrors(new JsConfig.Reporter(){

            @Override
            public void error(@NotNull String message) {
                if (message == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/cli/js/K2JSCompiler$1", "error"));
                }
                messageCollector.report(CompilerMessageSeverity.ERROR, message, CompilerMessageLocation.NO_LOCATION);
            }

            @Override
            public void warning(@NotNull String message) {
                if (message == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/cli/js/K2JSCompiler$1", "warning"));
                }
                messageCollector.report(CompilerMessageSeverity.STRONG_WARNING, message, CompilerMessageLocation.NO_LOCATION);
            }
        })) {
            ExitCode exitCode = ExitCode.COMPILATION_ERROR;
            if (exitCode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/js/K2JSCompiler", "doExecute"));
            }
            return exitCode;
        }
        AnalyzerWithCompilerReport analyzerWithCompilerReport = K2JSCompiler.analyzeAndReportErrors(messageCollector, sourcesFiles, config);
        if (analyzerWithCompilerReport.hasErrors()) {
            ExitCode exitCode = ExitCode.COMPILATION_ERROR;
            if (exitCode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/js/K2JSCompiler", "doExecute"));
            }
            return exitCode;
        }
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        AnalysisResult analysisResult = analyzerWithCompilerReport.getAnalysisResult();
        assert (analysisResult instanceof JsAnalysisResult) : "analysisResult should be instance of JsAnalysisResult, but " + analysisResult;
        JsAnalysisResult jsAnalysisResult = (JsAnalysisResult)analysisResult;
        File outputPrefixFile = null;
        if (arguments2.outputPrefix != null && !(outputPrefixFile = new File(arguments2.outputPrefix)).exists()) {
            messageCollector.report(CompilerMessageSeverity.ERROR, "Output prefix file '" + arguments2.outputPrefix + "' not found", CompilerMessageLocation.NO_LOCATION);
            ExitCode exitCode = ExitCode.COMPILATION_ERROR;
            if (exitCode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/js/K2JSCompiler", "doExecute"));
            }
            return exitCode;
        }
        File outputPostfixFile = null;
        if (arguments2.outputPostfix != null && !(outputPostfixFile = new File(arguments2.outputPostfix)).exists()) {
            messageCollector.report(CompilerMessageSeverity.ERROR, "Output postfix file '" + arguments2.outputPostfix + "' not found", CompilerMessageLocation.NO_LOCATION);
            ExitCode exitCode = ExitCode.COMPILATION_ERROR;
            if (exitCode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/js/K2JSCompiler", "doExecute"));
            }
            return exitCode;
        }
        MainCallParameters mainCallParameters = K2JSCompiler.createMainCallParameters(arguments2.main);
        K2JSTranslator translator = new K2JSTranslator(config);
        try {
            translationResult = translator.translate(sourcesFiles, mainCallParameters, jsAnalysisResult);
        }
        catch (Exception e) {
            throw ExceptionUtilsKt.rethrow(e);
        }
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        AnalyzerWithCompilerReport.Companion.reportDiagnostics(translationResult.getDiagnostics(), messageCollector);
        if (!(translationResult instanceof TranslationResult.Success)) {
            ExitCode exitCode = ExitCode.COMPILATION_ERROR;
            if (exitCode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/js/K2JSCompiler", "doExecute"));
            }
            return exitCode;
        }
        TranslationResult.Success successResult = (TranslationResult.Success)translationResult;
        OutputFileCollection outputFiles = successResult.getOutputFiles(outputFile, outputPrefixFile, outputPostfixFile);
        if (outputFile.isDirectory()) {
            messageCollector.report(CompilerMessageSeverity.ERROR, "Cannot open output file '" + outputFile.getPath() + "': is a directory", CompilerMessageLocation.NO_LOCATION);
            ExitCode exitCode = ExitCode.COMPILATION_ERROR;
            if (exitCode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/js/K2JSCompiler", "doExecute"));
            }
            return exitCode;
        }
        File outputDir2 = outputFile.getParentFile();
        if (outputDir2 == null) {
            outputDir2 = outputFile.getAbsoluteFile().getParentFile();
        }
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        OutputUtilsKt.writeAll(outputFiles, outputDir2, messageCollector);
        ExitCode exitCode = ExitCode.OK;
        if (exitCode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/js/K2JSCompiler", "doExecute"));
        }
        return exitCode;
    }

    private static void reportCompiledSourcesList(@NotNull MessageCollector messageCollector, @NotNull List<KtFile> sourceFiles2) {
        if (messageCollector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageCollector", "org/jetbrains/kotlin/cli/js/K2JSCompiler", "reportCompiledSourcesList"));
        }
        if (sourceFiles2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFiles", "org/jetbrains/kotlin/cli/js/K2JSCompiler", "reportCompiledSourcesList"));
        }
        List<String> fileNames = ContainerUtil.map(sourceFiles2, new Function<KtFile, String>(){

            @Override
            public String fun(@Nullable KtFile file2) {
                assert (file2 != null);
                VirtualFile virtualFile = file2.getVirtualFile();
                if (virtualFile != null) {
                    return FileUtil.toSystemDependentName(virtualFile.getPath());
                }
                return file2.getName() + "(no virtual file)";
            }
        });
        messageCollector.report(CompilerMessageSeverity.LOGGING, "Compiling source files: " + Joiner.on(", ").join(fileNames), CompilerMessageLocation.NO_LOCATION);
    }

    private static AnalyzerWithCompilerReport analyzeAndReportErrors(@NotNull MessageCollector messageCollector, final @NotNull List<KtFile> sources, final @NotNull JsConfig config) {
        if (messageCollector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageCollector", "org/jetbrains/kotlin/cli/js/K2JSCompiler", "analyzeAndReportErrors"));
        }
        if (sources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sources", "org/jetbrains/kotlin/cli/js/K2JSCompiler", "analyzeAndReportErrors"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/kotlin/cli/js/K2JSCompiler", "analyzeAndReportErrors"));
        }
        AnalyzerWithCompilerReport analyzerWithCompilerReport = new AnalyzerWithCompilerReport(messageCollector);
        analyzerWithCompilerReport.analyzeAndReport(sources, new AnalyzerWithCompilerReport.Analyzer(){

            @Override
            @NotNull
            public AnalysisResult analyze() {
                JsAnalysisResult jsAnalysisResult = TopDownAnalyzerFacadeForJS.analyzeFiles(sources, config);
                if (jsAnalysisResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/js/K2JSCompiler$3", "analyze"));
                }
                return jsAnalysisResult;
            }

            @Override
            public void reportEnvironmentErrors() {
            }
        });
        return analyzerWithCompilerReport;
    }

    @Override
    protected void setupPlatformSpecificArgumentsAndServices(@NotNull CompilerConfiguration configuration, @NotNull K2JSCompilerArguments arguments2, @NotNull Services services) {
        ModuleKind moduleKind;
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/kotlin/cli/js/K2JSCompiler", "setupPlatformSpecificArgumentsAndServices"));
        }
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/cli/js/K2JSCompiler", "setupPlatformSpecificArgumentsAndServices"));
        }
        if (services == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "services", "org/jetbrains/kotlin/cli/js/K2JSCompiler", "setupPlatformSpecificArgumentsAndServices"));
        }
        MessageCollector messageCollector = configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        if (arguments2.target != null) assert (arguments2.target == "v5") : "Unsupported ECMA version: " + arguments2.target;
        configuration.put(JSConfigurationKeys.TARGET, EcmaVersion.defaultVersion());
        if (arguments2.sourceMap) {
            configuration.put(JSConfigurationKeys.SOURCE_MAP, true);
        }
        if (arguments2.metaInfo) {
            configuration.put(JSConfigurationKeys.META_INFO, true);
        }
        SmartList<String> libraries = new SmartList<String>();
        if (!arguments2.noStdlib) {
            libraries.add(0, PathUtil.getKotlinPathsForCompiler().getJsStdLibJarPath().getAbsolutePath());
        }
        if (arguments2.libraries != null) {
            ContainerUtil.addAllNotNull(libraries, arguments2.libraries.split(File.pathSeparator));
        }
        configuration.put(JSConfigurationKeys.LIBRARIES, libraries);
        String moduleKindName = arguments2.moduleKind;
        ModuleKind moduleKind2 = moduleKind = moduleKindName != null ? moduleKindMap.get(moduleKindName) : ModuleKind.PLAIN;
        if (moduleKind == null) {
            messageCollector.report(CompilerMessageSeverity.ERROR, "Unknown module kind: " + moduleKindName + ". " + "Valid values are: plain, amd, commonjs, umd", CompilerMessageLocation.NO_LOCATION);
        }
        configuration.put(JSConfigurationKeys.MODULE_KIND, moduleKind);
    }

    private static MainCallParameters createMainCallParameters(String main2) {
        if ("noCall".equals(main2)) {
            return MainCallParameters.noCall();
        }
        return MainCallParameters.mainWithoutArguments();
    }

    static {
        moduleKindMap.put("plain", ModuleKind.PLAIN);
        moduleKindMap.put("commonjs", ModuleKind.COMMON_JS);
        moduleKindMap.put("amd", ModuleKind.AMD);
        moduleKindMap.put("umd", ModuleKind.UMD);
    }
}

