/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.repl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import com.intellij.testFramework.LightVirtualFile;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.repl.ReplCheckResult;
import org.jetbrains.kotlin.cli.common.repl.ReplCodeLine;
import org.jetbrains.kotlin.cli.common.repl.ReplUtilKt;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.repl.GenericReplCheckerKt;
import org.jetbrains.kotlin.cli.jvm.repl.messages.DiagnosticMessageHolder;
import org.jetbrains.kotlin.cli.jvm.repl.messages.ReplTerminalDiagnosticMessageHolder;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.CompilerConfigurationKey;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.parsing.KotlinParserDefinition;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.script.KotlinScriptDefinition;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001&B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u0006\u0010$\u001a\u00020%R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u000e8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/repl/GenericReplChecker;", "", "disposable", "Lcom/intellij/openapi/Disposable;", "scriptDefinition", "Lorg/jetbrains/kotlin/script/KotlinScriptDefinition;", "compilerConfiguration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "stateLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "(Lcom/intellij/openapi/Disposable;Lorg/jetbrains/kotlin/script/KotlinScriptDefinition;Lorg/jetbrains/kotlin/config/CompilerConfiguration;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Ljava/util/concurrent/locks/ReentrantReadWriteLock;)V", "_lineState", "Lorg/jetbrains/kotlin/cli/jvm/repl/GenericReplChecker$LineState;", "getCompilerConfiguration", "()Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "environment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "getEnvironment$kotlin_compiler", "()Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "lineState", "getLineState$kotlin_compiler", "()Lorg/jetbrains/kotlin/cli/jvm/repl/GenericReplChecker$LineState;", "psiFileFactory", "Lcom/intellij/psi/impl/PsiFileFactoryImpl;", "getScriptDefinition", "()Lorg/jetbrains/kotlin/script/KotlinScriptDefinition;", "getStateLock", "()Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "check", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCheckResult;", "codeLine", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCodeLine;", "generation", "", "createDiagnosticHolder", "Lorg/jetbrains/kotlin/cli/jvm/repl/messages/ReplTerminalDiagnosticMessageHolder;", "LineState", "kotlin-compiler"})
public class GenericReplChecker {
    @NotNull
    private final KotlinCoreEnvironment environment;
    private final PsiFileFactoryImpl psiFileFactory;
    private LineState _lineState;
    @NotNull
    private final KotlinScriptDefinition scriptDefinition;
    @NotNull
    private final CompilerConfiguration compilerConfiguration;
    @NotNull
    private final ReentrantReadWriteLock stateLock;

    @NotNull
    public final KotlinCoreEnvironment getEnvironment$kotlin_compiler() {
        return this.environment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final LineState getLineState$kotlin_compiler() {
        LineState lineState;
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            lineState = this._lineState;
        }
        finally {
            readLock.unlock();
        }
        return lineState;
    }

    @NotNull
    public final ReplTerminalDiagnosticMessageHolder createDiagnosticHolder() {
        return new ReplTerminalDiagnosticMessageHolder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ReplCheckResult check(@NotNull ReplCodeLine codeLine, long generation) {
        int n;
        Intrinsics.checkParameterIsNotNull(codeLine, "codeLine");
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n2 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n3 = 0;
        int n4 = n2 - 1;
        if (n3 <= n4) {
            do {
                n = ++n3;
                readLock.unlock();
            } while (n3 != n4);
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            String scriptFileName = ReplUtilKt.makeScriptBaseName(codeLine, generation);
            LightVirtualFile lightVirtualFile = new LightVirtualFile(scriptFileName + KotlinParserDefinition.STD_SCRIPT_EXT, KotlinLanguage.INSTANCE, (CharSequence)StringUtil.convertLineSeparators(codeLine.getCode()));
            Object $receiver = lightVirtualFile;
            ((VirtualFile)$receiver).setCharset(CharsetToolkit.UTF8_CHARSET);
            LightVirtualFile virtualFile = lightVirtualFile;
            KtFile ktFile = (KtFile)this.psiFileFactory.trySetupPsiForFile(virtualFile, KotlinLanguage.INSTANCE, true, false);
            if (ktFile == null) {
                $receiver = "Script file not analyzed at line " + codeLine.getNo() + ": " + codeLine.getCode();
                throw (Throwable)new IllegalStateException($receiver.toString());
            }
            KtFile psiFile = ktFile;
            ReplTerminalDiagnosticMessageHolder errorHolder = this.createDiagnosticHolder();
            AnalyzerWithCompilerReport.SyntaxErrorReport syntaxErrorReport = AnalyzerWithCompilerReport.Companion.reportSyntaxErrors((PsiElement)psiFile, errorHolder);
            if (!syntaxErrorReport.isHasErrors()) {
                this._lineState = new LineState(codeLine, psiFile, errorHolder);
            }
            ReplCheckResult replCheckResult = syntaxErrorReport.isHasErrors() && syntaxErrorReport.isAllErrorsAtEof() ? (ReplCheckResult)new ReplCheckResult.Incomplete() : (syntaxErrorReport.isHasErrors() ? (ReplCheckResult)new ReplCheckResult.Error(errorHolder.getRenderedDiagnostics(), null, 2, null) : (ReplCheckResult)new ReplCheckResult.Ok());
            return replCheckResult;
        }
        finally {
            n = 0;
            int n5 = n2 - 1;
            if (n <= n5) {
                do {
                    int n6 = ++n;
                    readLock.lock();
                } while (n != n5);
            }
            writeLock.unlock();
        }
    }

    @NotNull
    public final KotlinScriptDefinition getScriptDefinition() {
        return this.scriptDefinition;
    }

    @NotNull
    public final CompilerConfiguration getCompilerConfiguration() {
        return this.compilerConfiguration;
    }

    @NotNull
    protected final ReentrantReadWriteLock getStateLock() {
        return this.stateLock;
    }

    public GenericReplChecker(@NotNull Disposable disposable, @NotNull KotlinScriptDefinition scriptDefinition2, @NotNull CompilerConfiguration compilerConfiguration, @NotNull MessageCollector messageCollector, @NotNull ReentrantReadWriteLock stateLock) {
        KotlinCoreEnvironment kotlinCoreEnvironment;
        GenericReplChecker $receiver;
        block4: {
            Object object;
            CompilerConfigurationKey<JvmTarget> compilerConfigurationKey;
            CompilerConfiguration compilerConfiguration2;
            block6: {
                block5: {
                    CompilerConfiguration compilerConfiguration3;
                    Intrinsics.checkParameterIsNotNull(disposable, "disposable");
                    Intrinsics.checkParameterIsNotNull(scriptDefinition2, "scriptDefinition");
                    Intrinsics.checkParameterIsNotNull(compilerConfiguration, "compilerConfiguration");
                    Intrinsics.checkParameterIsNotNull(messageCollector, "messageCollector");
                    Intrinsics.checkParameterIsNotNull(stateLock, "stateLock");
                    this.scriptDefinition = scriptDefinition2;
                    this.compilerConfiguration = compilerConfiguration;
                    this.stateLock = stateLock;
                    GenericReplChecker genericReplChecker = this;
                    GenericReplChecker genericReplChecker2 = this;
                    $receiver = genericReplChecker;
                    CompilerConfiguration $receiver2 = compilerConfiguration3 = $receiver.compilerConfiguration;
                    $receiver2.add(JVMConfigurationKeys.SCRIPT_DEFINITIONS, $receiver.scriptDefinition);
                    $receiver2.put(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, messageCollector);
                    $receiver2.put(JVMConfigurationKeys.RETAIN_OUTPUT_IN_MEMORY, true);
                    if ($receiver2.get(JVMConfigurationKeys.JVM_TARGET) != null) break block4;
                    compilerConfiguration2 = $receiver2;
                    compilerConfigurationKey = JVMConfigurationKeys.JVM_TARGET;
                    object = System.getProperty("kotlin.repl.jvm.target");
                    if (object == null) break block5;
                    String string = object;
                    CompilerConfigurationKey<JvmTarget> compilerConfigurationKey2 = compilerConfigurationKey;
                    CompilerConfiguration compilerConfiguration4 = compilerConfiguration2;
                    String it = string;
                    JvmTarget jvmTarget = JvmTarget.Companion.fromString(it);
                    compilerConfiguration2 = compilerConfiguration4;
                    compilerConfigurationKey = compilerConfigurationKey2;
                    object = jvmTarget;
                    if (object != null) break block6;
                }
                object = GenericReplCheckerKt.access$getJavaVersion() >= 65544 ? JvmTarget.JVM_1_8 : JvmTarget.JVM_1_6;
            }
            compilerConfiguration2.put(compilerConfigurationKey, object);
        }
        CompilerConfiguration compilerConfiguration5 = $receiver.compilerConfiguration;
        List<String> list2 = EnvironmentConfigFiles.JVM_CONFIG_FILES;
        Intrinsics.checkExpressionValueIsNotNull(list2, "EnvironmentConfigFiles.JVM_CONFIG_FILES");
        genericReplChecker2.environment = kotlinCoreEnvironment = KotlinCoreEnvironment.Companion.createForProduction(disposable, compilerConfiguration5, list2);
        PsiFileFactory psiFileFactory2 = PsiFileFactory.getInstance(this.environment.getProject());
        if (psiFileFactory2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.impl.PsiFileFactoryImpl");
        }
        this.psiFileFactory = (PsiFileFactoryImpl)psiFileFactory2;
    }

    public /* synthetic */ GenericReplChecker(Disposable disposable, KotlinScriptDefinition kotlinScriptDefinition, CompilerConfiguration compilerConfiguration, MessageCollector messageCollector, ReentrantReadWriteLock reentrantReadWriteLock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            reentrantReadWriteLock = new ReentrantReadWriteLock();
        }
        this(disposable, kotlinScriptDefinition, compilerConfiguration, messageCollector, reentrantReadWriteLock);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/repl/GenericReplChecker$LineState;", "", "codeLine", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCodeLine;", "psiFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "errorHolder", "Lorg/jetbrains/kotlin/cli/jvm/repl/messages/DiagnosticMessageHolder;", "(Lorg/jetbrains/kotlin/cli/common/repl/ReplCodeLine;Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/cli/jvm/repl/messages/DiagnosticMessageHolder;)V", "getCodeLine", "()Lorg/jetbrains/kotlin/cli/common/repl/ReplCodeLine;", "getErrorHolder", "()Lorg/jetbrains/kotlin/cli/jvm/repl/messages/DiagnosticMessageHolder;", "getPsiFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "kotlin-compiler"})
    public static final class LineState {
        @NotNull
        private final ReplCodeLine codeLine;
        @NotNull
        private final KtFile psiFile;
        @NotNull
        private final DiagnosticMessageHolder errorHolder;

        @NotNull
        public final ReplCodeLine getCodeLine() {
            return this.codeLine;
        }

        @NotNull
        public final KtFile getPsiFile() {
            return this.psiFile;
        }

        @NotNull
        public final DiagnosticMessageHolder getErrorHolder() {
            return this.errorHolder;
        }

        public LineState(@NotNull ReplCodeLine codeLine, @NotNull KtFile psiFile, @NotNull DiagnosticMessageHolder errorHolder) {
            Intrinsics.checkParameterIsNotNull(codeLine, "codeLine");
            Intrinsics.checkParameterIsNotNull(psiFile, "psiFile");
            Intrinsics.checkParameterIsNotNull(errorHolder, "errorHolder");
            this.codeLine = codeLine;
            this.psiFile = psiFile;
            this.errorHolder = errorHolder;
        }
    }
}

