/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm;

import edu.berkeley.nlp.lm.AbstractArrayEncodedNgramLanguageModel;
import edu.berkeley.nlp.lm.ArrayEncodedNgramLanguageModel;
import edu.berkeley.nlp.lm.ConfigOptions;
import edu.berkeley.nlp.lm.WordIndexer;
import edu.berkeley.nlp.lm.map.NgramMap;
import edu.berkeley.nlp.lm.util.LongRef;
import edu.berkeley.nlp.lm.values.CountValueContainer;
import java.io.Serializable;
import java.util.List;

public class StupidBackoffLm<W>
extends AbstractArrayEncodedNgramLanguageModel<W>
implements ArrayEncodedNgramLanguageModel<W>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final NgramMap<LongRef> map;
    private final float alpha;

    public StupidBackoffLm(int lmOrder, WordIndexer<W> wordIndexer, NgramMap<LongRef> map, ConfigOptions opts) {
        super(lmOrder, wordIndexer, (float)opts.unknownWordLogProb);
        this.map = map;
        this.alpha = (float)opts.stupidBackoffAlpha;
    }

    @Override
    public float getLogProb(int[] ngram, int startPos, int endPos) {
        NgramMap<LongRef> localMap = this.map;
        float logProb = this.oovWordLogProb;
        long probContext = 0L;
        int probContextOrder = -1;
        long backoffContext = 0L;
        int backoffContextOrder = -1;
        LongRef scratch = new LongRef(-1L);
        for (int i = endPos - 1; i >= startPos; --i) {
            assert (probContext >= 0L);
            if ((probContext = localMap.getValueAndOffset(probContext, probContextOrder, ngram[i], scratch)) < 0L) {
                return logProb;
            }
            long currCount = scratch.value;
            long backoffCount = -1L;
            if (i == endPos - 1) {
                backoffCount = ((CountValueContainer)this.map.getValues()).getUnigramSum();
            } else {
                backoffContext = localMap.getValueAndOffset(backoffContext, backoffContextOrder++, ngram[i], scratch);
                backoffCount = scratch.value;
            }
            logProb = (float)Math.log((float)currCount / (float)backoffCount * StupidBackoffLm.pow(this.alpha, i - startPos));
            ++probContextOrder;
        }
        return logProb;
    }

    public long getRawCount(int[] ngram, int startPos, int endPos) {
        NgramMap<LongRef> localMap = this.map;
        long probContext = 0L;
        LongRef scratch = new LongRef(-1L);
        for (int probContextOrder = -1; probContextOrder < endPos - startPos - 1; ++probContextOrder) {
            assert (probContext >= 0L);
            if ((probContext = localMap.getValueAndOffset(probContext, probContextOrder, ngram[endPos - probContextOrder - 2], scratch)) >= 0L) continue;
            return -1L;
        }
        return scratch.value;
    }

    private static float pow(float alpha, int n) {
        float ret = 1.0f;
        for (int i = 0; i < n; ++i) {
            ret *= alpha;
        }
        return ret;
    }

    @Override
    public float getLogProb(int[] ngram) {
        return ArrayEncodedNgramLanguageModel.DefaultImplementations.getLogProb(ngram, this);
    }

    @Override
    public float getLogProb(List<W> ngram) {
        return ArrayEncodedNgramLanguageModel.DefaultImplementations.getLogProb(ngram, this);
    }

    public NgramMap<LongRef> getNgramMap() {
        return this.map;
    }
}

