/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli.transfer;

import java.util.Locale;
import org.apache.maven.cli.transfer.AbstractMavenTransferListener;
import org.eclipse.aether.transfer.AbstractTransferListener;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jMavenTransferListener
extends AbstractTransferListener {
    protected final Logger out;

    public Slf4jMavenTransferListener() {
        this.out = LoggerFactory.getLogger(Slf4jMavenTransferListener.class);
    }

    public Slf4jMavenTransferListener(Logger out) {
        this.out = out;
    }

    public void transferInitiated(TransferEvent event) {
        String action = event.getRequestType() == TransferEvent.RequestType.PUT ? "Uploading" : "Downloading";
        TransferResource resource = event.getResource();
        this.out.info(action + ": " + resource.getRepositoryUrl() + resource.getResourceName());
    }

    public void transferCorrupted(TransferEvent event) throws TransferCancelledException {
        TransferResource resource = event.getResource();
        this.out.warn(event.getException().getMessage() + " for " + resource.getRepositoryUrl() + resource.getResourceName());
    }

    public void transferSucceeded(TransferEvent event) {
        TransferResource resource = event.getResource();
        long contentLength = event.getTransferredBytes();
        AbstractMavenTransferListener.FileSizeFormat format = new AbstractMavenTransferListener.FileSizeFormat(Locale.ENGLISH);
        String result = event.getRequestType() == TransferEvent.RequestType.PUT ? "Uploaded" : "Downloaded";
        String len = format.format(contentLength);
        String throughput = "";
        long duration = System.currentTimeMillis() - resource.getTransferStartTime();
        if (duration > 0L) {
            double bytesPerSecond = (double)contentLength / ((double)duration / 1000.0);
            throughput = " at " + format.format((long)bytesPerSecond) + "/s";
        }
        this.out.info(result + ": " + resource.getRepositoryUrl() + resource.getResourceName() + " (" + len + throughput + ")");
    }
}

