/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap.protocol;

import com.sun.mail.iap.ParsingException;
import com.sun.mail.iap.Response;
import com.sun.mail.imap.protocol.ENVELOPE;
import com.sun.mail.imap.protocol.FetchResponse;
import com.sun.mail.imap.protocol.Item;
import java.util.Vector;
import javax.mail.internet.ParameterList;

public class BODYSTRUCTURE
implements Item {
    static final char[] name = new char[]{'B', 'O', 'D', 'Y', 'S', 'T', 'R', 'U', 'C', 'T', 'U', 'R', 'E'};
    public int msgno;
    public String type;
    public String subtype;
    public String encoding;
    public int lines = -1;
    public int size = -1;
    public String disposition;
    public String id;
    public String description;
    public String md5;
    public String attachment;
    public ParameterList cParams;
    public ParameterList dParams;
    public String[] language;
    public BODYSTRUCTURE[] bodies;
    public ENVELOPE envelope;
    private static int SINGLE = 1;
    private static int MULTI = 2;
    private static int NESTED = 3;
    private int processedType;
    private static boolean parseDebug = false;

    public BODYSTRUCTURE(FetchResponse fetchResponse) throws ParsingException {
        if (parseDebug) {
            System.out.println("DEBUG IMAP: parsing BODYSTRUCTURE");
        }
        this.msgno = fetchResponse.getNumber();
        if (parseDebug) {
            System.out.println("DEBUG IMAP: msgno " + this.msgno);
        }
        fetchResponse.skipSpaces();
        if (fetchResponse.readByte() != 40) {
            throw new ParsingException("BODYSTRUCTURE parse error: missing ``('' at start");
        }
        if (fetchResponse.peekByte() == 40) {
            if (parseDebug) {
                System.out.println("DEBUG IMAP: parsing multipart");
            }
            this.type = "multipart";
            this.processedType = MULTI;
            Vector<BODYSTRUCTURE> vector = new Vector<BODYSTRUCTURE>(1);
            boolean bl = true;
            do {
                vector.addElement(new BODYSTRUCTURE(fetchResponse));
                fetchResponse.skipSpaces();
            } while (fetchResponse.peekByte() == 40);
            this.bodies = new BODYSTRUCTURE[vector.size()];
            vector.copyInto(this.bodies);
            this.subtype = fetchResponse.readString();
            if (parseDebug) {
                System.out.println("DEBUG IMAP: subtype " + this.subtype);
            }
            if (fetchResponse.readByte() == 41) {
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: parse DONE");
                }
                return;
            }
            if (parseDebug) {
                System.out.println("DEBUG IMAP: parsing extension data");
            }
            this.cParams = this.parseParameters(fetchResponse);
            if (fetchResponse.readByte() == 41) {
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: body parameters DONE");
                }
                return;
            }
            byte by = fetchResponse.readByte();
            if (by == 40) {
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: parse disposition");
                }
                this.disposition = fetchResponse.readString();
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: disposition " + this.disposition);
                }
                this.dParams = this.parseParameters(fetchResponse);
                if (fetchResponse.readByte() != 41) {
                    throw new ParsingException("BODYSTRUCTURE parse error: missing ``)'' at end of disposition in multipart");
                }
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: disposition DONE");
                }
            } else if (by == 78 || by == 110) {
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: disposition NIL");
                }
                fetchResponse.skip(2);
            } else {
                throw new ParsingException("BODYSTRUCTURE parse error: " + this.type + "/" + this.subtype + ": " + "bad multipart disposition, b " + by);
            }
            if ((by = fetchResponse.readByte()) == 41) {
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: no body-fld-lang");
                }
                return;
            }
            if (by != 32) {
                throw new ParsingException("BODYSTRUCTURE parse error: missing space after disposition");
            }
            if (fetchResponse.peekByte() == 40) {
                this.language = fetchResponse.readStringList();
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: language len " + this.language.length);
                }
            } else {
                String string = fetchResponse.readString();
                if (string != null) {
                    String[] stringArray = new String[]{string};
                    this.language = stringArray;
                    if (parseDebug) {
                        System.out.println("DEBUG IMAP: language " + string);
                    }
                }
            }
            while (fetchResponse.readByte() == 32) {
                this.parseBodyExtension(fetchResponse);
            }
        } else {
            if (parseDebug) {
                System.out.println("DEBUG IMAP: single part");
            }
            this.type = fetchResponse.readString();
            if (parseDebug) {
                System.out.println("DEBUG IMAP: type " + this.type);
            }
            this.processedType = SINGLE;
            this.subtype = fetchResponse.readString();
            if (parseDebug) {
                System.out.println("DEBUG IMAP: subtype " + this.subtype);
            }
            if (this.type == null) {
                this.type = "application";
                this.subtype = "octet-stream";
            }
            this.cParams = this.parseParameters(fetchResponse);
            if (parseDebug) {
                System.out.println("DEBUG IMAP: cParams " + this.cParams);
            }
            this.id = fetchResponse.readString();
            if (parseDebug) {
                System.out.println("DEBUG IMAP: id " + this.id);
            }
            this.description = fetchResponse.readString();
            if (parseDebug) {
                System.out.println("DEBUG IMAP: description " + this.description);
            }
            this.encoding = fetchResponse.readString();
            if (parseDebug) {
                System.out.println("DEBUG IMAP: encoding " + this.encoding);
            }
            this.size = fetchResponse.readNumber();
            if (parseDebug) {
                System.out.println("DEBUG IMAP: size " + this.size);
            }
            if (this.size < 0) {
                throw new ParsingException("BODYSTRUCTURE parse error: bad ``size'' element");
            }
            if (this.type.equalsIgnoreCase("text")) {
                this.lines = fetchResponse.readNumber();
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: lines " + this.lines);
                }
                if (this.lines < 0) {
                    throw new ParsingException("BODYSTRUCTURE parse error: bad ``lines'' element");
                }
            } else if (this.type.equalsIgnoreCase("message") && this.subtype.equalsIgnoreCase("rfc822")) {
                this.processedType = NESTED;
                this.envelope = new ENVELOPE(fetchResponse);
                BODYSTRUCTURE[] bODYSTRUCTUREArray = new BODYSTRUCTURE[]{new BODYSTRUCTURE(fetchResponse)};
                this.bodies = bODYSTRUCTUREArray;
                this.lines = fetchResponse.readNumber();
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: lines " + this.lines);
                }
                if (this.lines < 0) {
                    throw new ParsingException("BODYSTRUCTURE parse error: bad ``lines'' element");
                }
            } else {
                fetchResponse.skipSpaces();
                byte by = fetchResponse.peekByte();
                if (Character.isDigit((char)by)) {
                    throw new ParsingException("BODYSTRUCTURE parse error: server erroneously included ``lines'' element with type " + this.type + "/" + this.subtype);
                }
            }
            if (fetchResponse.peekByte() == 41) {
                fetchResponse.readByte();
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: parse DONE");
                }
                return;
            }
            this.md5 = fetchResponse.readString();
            if (fetchResponse.readByte() == 41) {
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: no MD5 DONE");
                }
                return;
            }
            byte by = fetchResponse.readByte();
            if (by == 40) {
                this.disposition = fetchResponse.readString();
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: disposition " + this.disposition);
                }
                this.dParams = this.parseParameters(fetchResponse);
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: dParams " + this.dParams);
                }
                if (fetchResponse.readByte() != 41) {
                    throw new ParsingException("BODYSTRUCTURE parse error: missing ``)'' at end of disposition");
                }
            } else if (by == 78 || by == 110) {
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: disposition NIL");
                }
                fetchResponse.skip(2);
            } else {
                throw new ParsingException("BODYSTRUCTURE parse error: " + this.type + "/" + this.subtype + ": " + "bad single part disposition, b " + by);
            }
            if (fetchResponse.readByte() == 41) {
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: disposition DONE");
                }
                return;
            }
            if (fetchResponse.peekByte() == 40) {
                this.language = fetchResponse.readStringList();
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: language len " + this.language.length);
                }
            } else {
                String string = fetchResponse.readString();
                if (string != null) {
                    String[] stringArray = new String[]{string};
                    this.language = stringArray;
                    if (parseDebug) {
                        System.out.println("DEBUG IMAP: language " + string);
                    }
                }
            }
            while (fetchResponse.readByte() == 32) {
                this.parseBodyExtension(fetchResponse);
            }
            if (parseDebug) {
                System.out.println("DEBUG IMAP: all DONE");
            }
        }
    }

    public boolean isMulti() {
        return this.processedType == MULTI;
    }

    public boolean isSingle() {
        return this.processedType == SINGLE;
    }

    public boolean isNested() {
        return this.processedType == NESTED;
    }

    private ParameterList parseParameters(Response response) throws ParsingException {
        response.skipSpaces();
        ParameterList parameterList = null;
        byte by = response.readByte();
        if (by == 40) {
            parameterList = new ParameterList();
            do {
                String string = response.readString();
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: parameter name " + string);
                }
                if (string == null) {
                    throw new ParsingException("BODYSTRUCTURE parse error: " + this.type + "/" + this.subtype + ": " + "null name in parameter list");
                }
                String string2 = response.readString();
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: parameter value " + string2);
                }
                parameterList.set(string, string2);
            } while (response.readByte() != 41);
            parameterList.set(null, "DONE");
        } else if (by == 78 || by == 110) {
            if (parseDebug) {
                System.out.println("DEBUG IMAP: parameter list NIL");
            }
            response.skip(2);
        } else {
            throw new ParsingException("Parameter list parse error");
        }
        return parameterList;
    }

    private void parseBodyExtension(Response response) throws ParsingException {
        response.skipSpaces();
        byte by = response.peekByte();
        if (by == 40) {
            response.skip(1);
            do {
                this.parseBodyExtension(response);
            } while (response.readByte() != 41);
        } else if (Character.isDigit((char)by)) {
            response.readNumber();
        } else {
            response.readString();
        }
    }

    static {
        try {
            String string = System.getProperty("mail.imap.parse.debug");
            parseDebug = string != null && string.equalsIgnoreCase("true");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

