/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.objectcatalog;

import ch.ehi.basics.i18n.MessageFormat;
import ch.ehi.basics.i18n.ResourceBundle;
import ch.ehi.basics.view.FileChooser;
import ch.ehi.basics.view.GenericFileFilter;
import ch.ehi.uml1_4.foundation.core.Namespace;
import ch.ehi.umleditor.application.LauncherView;
import ch.ehi.umleditor.application.PackageSelectionDialog;
import ch.ehi.umleditor.objectcatalog.HtmlWriter;
import ch.ehi.umleditor.umldrawingtools.ClassDiagramView;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsio.emf.EMFGraphics2D;
import org.freehep.graphicsio.svg.SVGGraphics2D;

public class ObjectCatalog {
    static java.util.ResourceBundle rsrc = ResourceBundle.getBundle(ObjectCatalog.class);

    public static void writeAllHtml() {
        ObjectCatalog.writeAllHtml(true);
    }

    public static void writeStructureHtml() {
        PackageSelectionDialog packageDialog = new PackageSelectionDialog((Frame)LauncherView.getInstance(), rsrc.getString("CTPackageSelector"), true, (Namespace)LauncherView.getInstance().getModel());
        if (packageDialog.isSaved()) {
            Namespace apackage = packageDialog.getSelectedPackage();
            if (apackage == null) {
                apackage = LauncherView.getInstance().getModel();
            }
            FileChooser saveDialog = new FileChooser(LauncherView.getSettings().getWorkingDirectory());
            saveDialog.setDialogTitle(rsrc.getString("CTstructFileSelector"));
            saveDialog.addChoosableFileFilter(GenericFileFilter.createHtmlFilter());
            if (saveDialog.showSaveDialog(LauncherView.getInstance()) == 0) {
                LauncherView.getSettings().setWorkingDirectory(saveDialog.getCurrentDirectory().getAbsolutePath());
                String filename = saveDialog.getSelectedFile().getAbsolutePath();
                BufferedWriter out = null;
                try {
                    out = new BufferedWriter(new FileWriter(filename));
                }
                catch (IOException ex) {
                    LauncherView.getInstance().log(rsrc.getString("CTstructLog"), ex.getLocalizedMessage());
                    return;
                }
                try {
                    HtmlWriter writer = new HtmlWriter();
                    writer.doStruct(apackage, out);
                    out.close();
                    LauncherView.getInstance().log(rsrc.getString("CTstructLog"), MessageFormat.format(rsrc, "CTstructDone", filename));
                }
                catch (IOException ex) {
                    LauncherView.getInstance().log(rsrc.getString("CTstructLog"), ex.getLocalizedMessage());
                }
            }
        }
    }

    public static void writeDiagram(ClassDiagramView diag) {
        String diagName = diag.getDiagram().getName().getValue();
        FileChooser saveDialog = new FileChooser(LauncherView.getSettings().getWorkingDirectory());
        saveDialog.setDialogTitle(rsrc.getString("CTdiagFileSelector"));
        GenericFileFilter jpegFilter = new GenericFileFilter("JPEG File Interchange Format (*.jpeg)", "jpeg");
        GenericFileFilter svgFilter = new GenericFileFilter("Scalable Vector Graphics (*.svg)", "svg");
        GenericFileFilter emfFilter = new GenericFileFilter("Windows Meta File Format (*.wmf)", "wmf");
        saveDialog.addChoosableFileFilter(jpegFilter);
        saveDialog.addChoosableFileFilter(svgFilter);
        saveDialog.addChoosableFileFilter(emfFilter);
        saveDialog.setSelectedFile(new File(diagName));
        if (saveDialog.showSaveDialog(LauncherView.getInstance()) == 0) {
            LauncherView.getSettings().setWorkingDirectory(saveDialog.getCurrentDirectory().getAbsolutePath());
            String filename = saveDialog.getSelectedFile().getAbsolutePath();
            try {
                Dimension diagDim = diag.getMinimumDimension();
                if (emfFilter.accept(saveDialog.getSelectedFile())) {
                    EMFGraphics2D g = new EMFGraphics2D(new File(filename), diagDim);
                    ((VectorGraphics)g).startExport();
                    diag.printAll(g);
                    ((VectorGraphics)g).endExport();
                } else if (svgFilter.accept(saveDialog.getSelectedFile())) {
                    SVGGraphics2D g = new SVGGraphics2D(new File(filename), diagDim);
                    ((VectorGraphics)g).startExport();
                    diag.printAll(g);
                    ((VectorGraphics)g).endExport();
                } else if (jpegFilter.accept(saveDialog.getSelectedFile())) {
                    BufferedImage img = new BufferedImage(diagDim.width, diagDim.height, 4);
                    Graphics2D g = img.createGraphics();
                    diag.printAll(g);
                    FileOutputStream os = new FileOutputStream(filename);
                    JPEGImageEncoder ie = JPEGCodec.createJPEGEncoder((OutputStream)os);
                    JPEGEncodeParam param = ie.getDefaultJPEGEncodeParam(img);
                    param.setQuality(1.0f, false);
                    ie.setJPEGEncodeParam(param);
                    ie.encode(img);
                    os.close();
                }
            }
            catch (IOException ex) {
                LauncherView.getInstance().log("objectcatalog", ex.getLocalizedMessage());
            }
        }
    }

    public static void writeAllHtml(boolean includeChapterNr) {
        PackageSelectionDialog packageDialog = new PackageSelectionDialog((Frame)LauncherView.getInstance(), rsrc.getString("CTPackageSelector"), true, (Namespace)LauncherView.getInstance().getModel());
        if (packageDialog.isSaved()) {
            Namespace apackage = packageDialog.getSelectedPackage();
            if (apackage == null) {
                apackage = LauncherView.getInstance().getModel();
            }
            FileChooser saveDialog = new FileChooser(LauncherView.getSettings().getWorkingDirectory());
            saveDialog.setDialogTitle(rsrc.getString("CTobjcatFileSelector"));
            saveDialog.addChoosableFileFilter(GenericFileFilter.createHtmlFilter());
            if (saveDialog.showSaveDialog(LauncherView.getInstance()) == 0) {
                LauncherView.getSettings().setWorkingDirectory(saveDialog.getCurrentDirectory().getAbsolutePath());
                String filename = saveDialog.getSelectedFile().getAbsolutePath();
                BufferedWriter out = null;
                try {
                    out = new BufferedWriter(new FileWriter(filename));
                }
                catch (IOException ex) {
                    LauncherView.getInstance().log(rsrc.getString("CTobjcatLog"), ex.getLocalizedMessage());
                    return;
                }
                try {
                    HtmlWriter writer = new HtmlWriter();
                    writer.setChapterNumbering(!includeChapterNr);
                    writer.doObjectCatalog(apackage, out);
                    out.close();
                    LauncherView.getInstance().log(rsrc.getString("CTobjcatLog"), MessageFormat.format(rsrc, "CTobjcatDone", filename));
                }
                catch (IOException ex) {
                    LauncherView.getInstance().log(rsrc.getString("CTobjcatLog"), ex.getLocalizedMessage());
                }
            }
        }
    }
}

