/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.array;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jruby.truffle.core.array.ArrayGuards;
import org.jruby.truffle.core.array.ArrayHelpers;
import org.jruby.truffle.core.array.ArrayMirror;
import org.jruby.truffle.core.array.ArrayStrategy;
import org.jruby.truffle.core.array.ArrayUtils;
import org.jruby.truffle.language.RubyNode;

@ImportStatic(value={ArrayGuards.class})
@NodeChildren(value={@NodeChild(value="array"), @NodeChild(value="other")})
public abstract class ArrayAppendManyNode
extends RubyNode {
    public abstract DynamicObject executeAppendMany(DynamicObject var1, DynamicObject var2);

    @Specialization(guards={"strategy.matches(array)", "otherStrategy.matches(other)", "generalized.equals(strategy)"}, limit="ARRAY_STRATEGIES")
    public DynamicObject appendManySameType(DynamicObject array, DynamicObject other, @Cached(value="of(array)") ArrayStrategy strategy, @Cached(value="of(other)") ArrayStrategy otherStrategy, @Cached(value="strategy.generalize(otherStrategy)") ArrayStrategy generalized, @Cached(value="createBinaryProfile()") ConditionProfile extendProfile) {
        int oldSize = strategy.getSize(array);
        int otherSize = otherStrategy.getSize(other);
        int newSize = oldSize + otherSize;
        ArrayMirror storeMirror = strategy.newMirror(array);
        ArrayMirror otherStoreMirror = otherStrategy.newMirror(other);
        if (extendProfile.profile(newSize > storeMirror.getLength())) {
            int capacity = ArrayUtils.capacity(this.getContext(), storeMirror.getLength(), newSize);
            ArrayMirror newStoreMirror = storeMirror.copyArrayAndMirror(capacity);
            otherStoreMirror.copyTo(newStoreMirror, 0, oldSize, otherSize);
            strategy.setStoreAndSize(array, newStoreMirror.getArray(), newSize);
        } else {
            otherStoreMirror.copyTo(storeMirror, 0, oldSize, otherSize);
            ArrayHelpers.setSize(array, newSize);
        }
        return array;
    }

    @Specialization(guards={"strategy.matches(array)", "otherStrategy.matches(other)", "!generalized.equals(strategy)"}, limit="ARRAY_STRATEGIES")
    public DynamicObject appendManyGeneralize(DynamicObject array, DynamicObject other, @Cached(value="of(array)") ArrayStrategy strategy, @Cached(value="of(other)") ArrayStrategy otherStrategy, @Cached(value="strategy.generalize(otherStrategy)") ArrayStrategy generalized, @Cached(value="createBinaryProfile()") ConditionProfile extendProfile) {
        int oldSize = strategy.getSize(array);
        int otherSize = otherStrategy.getSize(other);
        int newSize = oldSize + otherSize;
        ArrayMirror newStoreMirror = generalized.newArray(newSize);
        strategy.newMirror(array).copyTo(newStoreMirror, 0, 0, oldSize);
        otherStrategy.newMirror(other).copyTo(newStoreMirror, 0, oldSize, otherSize);
        generalized.setStoreAndSize(array, newStoreMirror.getArray(), newSize);
        return array;
    }
}

